/*
 * Decompiled with CFR 0.152.
 */
package org.pentaho.platform.repository2.unified.jcr;

import java.util.Locale;
import java.util.Map;
import java.util.Properties;
import org.apache.commons.lang.StringUtils;
import org.springframework.util.Assert;

public class LocalizationUtil {
    private Map<String, Properties> localePropertiesMap;
    private Locale locale;
    public static final String DEFAULT = "default";

    public LocalizationUtil(Map<String, Properties> localePropertiesMap, Locale locale) {
        Assert.notNull(localePropertiesMap);
        this.localePropertiesMap = localePropertiesMap;
        this.locale = locale;
    }

    public String resolveLocalizedString(String propertyName, String defaultValue) {
        String localizedString;
        if (this.locale != null) {
            localizedString = this.findLocalizedString(this.locale.toString(), propertyName);
            if (StringUtils.isNotBlank((String)localizedString)) {
                return localizedString;
            }
            localizedString = this.findLocalizedString(this.locale.getLanguage(), propertyName);
            if (StringUtils.isNotBlank((String)localizedString)) {
                return localizedString;
            }
        }
        if (StringUtils.isNotBlank((String)(localizedString = this.findLocalizedString(DEFAULT, propertyName)))) {
            return localizedString;
        }
        return defaultValue;
    }

    private String findLocalizedString(String locale, String propertyName) {
        Properties localeProperties;
        String localeString = locale;
        if (StringUtils.isBlank((String)localeString)) {
            localeString = DEFAULT;
        }
        if (this.localePropertiesMap != null && (localeProperties = this.localePropertiesMap.get(localeString)) != null && !localeProperties.isEmpty()) {
            return localeProperties.getProperty(propertyName);
        }
        return null;
    }
}

