/*
 * Decompiled with CFR 0.152.
 */
package org.pentaho.metaverse.service;

import java.io.File;
import java.util.List;
import java.util.Set;
import java.util.concurrent.ExecutionException;
import javax.ws.rs.BadRequestException;
import javax.ws.rs.Consumes;
import javax.ws.rs.GET;
import javax.ws.rs.POST;
import javax.ws.rs.Path;
import javax.ws.rs.PathParam;
import javax.ws.rs.Produces;
import javax.ws.rs.core.Context;
import javax.ws.rs.core.HttpHeaders;
import javax.ws.rs.core.MediaType;
import javax.ws.rs.core.Response;
import org.codehaus.enunciate.Facet;
import org.codehaus.enunciate.jaxrs.ResponseCode;
import org.codehaus.enunciate.jaxrs.StatusCodes;
import org.codehaus.enunciate.modules.jersey.ExternallyManagedLifecycle;
import org.pentaho.metaverse.api.IDocumentLocator;
import org.pentaho.metaverse.api.IDocumentLocatorProvider;
import org.pentaho.metaverse.api.ILineageCollector;
import org.pentaho.metaverse.api.IMetaverseReader;
import org.pentaho.metaverse.api.MetaverseLocatorException;
import org.pentaho.metaverse.api.model.LineageRequest;
import org.pentaho.metaverse.impl.MetaverseCompletionService;
import org.pentaho.metaverse.messages.Messages;
import org.pentaho.metaverse.service.LineageStreamingOutput;

@Path(value="/api")
@ExternallyManagedLifecycle
public class MetaverseService {
    private IMetaverseReader metaverseReader;
    private IDocumentLocatorProvider documentLocatorProvider;
    private ILineageCollector lineageCollector;
    private static final String DATE_FORMAT = "yyyyMMdd";
    private int count;
    public static final int OK = 200;
    public static final int BAD_REQUEST = 400;
    public static final int SERVER_ERROR = 500;

    public MetaverseService(IMetaverseReader metaverseReader, IDocumentLocatorProvider documentLocatorProvider) {
        this.setMetaverseReader(metaverseReader);
        this.setDocumentLocatorProvider(documentLocatorProvider);
    }

    public void setMetaverseReader(IMetaverseReader metaverseReader) {
        this.metaverseReader = metaverseReader;
    }

    public void setDocumentLocatorProvider(IDocumentLocatorProvider documentLocatorProvider) {
        this.documentLocatorProvider = documentLocatorProvider;
    }

    public void setLineageCollector(ILineageCollector collector) {
        this.lineageCollector = collector;
    }

    @GET
    @Path(value="/export")
    @Consumes(value={"*/*"})
    @Produces(value={"application/xml", "application/json", "text/plain"})
    @Facet(name="Unsupported")
    @StatusCodes(value={@ResponseCode(code=200, condition="Successfully created and returned graph."), @ResponseCode(code=500, condition="Server Error.")})
    public Response export(@Context HttpHeaders headers) {
        String format;
        List acceptTypes = headers.getAcceptableMediaTypes();
        String mediaType = ((MediaType)acceptTypes.get(0)).toString();
        if ("application/json".toString().equals(mediaType)) {
            format = "json";
        } else if ("text/plain".toString().equals(mediaType)) {
            format = "csv";
        } else {
            format = "xml";
            mediaType = "application/xml";
        }
        this.prepareMetaverse();
        if (this.metaverseReader == null) {
            return Response.serverError().entity((Object)Messages.getString((String)"ERROR.MetaverseReader.IsNull")).build();
        }
        return Response.ok((Object)this.metaverseReader.exportFormat(format), (String)mediaType).build();
    }

    @GET
    @Path(value="/download/all")
    @Produces(value={"application/zip"})
    @StatusCodes(value={@ResponseCode(code=200, condition="Successfully created and returned the zip file."), @ResponseCode(code=500, condition="Server Error.")})
    public Response download() {
        return this.download(null, null);
    }

    @GET
    @Path(value="/download/all/{startingDate}")
    @Produces(value={"application/zip"})
    @StatusCodes(value={@ResponseCode(code=200, condition="Successfully created and returned the zip file."), @ResponseCode(code=400, condition="Bad request, invalid starting date provided."), @ResponseCode(code=500, condition="Server Error.")})
    public Response download(@PathParam(value="startingDate") String startingDate) {
        return this.download(startingDate, null);
    }

    @GET
    @Path(value="/download/all/{startingDate}/{endingDate}")
    @Produces(value={"application/zip"})
    @StatusCodes(value={@ResponseCode(code=200, condition="Successfully created and returned the zip file."), @ResponseCode(code=400, condition="Bad request, invalid starting and/or ending date provided."), @ResponseCode(code=500, condition="Server Error.")})
    public Response download(@PathParam(value="startingDate") String startingDate, @PathParam(value="endingDate") String endingDate) {
        if (this.lineageCollector == null) {
            return Response.serverError().entity((Object)Messages.getString((String)"ERROR.LineageCollector.IsNull")).build();
        }
        String filename = "pentaho-lineage";
        if (startingDate != null) {
            filename = filename + "_" + startingDate;
        }
        if (endingDate != null) {
            filename = filename + "-" + endingDate;
        }
        filename = filename + ".zip";
        try {
            List artifacts = this.lineageCollector.listArtifacts(startingDate, endingDate);
            LineageStreamingOutput stream = new LineageStreamingOutput(artifacts, this.lineageCollector);
            return Response.ok((Object)stream).header("Content-Type", (Object)"application/zip").header("Content-Disposition", (Object)("inline; filename=" + filename)).build();
        }
        catch (IllegalArgumentException e) {
            throw new BadRequestException(Response.status((Response.Status)Response.Status.BAD_REQUEST).entity((Object)"Invalid date string provided. All dates must be valid and conform to this format yyyyMMdd").build());
        }
    }

    @POST
    @Path(value="/download/file")
    @Consumes(value={"application/json"})
    @Produces(value={"application/zip"})
    @StatusCodes(value={@ResponseCode(code=200, condition="Successfully created and returned the zip file."), @ResponseCode(code=500, condition="Server Error.")})
    public Response downloadFile(LineageRequest request) {
        return this.downloadFile(request, null, null);
    }

    @POST
    @Path(value="/download/file/{startingDate}")
    @Consumes(value={"application/json"})
    @Produces(value={"application/zip"})
    @StatusCodes(value={@ResponseCode(code=200, condition="Successfully created and returned the zip file."), @ResponseCode(code=400, condition="Bad request, invalid starting date provided."), @ResponseCode(code=500, condition="Server Error.")})
    public Response downloadFile(LineageRequest request, @PathParam(value="startingDate") String startingDate) {
        return this.downloadFile(request, startingDate, null);
    }

    @POST
    @Path(value="/download/file/{startingDate}/{endingDate}")
    @Consumes(value={"application/json"})
    @Produces(value={"application/zip"})
    @StatusCodes(value={@ResponseCode(code=200, condition="Successfully created and returned the zip file."), @ResponseCode(code=400, condition="Bad request, invalid starting and/or ending date provided."), @ResponseCode(code=500, condition="Server Error.")})
    public Response downloadFile(LineageRequest request, @PathParam(value="startingDate") String startingDate, @PathParam(value="endingDate") String endingDate) {
        if (this.lineageCollector == null) {
            return Response.serverError().entity((Object)Messages.getString((String)"ERROR.LineageCollector.IsNull")).build();
        }
        if (request == null || request.getPath() == null) {
            return Response.serverError().entity((Object)Messages.getString((String)"ERROR.NoPathFound")).build();
        }
        try {
            List artifacts = this.lineageCollector.listArtifactsForFile(request.getPath(), startingDate, endingDate);
            File f = new File(request.getPath());
            String filename = f.getName() + "_lineage";
            if (startingDate != null) {
                filename = filename + "_" + startingDate;
            }
            if (endingDate != null) {
                filename = filename + "-" + endingDate;
            }
            filename = filename + ".zip";
            LineageStreamingOutput stream = new LineageStreamingOutput(artifacts, this.lineageCollector);
            return Response.ok((Object)stream).header("Content-Type", (Object)"application/zip").header("Content-Disposition", (Object)("inline; filename=" + filename)).build();
        }
        catch (IllegalArgumentException e) {
            throw new BadRequestException(Response.status((Response.Status)Response.Status.BAD_REQUEST).entity((Object)"Invalid date string provided. All dates must be valid and conform to this format yyyyMMdd").build());
        }
    }

    protected void prepareMetaverse() {
        if (this.count++ == 0) {
            try {
                Set locators;
                if (this.documentLocatorProvider != null && (locators = this.documentLocatorProvider.getDocumentLocators()) != null) {
                    for (IDocumentLocator locator : locators) {
                        locator.startScan();
                    }
                }
                MetaverseCompletionService.getInstance().waitTillEmpty();
            }
            catch (MetaverseLocatorException e) {
                e.printStackTrace();
            }
            catch (InterruptedException e) {
                e.printStackTrace();
            }
            catch (ExecutionException e) {
                e.printStackTrace();
            }
        }
    }
}

