/*
 * Decompiled with CFR 0.152.
 */
package org.pentaho.metaverse.service;

import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.Set;
import javax.ws.rs.GET;
import javax.ws.rs.Path;
import javax.ws.rs.Produces;
import javax.ws.rs.core.Response;
import org.codehaus.enunciate.jaxrs.ResponseCode;
import org.codehaus.enunciate.jaxrs.StatusCodes;
import org.pentaho.metaverse.api.analyzer.kettle.jobentry.IJobEntryAnalyzer;
import org.pentaho.metaverse.api.analyzer.kettle.jobentry.IJobEntryAnalyzerProvider;
import org.pentaho.metaverse.api.analyzer.kettle.step.IStepAnalyzer;
import org.pentaho.metaverse.api.analyzer.kettle.step.IStepAnalyzerProvider;
import org.pentaho.metaverse.service.AnalyzerInfo;

@Path(value="/info")
public class AnalyzerInfoService {
    public static final int OK = 200;
    public static final int SERVER_ERROR = 500;
    private IStepAnalyzerProvider stepAnalyzerProvider;
    private IJobEntryAnalyzerProvider jobEntryAnalyzerProvider;

    public IStepAnalyzerProvider getStepAnalyzerProvider() {
        return this.stepAnalyzerProvider;
    }

    public void setStepAnalyzerProvider(IStepAnalyzerProvider stepAnalyzerProvider) {
        this.stepAnalyzerProvider = stepAnalyzerProvider;
    }

    public IJobEntryAnalyzerProvider getJobEntryAnalyzerProvider() {
        return this.jobEntryAnalyzerProvider;
    }

    public void setJobEntryAnalyzerProvider(IJobEntryAnalyzerProvider jobEntryAnalyzerProvider) {
        this.jobEntryAnalyzerProvider = jobEntryAnalyzerProvider;
    }

    @GET
    @Path(value="/steps")
    @Produces(value={"application/json"})
    @StatusCodes(value={@ResponseCode(code=200, condition="Successfully listed the supported steps"), @ResponseCode(code=500, condition="Server Error.")})
    public Response getSupportedSteps() {
        ArrayList<AnalyzerInfo> analyzers = new ArrayList<AnalyzerInfo>();
        for (IStepAnalyzer analyzer : this.getStepAnalyzerProvider().getAnalyzers()) {
            Set supportedSteps = analyzer.getSupportedSteps();
            for (Class supportedStep : supportedSteps) {
                AnalyzerInfo info = new AnalyzerInfo(supportedStep.getSimpleName());
                analyzers.add(info);
            }
        }
        Collections.sort(analyzers, new AnalyzerInfoComparator());
        return Response.ok(analyzers).build();
    }

    @GET
    @Path(value="/entries")
    @Produces(value={"application/json"})
    @StatusCodes(value={@ResponseCode(code=200, condition="Successfully listed the supported job entries"), @ResponseCode(code=500, condition="Server Error.")})
    public Response getSupportedJobEntries() {
        ArrayList<AnalyzerInfo> analyzers = new ArrayList<AnalyzerInfo>();
        for (IJobEntryAnalyzer analyzer : this.getJobEntryAnalyzerProvider().getAnalyzers()) {
            Set supportedEntries = analyzer.getSupportedEntries();
            for (Class supportedEntry : supportedEntries) {
                AnalyzerInfo info = new AnalyzerInfo(supportedEntry.getSimpleName());
                analyzers.add(info);
            }
        }
        Collections.sort(analyzers, new AnalyzerInfoComparator());
        return Response.ok(analyzers).build();
    }

    class AnalyzerInfoComparator
    implements Comparator<AnalyzerInfo> {
        AnalyzerInfoComparator() {
        }

        @Override
        public int compare(AnalyzerInfo left, AnalyzerInfo right) {
            return left.getMeta().compareTo(right.getMeta());
        }
    }
}

