/*
 * Decompiled with CFR 0.152.
 */
package org.apache.calcite.rel.mutable;

import com.google.common.base.Function;
import com.google.common.collect.Lists;
import java.util.AbstractList;
import java.util.ArrayList;
import java.util.List;
import org.apache.calcite.plan.RelOptUtil;
import org.apache.calcite.rel.RelNode;
import org.apache.calcite.rel.core.Aggregate;
import org.apache.calcite.rel.core.Calc;
import org.apache.calcite.rel.core.Collect;
import org.apache.calcite.rel.core.Correlate;
import org.apache.calcite.rel.core.Exchange;
import org.apache.calcite.rel.core.Filter;
import org.apache.calcite.rel.core.Intersect;
import org.apache.calcite.rel.core.Join;
import org.apache.calcite.rel.core.Minus;
import org.apache.calcite.rel.core.Project;
import org.apache.calcite.rel.core.Sample;
import org.apache.calcite.rel.core.SemiJoin;
import org.apache.calcite.rel.core.Sort;
import org.apache.calcite.rel.core.TableFunctionScan;
import org.apache.calcite.rel.core.TableModify;
import org.apache.calcite.rel.core.TableScan;
import org.apache.calcite.rel.core.Uncollect;
import org.apache.calcite.rel.core.Union;
import org.apache.calcite.rel.core.Values;
import org.apache.calcite.rel.core.Window;
import org.apache.calcite.rel.logical.LogicalAggregate;
import org.apache.calcite.rel.logical.LogicalCalc;
import org.apache.calcite.rel.logical.LogicalCorrelate;
import org.apache.calcite.rel.logical.LogicalExchange;
import org.apache.calcite.rel.logical.LogicalFilter;
import org.apache.calcite.rel.logical.LogicalIntersect;
import org.apache.calcite.rel.logical.LogicalJoin;
import org.apache.calcite.rel.logical.LogicalMinus;
import org.apache.calcite.rel.logical.LogicalProject;
import org.apache.calcite.rel.logical.LogicalSort;
import org.apache.calcite.rel.logical.LogicalTableFunctionScan;
import org.apache.calcite.rel.logical.LogicalTableModify;
import org.apache.calcite.rel.logical.LogicalUnion;
import org.apache.calcite.rel.logical.LogicalWindow;
import org.apache.calcite.rel.mutable.MutableAggregate;
import org.apache.calcite.rel.mutable.MutableCalc;
import org.apache.calcite.rel.mutable.MutableCollect;
import org.apache.calcite.rel.mutable.MutableCorrelate;
import org.apache.calcite.rel.mutable.MutableExchange;
import org.apache.calcite.rel.mutable.MutableFilter;
import org.apache.calcite.rel.mutable.MutableIntersect;
import org.apache.calcite.rel.mutable.MutableJoin;
import org.apache.calcite.rel.mutable.MutableLeafRel;
import org.apache.calcite.rel.mutable.MutableMinus;
import org.apache.calcite.rel.mutable.MutableProject;
import org.apache.calcite.rel.mutable.MutableRel;
import org.apache.calcite.rel.mutable.MutableRelVisitor;
import org.apache.calcite.rel.mutable.MutableSample;
import org.apache.calcite.rel.mutable.MutableScan;
import org.apache.calcite.rel.mutable.MutableSemiJoin;
import org.apache.calcite.rel.mutable.MutableSort;
import org.apache.calcite.rel.mutable.MutableTableFunctionScan;
import org.apache.calcite.rel.mutable.MutableTableModify;
import org.apache.calcite.rel.mutable.MutableUncollect;
import org.apache.calcite.rel.mutable.MutableUnion;
import org.apache.calcite.rel.mutable.MutableValues;
import org.apache.calcite.rel.mutable.MutableWindow;
import org.apache.calcite.rel.type.RelDataType;
import org.apache.calcite.rex.RexInputRef;
import org.apache.calcite.rex.RexNode;
import org.apache.calcite.rex.RexUtil;
import org.apache.calcite.util.Util;
import org.apache.calcite.util.mapping.Mappings;

public abstract class MutableRels {
    public static boolean contains(MutableRel ancestor, final MutableRel target) {
        if (ancestor.equals(target)) {
            return true;
        }
        try {
            new MutableRelVisitor(){

                @Override
                public void visit(MutableRel node) {
                    if (node.equals(target)) {
                        throw Util.FoundOne.NULL;
                    }
                    super.visit(node);
                }
            }.go(ancestor);
            return false;
        }
        catch (Util.FoundOne e) {
            return true;
        }
    }

    public static MutableRel preOrderTraverseNext(MutableRel node) {
        MutableRel parent = node.getParent();
        int ordinal = node.ordinalInParent + 1;
        while (parent != null) {
            if (parent.getInputs().size() > ordinal) {
                return parent.getInputs().get(ordinal);
            }
            node = parent;
            parent = node.getParent();
            ordinal = node.ordinalInParent + 1;
        }
        return null;
    }

    public static List<MutableRel> descendants(MutableRel query) {
        ArrayList<MutableRel> list = new ArrayList<MutableRel>();
        MutableRels.descendantsRecurse(list, query);
        return list;
    }

    private static void descendantsRecurse(List<MutableRel> list, MutableRel rel) {
        list.add(rel);
        for (MutableRel input : rel.getInputs()) {
            MutableRels.descendantsRecurse(list, input);
        }
    }

    public static MutableRel strip(MutableProject project) {
        return MutableRels.isTrivial(project) ? project.getInput() : project;
    }

    public static boolean isTrivial(MutableProject project) {
        MutableRel child = project.getInput();
        return RexUtil.isIdentity(project.projects, child.rowType);
    }

    public static MutableRel createProject(MutableRel child, final List<Integer> posList) {
        final RelDataType rowType = child.rowType;
        if (Mappings.isIdentity(posList, rowType.getFieldCount())) {
            return child;
        }
        return MutableProject.of(RelOptUtil.permute(child.cluster.getTypeFactory(), rowType, Mappings.bijection(posList)), child, (List<RexNode>)new AbstractList<RexNode>(){

            @Override
            public int size() {
                return posList.size();
            }

            @Override
            public RexNode get(int index) {
                int pos = (Integer)posList.get(index);
                return RexInputRef.of(pos, rowType);
            }
        });
    }

    public static MutableRel createCastRel(MutableRel rel, RelDataType castRowType, boolean rename) {
        RelDataType rowType = rel.rowType;
        if (RelOptUtil.areRowTypesEqual(rowType, castRowType, rename)) {
            return rel;
        }
        List<RexNode> castExps = RexUtil.generateCastExpressions(rel.cluster.getRexBuilder(), castRowType, rowType);
        List<String> fieldNames = rename ? castRowType.getFieldNames() : rowType.getFieldNames();
        return MutableProject.of(rel, castExps, fieldNames);
    }

    public static RelNode fromMutable(MutableRel node) {
        switch (node.type) {
            case TABLE_SCAN: 
            case VALUES: {
                return ((MutableLeafRel)node).rel;
            }
            case PROJECT: {
                MutableProject project = (MutableProject)node;
                return LogicalProject.create(MutableRels.fromMutable(project.input), project.projects, project.rowType);
            }
            case FILTER: {
                MutableFilter filter = (MutableFilter)node;
                return LogicalFilter.create(MutableRels.fromMutable(filter.input), filter.condition);
            }
            case AGGREGATE: {
                MutableAggregate aggregate = (MutableAggregate)node;
                return LogicalAggregate.create(MutableRels.fromMutable(aggregate.input), aggregate.indicator, aggregate.groupSet, aggregate.groupSets, aggregate.aggCalls);
            }
            case SORT: {
                MutableSort sort = (MutableSort)node;
                return LogicalSort.create(MutableRels.fromMutable(sort.input), sort.collation, sort.offset, sort.fetch);
            }
            case CALC: {
                MutableCalc calc = (MutableCalc)node;
                return LogicalCalc.create(MutableRels.fromMutable(calc.input), calc.program);
            }
            case EXCHANGE: {
                MutableExchange exchange = (MutableExchange)node;
                return LogicalExchange.create(MutableRels.fromMutable(exchange.getInput()), exchange.distribution);
            }
            case COLLECT: {
                MutableCollect collect = (MutableCollect)node;
                RelNode child = MutableRels.fromMutable(collect.getInput());
                return new Collect(collect.cluster, child.getTraitSet(), child, collect.fieldName);
            }
            case UNCOLLECT: {
                MutableUncollect uncollect = (MutableUncollect)node;
                RelNode child = MutableRels.fromMutable(uncollect.getInput());
                return Uncollect.create(child.getTraitSet(), child, uncollect.withOrdinality);
            }
            case WINDOW: {
                MutableWindow window = (MutableWindow)node;
                RelNode child = MutableRels.fromMutable(window.getInput());
                return LogicalWindow.create(child.getTraitSet(), child, window.constants, window.rowType, window.groups);
            }
            case TABLE_MODIFY: {
                MutableTableModify modify = (MutableTableModify)node;
                return LogicalTableModify.create(modify.table, modify.catalogReader, MutableRels.fromMutable(modify.getInput()), modify.operation, modify.updateColumnList, modify.sourceExpressionList, modify.flattened);
            }
            case SAMPLE: {
                MutableSample sample = (MutableSample)node;
                return new Sample(sample.cluster, MutableRels.fromMutable(sample.getInput()), sample.params);
            }
            case TABLE_FUNCTION_SCAN: {
                MutableTableFunctionScan tableFunctionScan = (MutableTableFunctionScan)node;
                return LogicalTableFunctionScan.create(tableFunctionScan.cluster, MutableRels.fromMutables(tableFunctionScan.getInputs()), tableFunctionScan.rexCall, tableFunctionScan.elementType, tableFunctionScan.rowType, tableFunctionScan.columnMappings);
            }
            case JOIN: {
                MutableJoin join = (MutableJoin)node;
                return LogicalJoin.create(MutableRels.fromMutable(join.getLeft()), MutableRels.fromMutable(join.getRight()), join.condition, join.variablesSet, join.joinType);
            }
            case SEMIJOIN: {
                MutableSemiJoin semiJoin = (MutableSemiJoin)node;
                return SemiJoin.create(MutableRels.fromMutable(semiJoin.getLeft()), MutableRels.fromMutable(semiJoin.getRight()), semiJoin.condition, semiJoin.leftKeys, semiJoin.rightKeys);
            }
            case CORRELATE: {
                MutableCorrelate correlate = (MutableCorrelate)node;
                return LogicalCorrelate.create(MutableRels.fromMutable(correlate.getLeft()), MutableRels.fromMutable(correlate.getRight()), correlate.correlationId, correlate.requiredColumns, correlate.joinType);
            }
            case UNION: {
                MutableUnion union = (MutableUnion)node;
                return LogicalUnion.create(MutableRels.fromMutables(union.inputs), union.all);
            }
            case MINUS: {
                MutableMinus minus = (MutableMinus)node;
                return LogicalMinus.create(MutableRels.fromMutables(minus.inputs), minus.all);
            }
            case INTERSECT: {
                MutableIntersect intersect = (MutableIntersect)node;
                return LogicalIntersect.create(MutableRels.fromMutables(intersect.inputs), intersect.all);
            }
        }
        throw new AssertionError((Object)node.deep());
    }

    private static List<RelNode> fromMutables(List<MutableRel> nodes) {
        return Lists.transform(nodes, (Function)new Function<MutableRel, RelNode>(){

            public RelNode apply(MutableRel mutableRel) {
                return MutableRels.fromMutable(mutableRel);
            }
        });
    }

    public static MutableRel toMutable(RelNode rel) {
        if (rel instanceof TableScan) {
            return MutableScan.of((TableScan)rel);
        }
        if (rel instanceof Values) {
            return MutableValues.of((Values)rel);
        }
        if (rel instanceof Project) {
            Project project = (Project)rel;
            MutableRel input = MutableRels.toMutable(project.getInput());
            return MutableProject.of(input, project.getProjects(), project.getRowType().getFieldNames());
        }
        if (rel instanceof Filter) {
            Filter filter = (Filter)rel;
            MutableRel input = MutableRels.toMutable(filter.getInput());
            return MutableFilter.of(input, filter.getCondition());
        }
        if (rel instanceof Aggregate) {
            Aggregate aggregate = (Aggregate)rel;
            MutableRel input = MutableRels.toMutable(aggregate.getInput());
            return MutableAggregate.of(input, aggregate.indicator, aggregate.getGroupSet(), aggregate.getGroupSets(), aggregate.getAggCallList());
        }
        if (rel instanceof Sort) {
            Sort sort = (Sort)rel;
            MutableRel input = MutableRels.toMutable(sort.getInput());
            return MutableSort.of(input, sort.getCollation(), sort.offset, sort.fetch);
        }
        if (rel instanceof Calc) {
            Calc calc = (Calc)rel;
            MutableRel input = MutableRels.toMutable(calc.getInput());
            return MutableCalc.of(input, calc.getProgram());
        }
        if (rel instanceof Exchange) {
            Exchange exchange = (Exchange)rel;
            MutableRel input = MutableRels.toMutable(exchange.getInput());
            return MutableExchange.of(input, exchange.getDistribution());
        }
        if (rel instanceof Collect) {
            Collect collect = (Collect)rel;
            MutableRel input = MutableRels.toMutable(collect.getInput());
            return MutableCollect.of(collect.getRowType(), input, collect.getFieldName());
        }
        if (rel instanceof Uncollect) {
            Uncollect uncollect = (Uncollect)rel;
            MutableRel input = MutableRels.toMutable(uncollect.getInput());
            return MutableUncollect.of(uncollect.getRowType(), input, uncollect.withOrdinality);
        }
        if (rel instanceof Window) {
            Window window = (Window)rel;
            MutableRel input = MutableRels.toMutable(window.getInput());
            return MutableWindow.of(window.getRowType(), input, window.groups, window.getConstants());
        }
        if (rel instanceof TableModify) {
            TableModify modify = (TableModify)rel;
            MutableRel input = MutableRels.toMutable(modify.getInput());
            return MutableTableModify.of(modify.getRowType(), input, modify.getTable(), modify.getCatalogReader(), modify.getOperation(), modify.getUpdateColumnList(), modify.getSourceExpressionList(), modify.isFlattened());
        }
        if (rel instanceof Sample) {
            Sample sample = (Sample)rel;
            MutableRel input = MutableRels.toMutable(sample.getInput());
            return MutableSample.of(input, sample.getSamplingParameters());
        }
        if (rel instanceof TableFunctionScan) {
            TableFunctionScan tableFunctionScan = (TableFunctionScan)rel;
            List<MutableRel> inputs = MutableRels.toMutables(tableFunctionScan.getInputs());
            return MutableTableFunctionScan.of(tableFunctionScan.getCluster(), tableFunctionScan.getRowType(), inputs, tableFunctionScan.getCall(), tableFunctionScan.getElementType(), tableFunctionScan.getColumnMappings());
        }
        if (rel instanceof SemiJoin) {
            SemiJoin semiJoin = (SemiJoin)rel;
            MutableRel left = MutableRels.toMutable(semiJoin.getLeft());
            MutableRel right = MutableRels.toMutable(semiJoin.getRight());
            return MutableSemiJoin.of(semiJoin.getRowType(), left, right, semiJoin.getCondition(), semiJoin.getLeftKeys(), semiJoin.getRightKeys());
        }
        if (rel instanceof Join) {
            Join join = (Join)rel;
            MutableRel left = MutableRels.toMutable(join.getLeft());
            MutableRel right = MutableRels.toMutable(join.getRight());
            return MutableJoin.of(join.getRowType(), left, right, join.getCondition(), join.getJoinType(), join.getVariablesSet());
        }
        if (rel instanceof Correlate) {
            Correlate correlate = (Correlate)rel;
            MutableRel left = MutableRels.toMutable(correlate.getLeft());
            MutableRel right = MutableRels.toMutable(correlate.getRight());
            return MutableCorrelate.of(correlate.getRowType(), left, right, correlate.getCorrelationId(), correlate.getRequiredColumns(), correlate.getJoinType());
        }
        if (rel instanceof Union) {
            Union union = (Union)rel;
            List<MutableRel> inputs = MutableRels.toMutables(union.getInputs());
            return MutableUnion.of(union.getRowType(), inputs, union.all);
        }
        if (rel instanceof Minus) {
            Minus minus = (Minus)rel;
            List<MutableRel> inputs = MutableRels.toMutables(minus.getInputs());
            return MutableMinus.of(minus.getRowType(), inputs, minus.all);
        }
        if (rel instanceof Intersect) {
            Intersect intersect = (Intersect)rel;
            List<MutableRel> inputs = MutableRels.toMutables(intersect.getInputs());
            return MutableIntersect.of(intersect.getRowType(), inputs, intersect.all);
        }
        throw new RuntimeException("cannot translate " + rel + " to MutableRel");
    }

    private static List<MutableRel> toMutables(List<RelNode> nodes) {
        return Lists.transform(nodes, (Function)new Function<RelNode, MutableRel>(){

            public MutableRel apply(RelNode relNode) {
                return MutableRels.toMutable(relNode);
            }
        });
    }
}

