/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.mapred;

import com.google.common.annotations.VisibleForTesting;
import java.io.DataInput;
import java.io.DataOutput;
import java.io.IOException;
import java.io.InputStream;
import java.lang.management.GarbageCollectorMXBean;
import java.lang.management.ManagementFactory;
import java.text.NumberFormat;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.NoSuchElementException;
import java.util.concurrent.atomic.AtomicBoolean;
import javax.crypto.SecretKey;
import org.apache.hadoop.classification.InterfaceAudience;
import org.apache.hadoop.classification.InterfaceStability;
import org.apache.hadoop.conf.Configurable;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.FileSystem;
import org.apache.hadoop.fs.LocalDirAllocator;
import org.apache.hadoop.fs.LocalFileSystem;
import org.apache.hadoop.fs.Path;
import org.apache.hadoop.io.BytesWritable;
import org.apache.hadoop.io.DataInputBuffer;
import org.apache.hadoop.io.RawComparator;
import org.apache.hadoop.io.Text;
import org.apache.hadoop.io.Writable;
import org.apache.hadoop.io.WritableUtils;
import org.apache.hadoop.io.serializer.Deserializer;
import org.apache.hadoop.io.serializer.SerializationFactory;
import org.apache.hadoop.mapred.AMFeedback;
import org.apache.hadoop.mapred.Counters;
import org.apache.hadoop.mapred.FileOutputCommitter;
import org.apache.hadoop.mapred.FileOutputFormat;
import org.apache.hadoop.mapred.IFile;
import org.apache.hadoop.mapred.InputSplit;
import org.apache.hadoop.mapred.JobConf;
import org.apache.hadoop.mapred.JobContext;
import org.apache.hadoop.mapred.JobContextImpl;
import org.apache.hadoop.mapred.JobID;
import org.apache.hadoop.mapred.MROutputFiles;
import org.apache.hadoop.mapred.MapOutputFile;
import org.apache.hadoop.mapred.OutputCollector;
import org.apache.hadoop.mapred.RawKeyValueIterator;
import org.apache.hadoop.mapred.Reducer;
import org.apache.hadoop.mapred.Reporter;
import org.apache.hadoop.mapred.SortedRanges;
import org.apache.hadoop.mapred.TaskStatus;
import org.apache.hadoop.mapred.TaskUmbilicalProtocol;
import org.apache.hadoop.mapreduce.FileSystemCounter;
import org.apache.hadoop.mapreduce.JobStatus;
import org.apache.hadoop.mapreduce.OutputCommitter;
import org.apache.hadoop.mapreduce.OutputFormat;
import org.apache.hadoop.mapreduce.RecordWriter;
import org.apache.hadoop.mapreduce.Reducer;
import org.apache.hadoop.mapreduce.StatusReporter;
import org.apache.hadoop.mapreduce.TaskAttemptContext;
import org.apache.hadoop.mapreduce.TaskAttemptID;
import org.apache.hadoop.mapreduce.TaskCounter;
import org.apache.hadoop.mapreduce.lib.reduce.WrappedReducer;
import org.apache.hadoop.mapreduce.task.ReduceContextImpl;
import org.apache.hadoop.mapreduce.task.TaskAttemptContextImpl;
import org.apache.hadoop.mapreduce.util.MRJobConfUtil;
import org.apache.hadoop.net.NetUtils;
import org.apache.hadoop.util.ExitUtil;
import org.apache.hadoop.util.Progress;
import org.apache.hadoop.util.Progressable;
import org.apache.hadoop.util.ReflectionUtils;
import org.apache.hadoop.util.ShutdownHookManager;
import org.apache.hadoop.util.StringInterner;
import org.apache.hadoop.util.StringUtils;
import org.apache.hadoop.yarn.util.ResourceCalculatorProcessTree;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@InterfaceAudience.LimitedPrivate(value={"MapReduce"})
@InterfaceStability.Unstable
public abstract class Task
implements Writable,
Configurable {
    private static final Logger LOG = LoggerFactory.getLogger(Task.class);
    public static String MERGED_OUTPUT_PREFIX = ".merged";
    public static final long DEFAULT_COMBINE_RECORDS_BEFORE_PROGRESS = 10000L;
    private static final String HDFS_URI_SCHEME = "hdfs";
    protected static final String FILESYSTEM_COUNTER_GROUP = "FileSystemCounters";
    private static final NumberFormat NUMBER_FORMAT = NumberFormat.getInstance();
    private String jobFile;
    private String user;
    private org.apache.hadoop.mapred.TaskAttemptID taskId;
    private int partition;
    private byte[] encryptedSpillKey = new byte[]{0};
    TaskStatus taskStatus;
    protected JobStatus.State jobRunStateForCleanup;
    protected boolean jobCleanup = false;
    protected boolean jobSetup = false;
    protected boolean taskCleanup = false;
    protected BytesWritable extraData = new BytesWritable();
    private SortedRanges skipRanges = new SortedRanges();
    private boolean skipping = false;
    private boolean writeSkipRecs = true;
    private volatile long currentRecStartIndex;
    private Iterator<Long> currentRecIndexIterator = this.skipRanges.skipRangeIterator();
    private ResourceCalculatorProcessTree pTree;
    private long initCpuCumulativeTime = -1L;
    protected JobConf conf;
    protected MapOutputFile mapOutputFile;
    protected LocalDirAllocator lDirAlloc;
    private static final int MAX_RETRIES = 10;
    protected JobContext jobContext;
    protected org.apache.hadoop.mapred.TaskAttemptContext taskContext;
    protected OutputFormat<?, ?> outputFormat;
    protected OutputCommitter committer;
    protected final Counters.Counter spilledRecordsCounter;
    protected final Counters.Counter failedShuffleCounter;
    protected final Counters.Counter mergedMapOutputsCounter;
    private int numSlotsRequired;
    protected TaskUmbilicalProtocol umbilical;
    protected SecretKey tokenSecret;
    protected SecretKey shuffleSecret;
    protected GcTimeUpdater gcUpdater;
    final AtomicBoolean mustPreempt = new AtomicBoolean(false);
    private boolean uberized = false;
    private transient Progress taskProgress = new Progress();
    private transient Counters counters = new Counters();
    private AtomicBoolean taskDone = new AtomicBoolean(false);
    private Map<String, FileSystemStatisticUpdater> statisticUpdaters = new HashMap<String, FileSystemStatisticUpdater>();

    protected static String[] getFileSystemCounterNames(String uriScheme) {
        String scheme = StringUtils.toUpperCase((String)uriScheme);
        return new String[]{scheme + "_BYTES_READ", scheme + "_BYTES_WRITTEN"};
    }

    static synchronized String getOutputName(int partition) {
        return "part-" + NUMBER_FORMAT.format(partition);
    }

    public Task() {
        this.taskStatus = TaskStatus.createTaskStatus(this.isMapTask());
        this.taskId = new org.apache.hadoop.mapred.TaskAttemptID();
        this.spilledRecordsCounter = (Counters.Counter)this.counters.findCounter(TaskCounter.SPILLED_RECORDS);
        this.failedShuffleCounter = (Counters.Counter)this.counters.findCounter(TaskCounter.FAILED_SHUFFLE);
        this.mergedMapOutputsCounter = (Counters.Counter)this.counters.findCounter(TaskCounter.MERGED_MAP_OUTPUTS);
        this.gcUpdater = new GcTimeUpdater();
    }

    public Task(String jobFile, org.apache.hadoop.mapred.TaskAttemptID taskId, int partition, int numSlotsRequired) {
        this.jobFile = jobFile;
        this.taskId = taskId;
        this.partition = partition;
        this.numSlotsRequired = numSlotsRequired;
        this.taskStatus = TaskStatus.createTaskStatus(this.isMapTask(), this.taskId, 0.0f, numSlotsRequired, TaskStatus.State.UNASSIGNED, "", "", "", this.isMapTask() ? TaskStatus.Phase.MAP : TaskStatus.Phase.SHUFFLE, this.counters);
        this.spilledRecordsCounter = (Counters.Counter)this.counters.findCounter(TaskCounter.SPILLED_RECORDS);
        this.failedShuffleCounter = (Counters.Counter)this.counters.findCounter(TaskCounter.FAILED_SHUFFLE);
        this.mergedMapOutputsCounter = (Counters.Counter)this.counters.findCounter(TaskCounter.MERGED_MAP_OUTPUTS);
        this.gcUpdater = new GcTimeUpdater();
    }

    @VisibleForTesting
    void setTaskDone() {
        this.taskDone.set(true);
    }

    public void setJobFile(String jobFile) {
        this.jobFile = jobFile;
    }

    public String getJobFile() {
        return this.jobFile;
    }

    public org.apache.hadoop.mapred.TaskAttemptID getTaskID() {
        return this.taskId;
    }

    public int getNumSlotsRequired() {
        return this.numSlotsRequired;
    }

    Counters getCounters() {
        return this.counters;
    }

    public JobID getJobID() {
        return this.taskId.getJobID();
    }

    public void setJobTokenSecret(SecretKey tokenSecret) {
        this.tokenSecret = tokenSecret;
    }

    public byte[] getEncryptedSpillKey() {
        return this.encryptedSpillKey;
    }

    public void setEncryptedSpillKey(byte[] encryptedSpillKey) {
        if (encryptedSpillKey != null) {
            this.encryptedSpillKey = encryptedSpillKey;
        }
    }

    public SecretKey getJobTokenSecret() {
        return this.tokenSecret;
    }

    public void setShuffleSecret(SecretKey shuffleSecret) {
        this.shuffleSecret = shuffleSecret;
    }

    public SecretKey getShuffleSecret() {
        return this.shuffleSecret;
    }

    public int getPartition() {
        return this.partition;
    }

    public synchronized TaskStatus.Phase getPhase() {
        return this.taskStatus.getPhase();
    }

    protected synchronized void setPhase(TaskStatus.Phase phase) {
        this.taskStatus.setPhase(phase);
    }

    protected boolean toWriteSkipRecs() {
        return this.writeSkipRecs;
    }

    protected void setWriteSkipRecs(boolean writeSkipRecs) {
        this.writeSkipRecs = writeSkipRecs;
    }

    protected void reportFatalError(org.apache.hadoop.mapred.TaskAttemptID id, Throwable throwable, String logMsg) {
        LOG.error(logMsg);
        if (ShutdownHookManager.get().isShutdownInProgress()) {
            return;
        }
        Throwable tCause = throwable.getCause();
        String cause = tCause == null ? StringUtils.stringifyException((Throwable)throwable) : StringUtils.stringifyException((Throwable)tCause);
        try {
            this.umbilical.fatalError(id, cause);
        }
        catch (IOException ioe) {
            LOG.error("Failed to contact the tasktracker", (Throwable)ioe);
            System.exit(-1);
        }
    }

    protected static List<FileSystem.Statistics> getFsStatistics(Path path, Configuration conf) throws IOException {
        ArrayList<FileSystem.Statistics> matchedStats = new ArrayList<FileSystem.Statistics>();
        path = path.getFileSystem(conf).makeQualified(path);
        String scheme = path.toUri().getScheme();
        for (FileSystem.Statistics stats : FileSystem.getAllStatistics()) {
            if (!stats.getScheme().equals(scheme)) continue;
            matchedStats.add(stats);
        }
        return matchedStats;
    }

    public SortedRanges getSkipRanges() {
        return this.skipRanges;
    }

    public void setSkipRanges(SortedRanges skipRanges) {
        this.skipRanges = skipRanges;
    }

    public boolean isSkipping() {
        return this.skipping;
    }

    public void setSkipping(boolean skipping) {
        this.skipping = skipping;
    }

    synchronized TaskStatus.State getState() {
        return this.taskStatus.getRunState();
    }

    synchronized void setState(TaskStatus.State state) {
        this.taskStatus.setRunState(state);
    }

    void setTaskCleanupTask() {
        this.taskCleanup = true;
    }

    boolean isTaskCleanupTask() {
        return this.taskCleanup;
    }

    boolean isJobCleanupTask() {
        return this.jobCleanup;
    }

    boolean isJobAbortTask() {
        return this.isJobCleanupTask() && (this.jobRunStateForCleanup == JobStatus.State.KILLED || this.jobRunStateForCleanup == JobStatus.State.FAILED);
    }

    boolean isJobSetupTask() {
        return this.jobSetup;
    }

    void setJobSetupTask() {
        this.jobSetup = true;
    }

    void setJobCleanupTask() {
        this.jobCleanup = true;
    }

    void setJobCleanupTaskState(JobStatus.State status) {
        this.jobRunStateForCleanup = status;
    }

    boolean isMapOrReduce() {
        return !this.jobSetup && !this.jobCleanup && !this.taskCleanup;
    }

    String getUser() {
        return this.user;
    }

    void setUser(String user) {
        this.user = user;
    }

    public void write(DataOutput out) throws IOException {
        Text.writeString((DataOutput)out, (String)this.jobFile);
        this.taskId.write(out);
        out.writeInt(this.partition);
        out.writeInt(this.numSlotsRequired);
        this.taskStatus.write(out);
        this.skipRanges.write(out);
        out.writeBoolean(this.skipping);
        out.writeBoolean(this.jobCleanup);
        if (this.jobCleanup) {
            WritableUtils.writeEnum((DataOutput)out, (Enum)this.jobRunStateForCleanup);
        }
        out.writeBoolean(this.jobSetup);
        out.writeBoolean(this.writeSkipRecs);
        out.writeBoolean(this.taskCleanup);
        Text.writeString((DataOutput)out, (String)this.user);
        out.writeInt(this.encryptedSpillKey.length);
        this.extraData.write(out);
        out.write(this.encryptedSpillKey);
    }

    public void readFields(DataInput in) throws IOException {
        this.jobFile = StringInterner.weakIntern((String)Text.readString((DataInput)in));
        this.taskId = org.apache.hadoop.mapred.TaskAttemptID.read(in);
        this.partition = in.readInt();
        this.numSlotsRequired = in.readInt();
        this.taskStatus.readFields(in);
        this.skipRanges.readFields(in);
        this.currentRecIndexIterator = this.skipRanges.skipRangeIterator();
        this.currentRecStartIndex = this.currentRecIndexIterator.next();
        this.skipping = in.readBoolean();
        this.jobCleanup = in.readBoolean();
        if (this.jobCleanup) {
            this.jobRunStateForCleanup = (JobStatus.State)WritableUtils.readEnum((DataInput)in, JobStatus.State.class);
        }
        this.jobSetup = in.readBoolean();
        this.writeSkipRecs = in.readBoolean();
        this.taskCleanup = in.readBoolean();
        if (this.taskCleanup) {
            this.setPhase(TaskStatus.Phase.CLEANUP);
        }
        this.user = StringInterner.weakIntern((String)Text.readString((DataInput)in));
        int len = in.readInt();
        this.encryptedSpillKey = new byte[len];
        this.extraData.readFields(in);
        in.readFully(this.encryptedSpillKey);
    }

    public String toString() {
        return this.taskId.toString();
    }

    public void localizeConfiguration(JobConf conf) throws IOException {
        conf.set("mapreduce.task.id", this.taskId.getTaskID().toString());
        conf.set("mapreduce.task.attempt.id", this.taskId.toString());
        conf.setBoolean("mapreduce.task.ismap", this.isMapTask());
        conf.setInt("mapreduce.task.partition", this.partition);
        conf.set("mapreduce.job.id", this.taskId.getJobID().toString());
    }

    public abstract void run(JobConf var1, TaskUmbilicalProtocol var2) throws IOException, ClassNotFoundException, InterruptedException;

    public abstract boolean isMapTask();

    public Progress getProgress() {
        return this.taskProgress;
    }

    public void initialize(JobConf job, JobID id, Reporter reporter, boolean useNewApi) throws IOException, ClassNotFoundException, InterruptedException {
        this.jobContext = new JobContextImpl(job, id, reporter);
        this.taskContext = new org.apache.hadoop.mapred.TaskAttemptContextImpl(job, this.taskId, reporter);
        if (this.getState() == TaskStatus.State.UNASSIGNED) {
            this.setState(TaskStatus.State.RUNNING);
        }
        if (useNewApi) {
            if (LOG.isDebugEnabled()) {
                LOG.debug("using new api for output committer");
            }
            this.outputFormat = (OutputFormat)ReflectionUtils.newInstance(this.taskContext.getOutputFormatClass(), (Configuration)job);
            this.committer = this.outputFormat.getOutputCommitter(this.taskContext);
        } else {
            this.committer = this.conf.getOutputCommitter();
        }
        Path outputPath = FileOutputFormat.getOutputPath(this.conf);
        if (outputPath != null) {
            if (this.committer instanceof FileOutputCommitter) {
                FileOutputFormat.setWorkOutputPath(this.conf, ((FileOutputCommitter)this.committer).getTaskAttemptPath(this.taskContext));
            } else {
                FileOutputFormat.setWorkOutputPath(this.conf, outputPath);
            }
        }
        this.committer.setupTask(this.taskContext);
        Class clazz = this.conf.getClass("mapreduce.job.process-tree.class", null, ResourceCalculatorProcessTree.class);
        this.pTree = ResourceCalculatorProcessTree.getResourceCalculatorProcessTree((String)System.getenv().get("JVM_PID"), (Class)clazz, (Configuration)this.conf);
        LOG.info(" Using ResourceCalculatorProcessTree : " + this.pTree);
        if (this.pTree != null) {
            this.pTree.updateProcessTree();
            this.initCpuCumulativeTime = this.pTree.getCumulativeCpuTime();
        }
    }

    public static String normalizeStatus(String status, Configuration conf) {
        int progressStatusLength = conf.getInt("mapreduce.task.max.status.length", 512);
        if (status.length() > progressStatusLength) {
            LOG.warn("Task status: \"" + status + "\" truncated to max limit (" + progressStatusLength + " characters)");
            status = status.substring(0, progressStatusLength);
        }
        return status;
    }

    protected void reportNextRecordRange(TaskUmbilicalProtocol umbilical, long nextRecIndex) throws IOException {
        long len = nextRecIndex - this.currentRecStartIndex + 1L;
        SortedRanges.Range range = new SortedRanges.Range(this.currentRecStartIndex, len);
        this.taskStatus.setNextRecordRange(range);
        if (LOG.isDebugEnabled()) {
            LOG.debug("sending reportNextRecordRange " + range);
        }
        umbilical.reportNextRecordRange(this.taskId, range);
    }

    TaskReporter startReporter(TaskUmbilicalProtocol umbilical) {
        TaskReporter reporter = new TaskReporter(this.getProgress(), umbilical);
        reporter.startCommunicationThread();
        return reporter;
    }

    void updateResourceCounters() {
        TaskCounter counter;
        this.updateHeapUsageCounter();
        if (this.pTree == null) {
            return;
        }
        this.pTree.updateProcessTree();
        long cpuTime = this.pTree.getCumulativeCpuTime();
        long pMem = this.pTree.getRssMemorySize();
        long vMem = this.pTree.getVirtualMemorySize();
        if (cpuTime != -1L && this.initCpuCumulativeTime != -1L) {
            cpuTime -= this.initCpuCumulativeTime;
        }
        if (cpuTime != -1L) {
            ((Counters.Counter)this.counters.findCounter(TaskCounter.CPU_MILLISECONDS)).setValue(cpuTime);
        }
        if (pMem != -1L) {
            ((Counters.Counter)this.counters.findCounter(TaskCounter.PHYSICAL_MEMORY_BYTES)).setValue(pMem);
        }
        if (vMem != -1L) {
            ((Counters.Counter)this.counters.findCounter(TaskCounter.VIRTUAL_MEMORY_BYTES)).setValue(vMem);
        }
        if (pMem != -1L) {
            counter = this.isMapTask() ? TaskCounter.MAP_PHYSICAL_MEMORY_BYTES_MAX : TaskCounter.REDUCE_PHYSICAL_MEMORY_BYTES_MAX;
            Counters.Counter pMemCounter = (Counters.Counter)this.counters.findCounter(counter);
            pMemCounter.setValue(Math.max(pMemCounter.getValue(), pMem));
        }
        if (vMem != -1L) {
            counter = this.isMapTask() ? TaskCounter.MAP_VIRTUAL_MEMORY_BYTES_MAX : TaskCounter.REDUCE_VIRTUAL_MEMORY_BYTES_MAX;
            Counters.Counter vMemCounter = (Counters.Counter)this.counters.findCounter(counter);
            vMemCounter.setValue(Math.max(vMemCounter.getValue(), vMem));
        }
    }

    private synchronized void updateCounters() {
        HashMap map = new HashMap();
        for (FileSystem.Statistics statistics : FileSystem.getAllStatistics()) {
            List<FileSystem.Statistics> list;
            String uriScheme = statistics.getScheme();
            if (map.containsKey(uriScheme)) {
                list = (List)map.get(uriScheme);
                list.add(statistics);
                continue;
            }
            list = new ArrayList();
            list.add(statistics);
            map.put(uriScheme, list);
        }
        for (Map.Entry entry : map.entrySet()) {
            FileSystemStatisticUpdater updater = this.statisticUpdaters.get(entry.getKey());
            if (updater == null) {
                updater = new FileSystemStatisticUpdater((List)entry.getValue(), (String)entry.getKey());
                this.statisticUpdaters.put((String)entry.getKey(), updater);
            }
            updater.updateCounters();
        }
        this.gcUpdater.incrementGcCounter();
        this.updateResourceCounters();
    }

    private void updateHeapUsageCounter() {
        long currentHeapUsage = Runtime.getRuntime().totalMemory();
        ((Counters.Counter)this.counters.findCounter(TaskCounter.COMMITTED_HEAP_BYTES)).setValue(currentHeapUsage);
    }

    public void done(TaskUmbilicalProtocol umbilical, TaskReporter reporter) throws IOException, InterruptedException {
        this.updateCounters();
        if (this.taskStatus.getRunState() == TaskStatus.State.PREEMPTED) {
            this.committer.commitTask(this.taskContext);
            umbilical.preempted(this.taskId, this.taskStatus);
            this.taskDone.set(true);
            reporter.stopCommunicationThread();
            return;
        }
        LOG.info("Task:" + this.taskId + " is done. And is in the process of committing");
        boolean commitRequired = this.isCommitRequired();
        if (commitRequired) {
            int retries = 10;
            this.setState(TaskStatus.State.COMMIT_PENDING);
            while (true) {
                try {
                    umbilical.commitPending(this.taskId, this.taskStatus);
                }
                catch (InterruptedException interruptedException) {
                    continue;
                }
                catch (IOException ie) {
                    LOG.warn("Failure sending commit pending: " + StringUtils.stringifyException((Throwable)ie));
                    if (--retries != 0) continue;
                    System.exit(67);
                    continue;
                }
                break;
            }
            this.commit(umbilical, reporter, this.committer);
        }
        this.taskDone.set(true);
        reporter.stopCommunicationThread();
        this.updateCounters();
        this.sendLastUpdate(umbilical);
        this.sendDone(umbilical);
        LOG.info("Final Counters for " + this.taskId + ": " + this.getCounters().toString());
    }

    boolean isCommitRequired() throws IOException {
        boolean commitRequired = false;
        if (this.isMapOrReduce()) {
            commitRequired = this.committer.needsTaskCommit(this.taskContext);
        }
        return commitRequired;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public void statusUpdate(TaskUmbilicalProtocol umbilical) throws IOException {
        int retries = 10;
        while (true) {
            try {
                block7: {
                    block6: {
                        if (umbilical.statusUpdate(this.getTaskID(), this.taskStatus).getTaskFound()) break block6;
                        if (this.uberized) break block7;
                        LOG.warn("Parent died.  Exiting " + this.taskId);
                        ExitUtil.terminate((int)66);
                    }
                    this.taskStatus.clearStatus();
                    return;
                }
                LOG.warn("Task no longer available: " + this.taskId);
                return;
            }
            catch (InterruptedException ie) {
                Thread.currentThread().interrupt();
                continue;
            }
            catch (IOException ie) {
                LOG.warn("Failure sending status update: " + StringUtils.stringifyException((Throwable)ie));
                if (--retries == 0) throw ie;
                continue;
            }
            break;
        }
    }

    private void sendLastUpdate(TaskUmbilicalProtocol umbilical) throws IOException {
        this.taskStatus.setOutputSize(this.calculateOutputSize());
        this.taskStatus.statusUpdate(this.taskProgress.get(), this.taskProgress.toString(), this.counters);
        this.statusUpdate(umbilical);
    }

    private long calculateOutputSize() throws IOException {
        if (!this.isMapOrReduce()) {
            return -1L;
        }
        if (this.isMapTask() && this.conf.getNumReduceTasks() > 0) {
            try {
                Path mapOutput = this.mapOutputFile.getOutputFile();
                LocalFileSystem localFS = FileSystem.getLocal((Configuration)this.conf);
                return localFS.getFileStatus(mapOutput).getLen();
            }
            catch (IOException e) {
                LOG.warn("Could not find output size ", (Throwable)e);
            }
        }
        return -1L;
    }

    private void sendDone(TaskUmbilicalProtocol umbilical) throws IOException {
        int retries = 10;
        while (true) {
            try {
                umbilical.done(this.getTaskID());
                LOG.info("Task '" + this.taskId + "' done.");
                return;
            }
            catch (IOException ie) {
                LOG.warn("Failure signalling completion: " + StringUtils.stringifyException((Throwable)ie));
                if (--retries != 0) continue;
                throw ie;
            }
            break;
        }
    }

    private void commit(TaskUmbilicalProtocol umbilical, TaskReporter reporter, OutputCommitter committer) throws IOException {
        int retries = 10;
        while (true) {
            try {
                while (!umbilical.canCommit(this.taskId)) {
                    try {
                        Thread.sleep(1000L);
                    }
                    catch (InterruptedException interruptedException) {
                        // empty catch block
                    }
                    reporter.setProgressFlag();
                }
            }
            catch (IOException ie) {
                LOG.warn("Failure asking whether task can commit: " + StringUtils.stringifyException((Throwable)ie));
                if (--retries != 0) continue;
                this.discardOutput(this.taskContext);
                System.exit(68);
                continue;
            }
            break;
        }
        try {
            LOG.info("Task " + this.taskId + " is allowed to commit now");
            committer.commitTask(this.taskContext);
            return;
        }
        catch (IOException iee) {
            LOG.warn("Failure committing: " + StringUtils.stringifyException((Throwable)iee));
            this.discardOutput(this.taskContext);
            throw iee;
        }
    }

    private void discardOutput(org.apache.hadoop.mapred.TaskAttemptContext taskContext) {
        try {
            this.committer.abortTask(taskContext);
        }
        catch (IOException ioe) {
            LOG.warn("Failure cleaning up: " + StringUtils.stringifyException((Throwable)ioe));
        }
    }

    protected void runTaskCleanupTask(TaskUmbilicalProtocol umbilical, TaskReporter reporter) throws IOException, InterruptedException {
        this.taskCleanup(umbilical);
        this.done(umbilical, reporter);
    }

    void taskCleanup(TaskUmbilicalProtocol umbilical) throws IOException {
        this.setPhase(TaskStatus.Phase.CLEANUP);
        this.getProgress().setStatus("cleanup");
        this.statusUpdate(umbilical);
        LOG.info("Running cleanup for the task");
        this.committer.abortTask(this.taskContext);
    }

    protected void runJobCleanupTask(TaskUmbilicalProtocol umbilical, TaskReporter reporter) throws IOException, InterruptedException {
        this.setPhase(TaskStatus.Phase.CLEANUP);
        this.getProgress().setStatus("cleanup");
        this.statusUpdate(umbilical);
        LOG.info("Cleaning up job");
        if (this.jobRunStateForCleanup == JobStatus.State.FAILED || this.jobRunStateForCleanup == JobStatus.State.KILLED) {
            LOG.info("Aborting job with runstate : " + this.jobRunStateForCleanup.name());
            if (this.conf.getUseNewMapper()) {
                this.committer.abortJob(this.jobContext, this.jobRunStateForCleanup);
            } else {
                org.apache.hadoop.mapred.OutputCommitter oldCommitter = (org.apache.hadoop.mapred.OutputCommitter)this.committer;
                oldCommitter.abortJob((org.apache.hadoop.mapreduce.JobContext)this.jobContext, this.jobRunStateForCleanup);
            }
        } else if (this.jobRunStateForCleanup == JobStatus.State.SUCCEEDED) {
            LOG.info("Committing job");
            this.committer.commitJob(this.jobContext);
        } else {
            throw new IOException("Invalid state of the job for cleanup. State found " + (Object)((Object)this.jobRunStateForCleanup) + " expecting " + (Object)((Object)JobStatus.State.SUCCEEDED) + ", " + (Object)((Object)JobStatus.State.FAILED) + " or " + (Object)((Object)JobStatus.State.KILLED));
        }
        JobConf conf = new JobConf(this.jobContext.getConfiguration());
        if (!this.keepTaskFiles(conf)) {
            String jobTempDir = conf.get("mapreduce.job.dir");
            Path jobTempDirPath = new Path(jobTempDir);
            FileSystem fs = jobTempDirPath.getFileSystem((Configuration)conf);
            fs.delete(jobTempDirPath, true);
        }
        this.done(umbilical, reporter);
    }

    protected boolean keepTaskFiles(JobConf conf) {
        return conf.getKeepTaskFilesPattern() != null || conf.getKeepFailedTaskFiles();
    }

    protected void runJobSetupTask(TaskUmbilicalProtocol umbilical, TaskReporter reporter) throws IOException, InterruptedException {
        this.getProgress().setStatus("setup");
        this.committer.setupJob(this.jobContext);
        this.done(umbilical, reporter);
    }

    public void setConf(Configuration conf) {
        this.conf = conf instanceof JobConf ? (JobConf)conf : new JobConf(conf);
        this.mapOutputFile = (MapOutputFile)ReflectionUtils.newInstance((Class)conf.getClass("mapreduce.task.local.output.class", MROutputFiles.class, MapOutputFile.class), (Configuration)conf);
        this.lDirAlloc = new LocalDirAllocator("mapreduce.cluster.local.dir");
        String[] hostToResolved = conf.getStrings("mapreduce.job.net.static.resolutions");
        if (hostToResolved != null) {
            for (String str : hostToResolved) {
                String name = str.substring(0, str.indexOf(61));
                String resolvedName = str.substring(str.indexOf(61) + 1);
                NetUtils.addStaticResolution((String)name, (String)resolvedName);
            }
        }
        this.uberized = conf.getBoolean("mapreduce.task.uberized", false);
    }

    public Configuration getConf() {
        return this.conf;
    }

    public MapOutputFile getMapOutputFile() {
        return this.mapOutputFile;
    }

    protected static <INKEY, INVALUE, OUTKEY, OUTVALUE> Reducer.Context createReduceContext(org.apache.hadoop.mapreduce.Reducer<INKEY, INVALUE, OUTKEY, OUTVALUE> reducer, Configuration job, TaskAttemptID taskId, RawKeyValueIterator rIter, org.apache.hadoop.mapreduce.Counter inputKeyCounter, org.apache.hadoop.mapreduce.Counter inputValueCounter, RecordWriter<OUTKEY, OUTVALUE> output, OutputCommitter committer, StatusReporter reporter, RawComparator<INKEY> comparator, Class<INKEY> keyClass, Class<INVALUE> valueClass) throws IOException, InterruptedException {
        ReduceContextImpl<INKEY, INVALUE, OUTKEY, OUTVALUE> reduceContext = new ReduceContextImpl<INKEY, INVALUE, OUTKEY, OUTVALUE>(job, taskId, rIter, inputKeyCounter, inputValueCounter, output, committer, reporter, comparator, keyClass, valueClass);
        Reducer.Context reducerContext = new WrappedReducer<INKEY, INVALUE, OUTKEY, OUTVALUE>().getReducerContext(reduceContext);
        return reducerContext;
    }

    BytesWritable getExtraData() {
        return this.extraData;
    }

    void setExtraData(BytesWritable extraData) {
        this.extraData = extraData;
    }

    static {
        NUMBER_FORMAT.setMinimumIntegerDigits(5);
        NUMBER_FORMAT.setGroupingUsed(false);
    }

    @InterfaceAudience.Private
    @InterfaceStability.Unstable
    protected static class NewCombinerRunner<K, V>
    extends CombinerRunner<K, V> {
        private final Class<? extends org.apache.hadoop.mapreduce.Reducer<K, V, K, V>> reducerClass;
        private final TaskAttemptID taskId;
        private final RawComparator<K> comparator;
        private final Class<K> keyClass;
        private final Class<V> valueClass;
        private final OutputCommitter committer;

        NewCombinerRunner(Class reducerClass, JobConf job, TaskAttemptID taskId, TaskAttemptContext context, Counters.Counter inputCounter, TaskReporter reporter, OutputCommitter committer) {
            super(inputCounter, job, reporter);
            this.reducerClass = reducerClass;
            this.taskId = taskId;
            this.keyClass = context.getMapOutputKeyClass();
            this.valueClass = context.getMapOutputValueClass();
            this.comparator = context.getCombinerKeyGroupingComparator();
            this.committer = committer;
        }

        @Override
        public void combine(RawKeyValueIterator iterator, OutputCollector<K, V> collector) throws IOException, InterruptedException, ClassNotFoundException {
            org.apache.hadoop.mapreduce.Reducer reducer = (org.apache.hadoop.mapreduce.Reducer)ReflectionUtils.newInstance(this.reducerClass, (Configuration)this.job);
            Reducer.Context reducerContext = Task.createReduceContext(reducer, this.job, this.taskId, iterator, null, this.inputCounter, new OutputConverter<K, V>(collector), this.committer, this.reporter, this.comparator, this.keyClass, this.valueClass);
            reducer.run(reducerContext);
        }

        private static class OutputConverter<K, V>
        extends RecordWriter<K, V> {
            OutputCollector<K, V> output;

            OutputConverter(OutputCollector<K, V> output) {
                this.output = output;
            }

            @Override
            public void close(TaskAttemptContext context) {
            }

            @Override
            public void write(K key, V value) throws IOException, InterruptedException {
                this.output.collect(key, value);
            }
        }
    }

    @InterfaceAudience.Private
    @InterfaceStability.Unstable
    protected static class OldCombinerRunner<K, V>
    extends CombinerRunner<K, V> {
        private final Class<? extends Reducer<K, V, K, V>> combinerClass;
        private final Class<K> keyClass;
        private final Class<V> valueClass;
        private final RawComparator<K> comparator;

        protected OldCombinerRunner(Class<? extends Reducer<K, V, K, V>> cls, JobConf conf, Counters.Counter inputCounter, TaskReporter reporter) {
            super(inputCounter, conf, reporter);
            this.combinerClass = cls;
            this.keyClass = this.job.getMapOutputKeyClass();
            this.valueClass = this.job.getMapOutputValueClass();
            this.comparator = this.job.getCombinerKeyGroupingComparator();
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void combine(RawKeyValueIterator kvIter, OutputCollector<K, V> combineCollector) throws IOException {
            try (Reducer combiner = (Reducer)ReflectionUtils.newInstance(this.combinerClass, (Configuration)this.job);){
                CombineValuesIterator<K, V> values = new CombineValuesIterator<K, V>(kvIter, this.comparator, this.keyClass, this.valueClass, this.job, this.reporter, this.inputCounter);
                while (values.more()) {
                    combiner.reduce(values.getKey(), values, combineCollector, this.reporter);
                    values.nextKey();
                }
            }
        }
    }

    @InterfaceAudience.LimitedPrivate(value={"MapReduce"})
    @InterfaceStability.Unstable
    public static abstract class CombinerRunner<K, V> {
        protected final Counters.Counter inputCounter;
        protected final JobConf job;
        protected final TaskReporter reporter;

        CombinerRunner(Counters.Counter inputCounter, JobConf job, TaskReporter reporter) {
            this.inputCounter = inputCounter;
            this.job = job;
            this.reporter = reporter;
        }

        public abstract void combine(RawKeyValueIterator var1, OutputCollector<K, V> var2) throws IOException, InterruptedException, ClassNotFoundException;

        public static <K, V> CombinerRunner<K, V> create(JobConf job, org.apache.hadoop.mapred.TaskAttemptID taskId, Counters.Counter inputCounter, TaskReporter reporter, OutputCommitter committer) throws ClassNotFoundException {
            Class<? extends Reducer> cls = job.getCombinerClass();
            if (cls != null) {
                return new OldCombinerRunner(cls, job, inputCounter, reporter);
            }
            TaskAttemptContextImpl taskContext = new TaskAttemptContextImpl(job, taskId, reporter);
            Class<? extends org.apache.hadoop.mapreduce.Reducer<?, ?, ?, ?>> newcls = taskContext.getCombinerClass();
            if (newcls != null) {
                return new NewCombinerRunner(newcls, job, taskId, taskContext, inputCounter, reporter, committer);
            }
            return null;
        }
    }

    @InterfaceAudience.Private
    @InterfaceStability.Unstable
    public static class CombineValuesIterator<KEY, VALUE>
    extends ValuesIterator<KEY, VALUE> {
        private final Counters.Counter combineInputCounter;

        public CombineValuesIterator(RawKeyValueIterator in, RawComparator<KEY> comparator, Class<KEY> keyClass, Class<VALUE> valClass, Configuration conf, Reporter reporter, Counters.Counter combineInputCounter) throws IOException {
            super(in, comparator, keyClass, valClass, conf, reporter);
            this.combineInputCounter = combineInputCounter;
        }

        @Override
        public VALUE next() {
            this.combineInputCounter.increment(1L);
            return super.next();
        }
    }

    static class ValuesIterator<KEY, VALUE>
    implements Iterator<VALUE> {
        protected RawKeyValueIterator in;
        private KEY key;
        private KEY nextKey;
        private VALUE value;
        private boolean hasNext;
        private boolean more;
        private RawComparator<KEY> comparator;
        protected Progressable reporter;
        private Deserializer<KEY> keyDeserializer;
        private Deserializer<VALUE> valDeserializer;
        private DataInputBuffer keyIn = new DataInputBuffer();
        private DataInputBuffer valueIn = new DataInputBuffer();
        private int ctr = 0;

        public ValuesIterator(RawKeyValueIterator in, RawComparator<KEY> comparator, Class<KEY> keyClass, Class<VALUE> valClass, Configuration conf, Progressable reporter) throws IOException {
            this.in = in;
            this.comparator = comparator;
            this.reporter = reporter;
            SerializationFactory serializationFactory = new SerializationFactory(conf);
            this.keyDeserializer = serializationFactory.getDeserializer(keyClass);
            this.keyDeserializer.open((InputStream)this.keyIn);
            this.valDeserializer = serializationFactory.getDeserializer(valClass);
            this.valDeserializer.open((InputStream)this.valueIn);
            this.readNextKey();
            this.key = this.nextKey;
            this.nextKey = null;
            this.hasNext = this.more;
        }

        RawKeyValueIterator getRawIterator() {
            return this.in;
        }

        @Override
        public boolean hasNext() {
            return this.hasNext;
        }

        @Override
        public VALUE next() {
            if (!this.hasNext) {
                throw new NoSuchElementException("iterate past last value");
            }
            try {
                this.readNextValue();
                this.readNextKey();
            }
            catch (IOException ie) {
                throw new RuntimeException("problem advancing post rec#" + this.ctr, ie);
            }
            this.reporter.progress();
            return this.value;
        }

        @Override
        public void remove() {
            throw new RuntimeException("not implemented");
        }

        public void nextKey() throws IOException {
            while (this.hasNext) {
                this.readNextKey();
            }
            ++this.ctr;
            KEY tmpKey = this.key;
            this.key = this.nextKey;
            this.nextKey = tmpKey;
            this.hasNext = this.more;
        }

        public boolean more() {
            return this.more;
        }

        public KEY getKey() {
            return this.key;
        }

        private void readNextKey() throws IOException {
            this.more = this.in.next();
            if (this.more) {
                DataInputBuffer nextKeyBytes = this.in.getKey();
                this.keyIn.reset(nextKeyBytes.getData(), nextKeyBytes.getPosition(), nextKeyBytes.getLength());
                this.nextKey = this.keyDeserializer.deserialize(this.nextKey);
                this.hasNext = this.key != null && this.comparator.compare(this.key, this.nextKey) == 0;
            } else {
                this.hasNext = false;
            }
        }

        private void readNextValue() throws IOException {
            DataInputBuffer nextValueBytes = this.in.getValue();
            this.valueIn.reset(nextValueBytes.getData(), nextValueBytes.getPosition(), nextValueBytes.getLength());
            this.value = this.valDeserializer.deserialize(this.value);
        }
    }

    @InterfaceAudience.Private
    @InterfaceStability.Unstable
    public static class CombineOutputCollector<K, V>
    implements OutputCollector<K, V> {
        private IFile.Writer<K, V> writer;
        private Counters.Counter outCounter;
        private Progressable progressable;
        private long progressBar;

        public CombineOutputCollector(Counters.Counter outCounter, Progressable progressable, Configuration conf) {
            this.outCounter = outCounter;
            this.progressable = progressable;
            this.progressBar = conf.getLong("mapreduce.task.combine.progress.records", 10000L);
        }

        public synchronized void setWriter(IFile.Writer<K, V> writer) {
            this.writer = writer;
        }

        @Override
        public synchronized void collect(K key, V value) throws IOException {
            this.outCounter.increment(1L);
            this.writer.append(key, value);
            if (this.outCounter.getValue() % this.progressBar == 0L) {
                this.progressable.progress();
            }
        }
    }

    class FileSystemStatisticUpdater {
        private List<FileSystem.Statistics> stats;
        private Counters.Counter readBytesCounter;
        private Counters.Counter writeBytesCounter;
        private Counters.Counter readOpsCounter;
        private Counters.Counter largeReadOpsCounter;
        private Counters.Counter writeOpsCounter;
        private Counters.Counter readBytesEcCounter;
        private String scheme;

        FileSystemStatisticUpdater(List<FileSystem.Statistics> stats, String scheme) {
            this.stats = stats;
            this.scheme = scheme;
        }

        void updateCounters() {
            if (this.readBytesCounter == null) {
                this.readBytesCounter = (Counters.Counter)Task.this.counters.findCounter(this.scheme, FileSystemCounter.BYTES_READ);
            }
            if (this.writeBytesCounter == null) {
                this.writeBytesCounter = (Counters.Counter)Task.this.counters.findCounter(this.scheme, FileSystemCounter.BYTES_WRITTEN);
            }
            if (this.readOpsCounter == null) {
                this.readOpsCounter = (Counters.Counter)Task.this.counters.findCounter(this.scheme, FileSystemCounter.READ_OPS);
            }
            if (this.largeReadOpsCounter == null) {
                this.largeReadOpsCounter = (Counters.Counter)Task.this.counters.findCounter(this.scheme, FileSystemCounter.LARGE_READ_OPS);
            }
            if (this.writeOpsCounter == null) {
                this.writeOpsCounter = (Counters.Counter)Task.this.counters.findCounter(this.scheme, FileSystemCounter.WRITE_OPS);
            }
            if (this.readBytesEcCounter == null && this.scheme.equals(Task.HDFS_URI_SCHEME)) {
                this.readBytesEcCounter = (Counters.Counter)Task.this.counters.findCounter(this.scheme, FileSystemCounter.BYTES_READ_EC);
            }
            long readBytes = 0L;
            long writeBytes = 0L;
            long readOps = 0L;
            long largeReadOps = 0L;
            long writeOps = 0L;
            long readBytesEC = 0L;
            for (FileSystem.Statistics stat : this.stats) {
                readBytes += stat.getBytesRead();
                writeBytes += stat.getBytesWritten();
                readOps += (long)stat.getReadOps();
                largeReadOps += (long)stat.getLargeReadOps();
                writeOps += (long)stat.getWriteOps();
                readBytesEC += stat.getBytesReadErasureCoded();
            }
            this.readBytesCounter.setValue(readBytes);
            this.writeBytesCounter.setValue(writeBytes);
            this.readOpsCounter.setValue(readOps);
            this.largeReadOpsCounter.setValue(largeReadOps);
            this.writeOpsCounter.setValue(writeOps);
            if (this.readBytesEcCounter != null) {
                this.readBytesEcCounter.setValue(readBytesEC);
            }
        }
    }

    class GcTimeUpdater {
        private long lastGcMillis = 0L;
        private List<GarbageCollectorMXBean> gcBeans = ManagementFactory.getGarbageCollectorMXBeans();

        public GcTimeUpdater() {
            this.getElapsedGc();
        }

        protected long getElapsedGc() {
            long thisGcMillis = 0L;
            for (GarbageCollectorMXBean gcBean : this.gcBeans) {
                thisGcMillis += gcBean.getCollectionTime();
            }
            long delta = thisGcMillis - this.lastGcMillis;
            this.lastGcMillis = thisGcMillis;
            return delta;
        }

        public void incrementGcCounter() {
            if (null == Task.this.counters) {
                return;
            }
            Counters.Counter gcCounter = (Counters.Counter)Task.this.counters.findCounter(TaskCounter.GC_TIME_MILLIS);
            if (null != gcCounter) {
                gcCounter.increment(this.getElapsedGc());
            }
        }
    }

    @InterfaceAudience.LimitedPrivate(value={"MapReduce"})
    @InterfaceStability.Unstable
    public class TaskReporter
    extends StatusReporter
    implements Runnable,
    Reporter {
        private TaskUmbilicalProtocol umbilical;
        private InputSplit split = null;
        private Progress taskProgress;
        private Thread pingThread = null;
        private boolean done = true;
        private Object lock = new Object();
        private AtomicBoolean progressFlag = new AtomicBoolean(false);

        @VisibleForTesting
        public TaskReporter(Progress taskProgress, TaskUmbilicalProtocol umbilical) {
            this.umbilical = umbilical;
            this.taskProgress = taskProgress;
        }

        void setProgressFlag() {
            this.progressFlag.set(true);
        }

        boolean resetProgressFlag() {
            return this.progressFlag.getAndSet(false);
        }

        @Override
        public void setStatus(String status) {
            this.taskProgress.setStatus(Task.normalizeStatus(status, Task.this.conf));
            this.setProgressFlag();
        }

        public void setProgress(float progress) {
            this.taskProgress.phase().set(progress);
            this.setProgressFlag();
        }

        @Override
        public float getProgress() {
            return this.taskProgress.getProgress();
        }

        @Override
        public void progress() {
            this.setProgressFlag();
        }

        @Override
        public Counters.Counter getCounter(String group, String name) {
            Counters.Counter counter = null;
            if (Task.this.counters != null) {
                counter = Task.this.counters.findCounter(group, name);
            }
            return counter;
        }

        @Override
        public Counters.Counter getCounter(Enum<?> name) {
            return Task.this.counters == null ? null : (Counters.Counter)Task.this.counters.findCounter(name);
        }

        public void incrCounter(Enum key, long amount) {
            if (Task.this.counters != null) {
                Task.this.counters.incrCounter(key, amount);
            }
            this.setProgressFlag();
        }

        @Override
        public void incrCounter(String group, String counter, long amount) {
            if (Task.this.counters != null) {
                Task.this.counters.incrCounter(group, counter, amount);
            }
            if (Task.this.skipping && "SkippingTaskCounters".equals(group) && ("MapProcessedRecords".equals(counter) || "ReduceProcessedGroups".equals(counter))) {
                int i = 0;
                while ((long)i < amount) {
                    Task.this.currentRecStartIndex = (Long)Task.this.currentRecIndexIterator.next();
                    ++i;
                }
            }
            this.setProgressFlag();
        }

        public void setInputSplit(InputSplit split) {
            this.split = split;
        }

        @Override
        public InputSplit getInputSplit() throws UnsupportedOperationException {
            if (this.split == null) {
                throw new UnsupportedOperationException("Input only available on map");
            }
            return this.split;
        }

        protected void checkTaskLimits() throws TaskLimitException {
            long limit = Task.this.conf.getLong("mapreduce.task.local-fs.write-limit.bytes", -1L);
            if (limit >= 0L) {
                Counters.Counter localWritesCounter = null;
                try {
                    LocalFileSystem localFS = FileSystem.getLocal((Configuration)Task.this.conf);
                    localWritesCounter = (Counters.Counter)Task.this.counters.findCounter(localFS.getScheme(), FileSystemCounter.BYTES_WRITTEN);
                }
                catch (IOException e) {
                    LOG.warn("Could not get LocalFileSystem BYTES_WRITTEN counter");
                }
                if (localWritesCounter != null && localWritesCounter.getCounter() > limit) {
                    throw new TaskLimitException("too much write to local file system. current value is " + localWritesCounter.getCounter() + " the limit is " + limit);
                }
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void run() {
            int MAX_RETRIES = 3;
            int remainingRetries = 3;
            boolean sendProgress = this.resetProgressFlag();
            long taskProgressInterval = MRJobConfUtil.getTaskProgressReportInterval(Task.this.conf);
            while (!Task.this.taskDone.get()) {
                Object object = this.lock;
                synchronized (object) {
                    this.done = false;
                }
                try {
                    boolean taskFound = true;
                    AMFeedback amFeedback = null;
                    Object object2 = this.lock;
                    synchronized (object2) {
                        if (Task.this.taskDone.get()) {
                            break;
                        }
                        this.lock.wait(taskProgressInterval);
                    }
                    if (Task.this.taskDone.get()) break;
                    if (sendProgress) {
                        Task.this.updateCounters();
                        this.checkTaskLimits();
                        Task.this.taskStatus.statusUpdate(this.taskProgress.get(), this.taskProgress.toString(), Task.this.counters);
                        amFeedback = this.umbilical.statusUpdate(Task.this.taskId, Task.this.taskStatus);
                        taskFound = amFeedback.getTaskFound();
                        Task.this.taskStatus.clearStatus();
                    } else {
                        amFeedback = this.umbilical.statusUpdate(Task.this.taskId, null);
                        taskFound = amFeedback.getTaskFound();
                    }
                    if (!taskFound) {
                        if (Task.this.uberized) {
                            Task.this.taskDone.set(true);
                            break;
                        }
                        LOG.warn("Parent died.  Exiting " + Task.this.taskId);
                        this.resetDoneFlag();
                        System.exit(66);
                    }
                    boolean lastPreempt = Task.this.mustPreempt.get();
                    Task.this.mustPreempt.set(Task.this.mustPreempt.get() || amFeedback.getPreemption());
                    if (lastPreempt ^ Task.this.mustPreempt.get()) {
                        LOG.info("PREEMPTION TASK: setting mustPreempt to " + Task.this.mustPreempt.get() + " given " + amFeedback.getPreemption() + " for " + Task.this.taskId + " task status: " + (Object)((Object)Task.this.taskStatus.getPhase()));
                    }
                    sendProgress = this.resetProgressFlag();
                    remainingRetries = 3;
                }
                catch (TaskLimitException e) {
                    String errMsg = "Task exceeded the limits: " + StringUtils.stringifyException((Throwable)e);
                    LOG.error(errMsg);
                    try {
                        this.umbilical.fatalError(Task.this.taskId, errMsg);
                    }
                    catch (IOException ioe) {
                        LOG.error("Failed to update failure diagnosis", (Throwable)ioe);
                    }
                    LOG.error("Killing " + Task.this.taskId);
                    this.resetDoneFlag();
                    ExitUtil.terminate((int)69);
                }
                catch (Throwable t) {
                    LOG.info("Communication exception: " + StringUtils.stringifyException((Throwable)t));
                    if (--remainingRetries != 0) continue;
                    ReflectionUtils.logThreadInfo((Logger)LOG, (String)"Communication exception", (long)0L);
                    LOG.warn("Last retry, killing " + Task.this.taskId);
                    this.resetDoneFlag();
                    System.exit(65);
                }
            }
            this.resetDoneFlag();
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        void resetDoneFlag() {
            Object object = this.lock;
            synchronized (object) {
                this.done = true;
                this.lock.notify();
            }
        }

        public void startCommunicationThread() {
            if (this.pingThread == null) {
                this.pingThread = new Thread((Runnable)this, "communication thread");
                this.pingThread.setDaemon(true);
                this.pingThread.start();
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void stopCommunicationThread() throws InterruptedException {
            if (this.pingThread != null) {
                Object object = this.lock;
                synchronized (object) {
                    this.lock.notify();
                }
                object = this.lock;
                synchronized (object) {
                    while (!this.done) {
                        this.lock.wait();
                    }
                }
                this.pingThread.interrupt();
                this.pingThread.join();
            }
        }

        public class TaskLimitException
        extends IOException {
            public TaskLimitException(String str) {
                super(str);
            }
        }
    }

    @Deprecated
    public static enum Counter {
        MAP_INPUT_RECORDS,
        MAP_OUTPUT_RECORDS,
        MAP_SKIPPED_RECORDS,
        MAP_INPUT_BYTES,
        MAP_OUTPUT_BYTES,
        MAP_OUTPUT_MATERIALIZED_BYTES,
        COMBINE_INPUT_RECORDS,
        COMBINE_OUTPUT_RECORDS,
        REDUCE_INPUT_GROUPS,
        REDUCE_SHUFFLE_BYTES,
        REDUCE_INPUT_RECORDS,
        REDUCE_OUTPUT_RECORDS,
        REDUCE_SKIPPED_GROUPS,
        REDUCE_SKIPPED_RECORDS,
        SPILLED_RECORDS,
        SPLIT_RAW_BYTES,
        CPU_MILLISECONDS,
        PHYSICAL_MEMORY_BYTES,
        VIRTUAL_MEMORY_BYTES,
        COMMITTED_HEAP_BYTES,
        MAP_PHYSICAL_MEMORY_BYTES_MAX,
        MAP_VIRTUAL_MEMORY_BYTES_MAX,
        REDUCE_PHYSICAL_MEMORY_BYTES_MAX,
        REDUCE_VIRTUAL_MEMORY_BYTES_MAX;

    }
}

