/*
 * Decompiled with CFR 0.152.
 */
package org.pentaho.big.data.kettle.plugins.kafka;

import com.google.common.collect.ImmutableMap;
import java.util.Arrays;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import org.eclipse.swt.custom.CTabFolder;
import org.eclipse.swt.custom.CTabItem;
import org.eclipse.swt.events.ModifyListener;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.events.ShellAdapter;
import org.eclipse.swt.events.ShellEvent;
import org.eclipse.swt.events.ShellListener;
import org.eclipse.swt.graphics.Device;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.layout.FormAttachment;
import org.eclipse.swt.layout.FormData;
import org.eclipse.swt.layout.FormLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Group;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Listener;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Table;
import org.eclipse.swt.widgets.TableItem;
import org.eclipse.swt.widgets.Text;
import org.pentaho.big.data.kettle.plugins.kafka.KafkaDialogHelper;
import org.pentaho.big.data.kettle.plugins.kafka.KafkaFactory;
import org.pentaho.big.data.kettle.plugins.kafka.KafkaProducerOutputMeta;
import org.pentaho.di.core.SwtUniversalImage;
import org.pentaho.di.core.plugins.PluginInterface;
import org.pentaho.di.core.plugins.PluginRegistry;
import org.pentaho.di.core.plugins.StepPluginType;
import org.pentaho.di.core.variables.VariableSpace;
import org.pentaho.di.i18n.BaseMessages;
import org.pentaho.di.trans.TransMeta;
import org.pentaho.di.trans.step.BaseStepMeta;
import org.pentaho.di.trans.step.StepDialogInterface;
import org.pentaho.di.ui.core.gui.GUIResource;
import org.pentaho.di.ui.core.widget.ColumnInfo;
import org.pentaho.di.ui.core.widget.ComboVar;
import org.pentaho.di.ui.core.widget.TableView;
import org.pentaho.di.ui.core.widget.TextVar;
import org.pentaho.di.ui.spoon.Spoon;
import org.pentaho.di.ui.trans.step.BaseStepDialog;
import org.pentaho.metastore.api.IMetaStore;
import org.pentaho.metastore.api.exceptions.MetaStoreException;

public class KafkaProducerOutputDialog
extends BaseStepDialog
implements StepDialogInterface {
    private static final Class<?> PKG = KafkaProducerOutputMeta.class;
    private static final ImmutableMap<String, String> DEFAULT_OPTION_VALUES = ImmutableMap.of((Object)"compression.type", (Object)"none");
    private final KafkaFactory kafkaFactory = KafkaFactory.defaultFactory();
    private static final int SHELL_MIN_WIDTH = 527;
    private static final int SHELL_MIN_HEIGHT = 569;
    private static final int INPUT_WIDTH = 350;
    private KafkaProducerOutputMeta meta;
    private ModifyListener lsMod;
    private Label wlClusterName;
    private ComboVar wClusterName;
    private TextVar wClientId;
    private ComboVar wTopic;
    private ComboVar wKeyField;
    private ComboVar wMessageField;
    private TableView optionsTable;
    private CTabFolder wTabFolder;
    private Button wbDirect;
    private Button wbCluster;
    private Label wlBootstrapServers;
    private TextVar wBootstrapServers;

    public KafkaProducerOutputDialog(Shell parent, Object in, TransMeta transMeta, String stepName) {
        super(parent, (BaseStepMeta)in, transMeta, stepName);
        this.meta = (KafkaProducerOutputMeta)((Object)in);
    }

    public String open() {
        Shell parent = this.getParent();
        Display display = parent.getDisplay();
        this.changed = this.meta.hasChanged();
        this.lsMod = e -> this.meta.setChanged();
        this.lsCancel = e -> this.cancel();
        this.lsOK = e -> this.ok();
        this.lsDef = new SelectionAdapter(){

            public void widgetDefaultSelected(SelectionEvent e) {
                KafkaProducerOutputDialog.this.ok();
            }
        };
        this.shell = new Shell(parent, 3312);
        this.props.setLook((Control)this.shell);
        this.setShellImage(this.shell, this.meta);
        this.shell.setMinimumSize(527, 569);
        this.shell.setText(BaseMessages.getString(PKG, (String)"KafkaProducerOutputDialog.Shell.Title", (String[])new String[0]));
        FormLayout formLayout = new FormLayout();
        formLayout.marginWidth = 15;
        formLayout.marginHeight = 15;
        this.shell.setLayout((Layout)formLayout);
        this.shell.addShellListener((ShellListener)new ShellAdapter(){

            public void shellClosed(ShellEvent e) {
                KafkaProducerOutputDialog.this.cancel();
            }
        });
        Label wicon = new Label((Composite)this.shell, 131072);
        wicon.setImage(this.getImage());
        FormData fdlicon = new FormData();
        fdlicon.top = new FormAttachment(0, 0);
        fdlicon.right = new FormAttachment(100, 0);
        wicon.setLayoutData((Object)fdlicon);
        this.props.setLook((Control)wicon);
        this.wlStepname = new Label((Composite)this.shell, 131072);
        this.wlStepname.setText(BaseMessages.getString(PKG, (String)"KafkaProducerOutputDialog.Stepname.Label", (String[])new String[0]));
        this.props.setLook((Control)this.wlStepname);
        this.fdlStepname = new FormData();
        this.fdlStepname.left = new FormAttachment(0, 0);
        this.fdlStepname.top = new FormAttachment(0, 0);
        this.wlStepname.setLayoutData((Object)this.fdlStepname);
        this.wStepname = new Text((Composite)this.shell, 18436);
        this.wStepname.setText(this.stepname);
        this.props.setLook((Control)this.wStepname);
        this.wStepname.addModifyListener(this.lsMod);
        this.fdStepname = new FormData();
        this.fdStepname.width = 250;
        this.fdStepname.left = new FormAttachment(0, 0);
        this.fdStepname.top = new FormAttachment((Control)this.wlStepname, 5);
        this.wStepname.setLayoutData((Object)this.fdStepname);
        this.wStepname.addSelectionListener((SelectionListener)this.lsDef);
        Label topSeparator = new Label((Composite)this.shell, 258);
        FormData fdSpacer = new FormData();
        fdSpacer.height = 2;
        fdSpacer.left = new FormAttachment(0, 0);
        fdSpacer.top = new FormAttachment((Control)this.wStepname, 15);
        fdSpacer.right = new FormAttachment(100, 0);
        topSeparator.setLayoutData((Object)fdSpacer);
        this.wTabFolder = new CTabFolder((Composite)this.shell, 2048);
        this.props.setLook((Control)this.wTabFolder, 5);
        this.wTabFolder.setSimple(false);
        this.wTabFolder.setUnselectedCloseVisible(true);
        this.wCancel = new Button((Composite)this.shell, 8);
        this.wCancel.setText(BaseMessages.getString(PKG, (String)"System.Button.Cancel", (String[])new String[0]));
        FormData fdCancel = new FormData();
        fdCancel.right = new FormAttachment(100, 0);
        fdCancel.bottom = new FormAttachment(100, 0);
        this.wCancel.setLayoutData((Object)fdCancel);
        this.wCancel.addListener(13, this.lsCancel);
        this.wOK = new Button((Composite)this.shell, 8);
        this.wOK.setText(BaseMessages.getString(PKG, (String)"System.Button.OK", (String[])new String[0]));
        FormData fdOk = new FormData();
        fdOk.right = new FormAttachment((Control)this.wCancel, -5);
        fdOk.bottom = new FormAttachment(100, 0);
        this.wOK.setLayoutData((Object)fdOk);
        this.wOK.addListener(13, this.lsOK);
        Label bottomSeparator = new Label((Composite)this.shell, 258);
        this.props.setLook((Control)bottomSeparator);
        FormData fdBottomSeparator = new FormData();
        fdBottomSeparator.height = 2;
        fdBottomSeparator.left = new FormAttachment(0, 0);
        fdBottomSeparator.bottom = new FormAttachment((Control)this.wCancel, -15);
        fdBottomSeparator.right = new FormAttachment(100, 0);
        bottomSeparator.setLayoutData((Object)fdBottomSeparator);
        FormData fdTabFolder = new FormData();
        fdTabFolder.left = new FormAttachment(0, 0);
        fdTabFolder.top = new FormAttachment((Control)topSeparator, 15);
        fdTabFolder.bottom = new FormAttachment((Control)bottomSeparator, -15);
        fdTabFolder.right = new FormAttachment(100, 0);
        this.wTabFolder.setLayoutData((Object)fdTabFolder);
        this.buildSetupTab();
        this.buildOptionsTab();
        this.getData();
        this.setSize();
        this.meta.setChanged(this.changed);
        this.wTabFolder.setSelection(0);
        this.shell.open();
        while (!this.shell.isDisposed()) {
            if (display.readAndDispatch()) continue;
            display.sleep();
        }
        return this.stepname;
    }

    private void buildSetupTab() {
        CTabItem wSetupTab = new CTabItem(this.wTabFolder, 0);
        wSetupTab.setText(BaseMessages.getString(PKG, (String)"KafkaProducerOutputDialog.SetupTab", (String[])new String[0]));
        Composite wSetupComp = new Composite((Composite)this.wTabFolder, 0);
        this.props.setLook((Control)wSetupComp);
        FormLayout setupLayout = new FormLayout();
        setupLayout.marginHeight = 15;
        setupLayout.marginWidth = 15;
        wSetupComp.setLayout((Layout)setupLayout);
        Group wConnectionGroup = new Group(wSetupComp, 16);
        this.props.setLook((Control)wConnectionGroup);
        wConnectionGroup.setText(BaseMessages.getString(PKG, (String)"KafkaConsumerInputDialog.Connection", (String[])new String[0]));
        FormLayout flConnection = new FormLayout();
        flConnection.marginHeight = 15;
        flConnection.marginWidth = 15;
        wConnectionGroup.setLayout((Layout)flConnection);
        FormData fdConnectionGroup = new FormData();
        fdConnectionGroup.left = new FormAttachment(0, 0);
        fdConnectionGroup.top = new FormAttachment(0, 0);
        fdConnectionGroup.right = new FormAttachment(100, 0);
        fdConnectionGroup.width = 350;
        wConnectionGroup.setLayoutData((Object)fdConnectionGroup);
        this.wbDirect = new Button((Composite)wConnectionGroup, 16);
        this.wbDirect.setText(BaseMessages.getString(PKG, (String)"KafkaConsumerInputDialog.Direct", (String[])new String[0]));
        FormData fdbDirect = new FormData();
        fdbDirect.left = new FormAttachment(0, 0);
        fdbDirect.top = new FormAttachment(0, 0);
        this.wbDirect.setLayoutData((Object)fdbDirect);
        this.wbDirect.addSelectionListener(new SelectionListener(){

            public void widgetSelected(SelectionEvent selectionEvent) {
                KafkaProducerOutputDialog.this.lsMod.modifyText(null);
                KafkaProducerOutputDialog.this.toggleConnectionType(true);
            }

            public void widgetDefaultSelected(SelectionEvent selectionEvent) {
                KafkaProducerOutputDialog.this.toggleConnectionType(true);
            }
        });
        this.props.setLook((Control)this.wbDirect);
        this.wbCluster = new Button((Composite)wConnectionGroup, 16);
        this.wbCluster.setText(BaseMessages.getString(PKG, (String)"KafkaConsumerInputDialog.Cluster", (String[])new String[0]));
        FormData fdbCluster = new FormData();
        fdbCluster.left = new FormAttachment(0, 0);
        fdbCluster.top = new FormAttachment((Control)this.wbDirect, 10);
        this.wbCluster.setLayoutData((Object)fdbCluster);
        this.wbCluster.addSelectionListener(new SelectionListener(){

            public void widgetSelected(SelectionEvent selectionEvent) {
                KafkaProducerOutputDialog.this.lsMod.modifyText(null);
                KafkaProducerOutputDialog.this.toggleConnectionType(false);
            }

            public void widgetDefaultSelected(SelectionEvent selectionEvent) {
                KafkaProducerOutputDialog.this.toggleConnectionType(false);
            }
        });
        this.props.setLook((Control)this.wbCluster);
        Label environmentSeparator = new Label((Composite)wConnectionGroup, 514);
        FormData fdenvironmentSeparator = new FormData();
        fdenvironmentSeparator.top = new FormAttachment((Control)this.wbDirect, 0, 128);
        fdenvironmentSeparator.left = new FormAttachment((Control)this.wbCluster, 15);
        fdenvironmentSeparator.bottom = new FormAttachment((Control)this.wbCluster, 0, 1024);
        environmentSeparator.setLayoutData((Object)fdenvironmentSeparator);
        this.wlClusterName = new Label((Composite)wConnectionGroup, 16384);
        this.props.setLook((Control)this.wlClusterName);
        this.wlClusterName.setText(BaseMessages.getString(PKG, (String)"KafkaProducerOutputDialog.HadoopCluster", (String[])new String[0]));
        FormData fdlClusterName = new FormData();
        fdlClusterName.left = new FormAttachment((Control)environmentSeparator, 15);
        fdlClusterName.top = new FormAttachment(0, 0);
        fdlClusterName.right = new FormAttachment(78, 0);
        this.wlClusterName.setLayoutData((Object)fdlClusterName);
        this.wClusterName = new ComboVar((VariableSpace)this.transMeta, (Composite)wConnectionGroup, 18436);
        this.props.setLook((Control)this.wClusterName);
        this.wClusterName.addModifyListener(this.lsMod);
        FormData fdClusterName = new FormData();
        fdClusterName.left = new FormAttachment((Control)this.wlClusterName, 0, 16384);
        fdClusterName.top = new FormAttachment((Control)this.wlClusterName, 5);
        fdClusterName.right = new FormAttachment(78, 0);
        this.wClusterName.setLayoutData((Object)fdClusterName);
        this.wClusterName.addSelectionListener(this.lsDef);
        this.wlBootstrapServers = new Label((Composite)wConnectionGroup, 16384);
        this.props.setLook((Control)this.wlBootstrapServers);
        this.wlBootstrapServers.setText(BaseMessages.getString(PKG, (String)"KafkaConsumerInputDialog.BootstrapServers", (String[])new String[0]));
        FormData fdlBootstrapServers = new FormData();
        fdlBootstrapServers.left = new FormAttachment((Control)environmentSeparator, 15);
        fdlBootstrapServers.top = new FormAttachment(0, 0);
        fdlBootstrapServers.right = new FormAttachment(78, 0);
        this.wlBootstrapServers.setLayoutData((Object)fdlBootstrapServers);
        this.wBootstrapServers = new TextVar((VariableSpace)this.transMeta, (Composite)wConnectionGroup, 18436);
        this.props.setLook((Control)this.wBootstrapServers);
        this.wBootstrapServers.addModifyListener(this.lsMod);
        FormData fdBootstrapServers = new FormData();
        fdBootstrapServers.left = new FormAttachment((Control)this.wlBootstrapServers, 0, 16384);
        fdBootstrapServers.top = new FormAttachment((Control)this.wlBootstrapServers, 5);
        fdBootstrapServers.right = new FormAttachment(78, 0);
        this.wBootstrapServers.setLayoutData((Object)fdBootstrapServers);
        Label wlClientId = new Label(wSetupComp, 16384);
        this.props.setLook((Control)wlClientId);
        wlClientId.setText(BaseMessages.getString(PKG, (String)"KafkaProducerOutputDialog.ClientId", (String[])new String[0]));
        FormData fdlClientId = new FormData();
        fdlClientId.left = new FormAttachment(0, 0);
        fdlClientId.top = new FormAttachment((Control)wConnectionGroup, 10);
        fdlClientId.right = new FormAttachment(50, 0);
        wlClientId.setLayoutData((Object)fdlClientId);
        this.wClientId = new TextVar((VariableSpace)this.transMeta, wSetupComp, 18436);
        this.props.setLook((Control)this.wClientId);
        this.wClientId.addModifyListener(this.lsMod);
        FormData fdClientId = new FormData();
        fdClientId.left = new FormAttachment(0, 0);
        fdClientId.top = new FormAttachment((Control)wlClientId, 5);
        fdClientId.right = new FormAttachment(0, 350);
        this.wClientId.setLayoutData((Object)fdClientId);
        Label wlTopic = new Label(wSetupComp, 16384);
        this.props.setLook((Control)wlTopic);
        wlTopic.setText(BaseMessages.getString(PKG, (String)"KafkaProducerOutputDialog.Topic", (String[])new String[0]));
        FormData fdlTopic = new FormData();
        fdlTopic.left = new FormAttachment(0, 0);
        fdlTopic.top = new FormAttachment((Control)this.wClientId, 10);
        fdlTopic.right = new FormAttachment(50, 0);
        wlTopic.setLayoutData((Object)fdlTopic);
        this.wTopic = new ComboVar((VariableSpace)this.transMeta, wSetupComp, 18436);
        this.props.setLook((Control)this.wTopic);
        this.wTopic.addModifyListener(this.lsMod);
        FormData fdTopic = new FormData();
        fdTopic.left = new FormAttachment(0, 0);
        fdTopic.top = new FormAttachment((Control)wlTopic, 5);
        fdTopic.right = new FormAttachment(0, 350);
        this.wTopic.setLayoutData((Object)fdTopic);
        this.wTopic.getCComboWidget().addListener(15, event -> {
            KafkaDialogHelper kafkaDialogHelper = new KafkaDialogHelper(this.wClusterName, this.wTopic, this.wbCluster, this.wBootstrapServers, this.kafkaFactory, this.meta.getNamedClusterService(), this.meta.getNamedClusterServiceLocator(), this.meta.getMetastoreLocator(), this.optionsTable, this.meta.getParentStepMeta());
            kafkaDialogHelper.clusterNameChanged(event);
        });
        Label wlKeyField = new Label(wSetupComp, 16384);
        this.props.setLook((Control)wlKeyField);
        wlKeyField.setText(BaseMessages.getString(PKG, (String)"KafkaProducerOutputDialog.KeyField", (String[])new String[0]));
        FormData fdlKeyField = new FormData();
        fdlKeyField.left = new FormAttachment(0, 0);
        fdlKeyField.top = new FormAttachment((Control)this.wTopic, 10);
        fdlKeyField.right = new FormAttachment(50, 0);
        wlKeyField.setLayoutData((Object)fdlKeyField);
        this.wKeyField = new ComboVar((VariableSpace)this.transMeta, wSetupComp, 18436);
        this.props.setLook((Control)this.wKeyField);
        this.wKeyField.addModifyListener(this.lsMod);
        FormData fdKeyField = new FormData();
        fdKeyField.left = new FormAttachment(0, 0);
        fdKeyField.top = new FormAttachment((Control)wlKeyField, 5);
        fdKeyField.right = new FormAttachment(0, 350);
        this.wKeyField.setLayoutData((Object)fdKeyField);
        Listener lsKeyFocus = e -> KafkaDialogHelper.populateFieldsList(this.transMeta, this.wKeyField, "Kafka Producer");
        this.wKeyField.getCComboWidget().addListener(15, lsKeyFocus);
        Label wlMessageField = new Label(wSetupComp, 16384);
        this.props.setLook((Control)wlMessageField);
        wlMessageField.setText(BaseMessages.getString(PKG, (String)"KafkaProducerOutputDialog.MessageField", (String[])new String[0]));
        FormData fdlMessageField = new FormData();
        fdlMessageField.left = new FormAttachment(0, 0);
        fdlMessageField.top = new FormAttachment((Control)this.wKeyField, 10);
        fdlMessageField.right = new FormAttachment(50, 0);
        wlMessageField.setLayoutData((Object)fdlMessageField);
        this.wMessageField = new ComboVar((VariableSpace)this.transMeta, wSetupComp, 18436);
        this.props.setLook((Control)this.wMessageField);
        this.wMessageField.addModifyListener(this.lsMod);
        FormData fdMessageField = new FormData();
        fdMessageField.left = new FormAttachment(0, 0);
        fdMessageField.top = new FormAttachment((Control)wlMessageField, 5);
        fdMessageField.right = new FormAttachment(0, 350);
        this.wMessageField.setLayoutData((Object)fdMessageField);
        Listener lsMessageFocus = e -> KafkaDialogHelper.populateFieldsList(this.transMeta, this.wMessageField, "Kafka Producer");
        this.wMessageField.getCComboWidget().addListener(15, lsMessageFocus);
        FormData fdSetupComp = new FormData();
        fdSetupComp.left = new FormAttachment(0, 0);
        fdSetupComp.top = new FormAttachment(0, 0);
        fdSetupComp.right = new FormAttachment(100, 0);
        fdSetupComp.bottom = new FormAttachment(100, 0);
        wSetupComp.setLayoutData((Object)fdSetupComp);
        wSetupComp.layout();
        wSetupTab.setControl((Control)wSetupComp);
    }

    private void toggleConnectionType(boolean isDirect) {
        this.wlBootstrapServers.setVisible(isDirect);
        this.wBootstrapServers.setVisible(isDirect);
        this.wlClusterName.setVisible(!isDirect);
        this.wClusterName.setVisible(!isDirect);
    }

    private void buildOptionsTab() {
        CTabItem wOptionsTab = new CTabItem(this.wTabFolder, 0);
        wOptionsTab.setText(BaseMessages.getString(PKG, (String)"KafkaProducerOutputDialog.Options.Tab", (String[])new String[0]));
        Composite wOptionsComp = new Composite((Composite)this.wTabFolder, 0);
        this.props.setLook((Control)wOptionsComp);
        FormLayout fieldsLayout = new FormLayout();
        fieldsLayout.marginHeight = 15;
        fieldsLayout.marginWidth = 15;
        wOptionsComp.setLayout((Layout)fieldsLayout);
        FormData optionsFormData = new FormData();
        optionsFormData.left = new FormAttachment(0, 0);
        optionsFormData.top = new FormAttachment((Control)wOptionsComp, 0);
        optionsFormData.right = new FormAttachment(100, 0);
        optionsFormData.bottom = new FormAttachment(100, 0);
        wOptionsComp.setLayoutData((Object)optionsFormData);
        this.buildOptionsTable(wOptionsComp);
        wOptionsComp.layout();
        wOptionsTab.setControl((Control)wOptionsComp);
    }

    private void buildOptionsTable(Composite parentWidget) {
        ColumnInfo[] columns = this.getOptionsColumns();
        if (this.meta.getConfig().size() == 0) {
            List<String> list = KafkaDialogHelper.getProducerAdvancedConfigOptionNames();
            LinkedHashMap<String, String> advancedConfig = new LinkedHashMap<String, String>();
            for (String item : list) {
                advancedConfig.put(item, (String)DEFAULT_OPTION_VALUES.getOrDefault((Object)item, (Object)""));
            }
            this.meta.setConfig(advancedConfig);
        }
        int fieldCount = this.meta.getConfig().size();
        this.optionsTable = new TableView((VariableSpace)this.transMeta, parentWidget, 67586, columns, fieldCount, false, this.lsMod, this.props, false);
        this.optionsTable.setSortable(false);
        this.optionsTable.getTable().addListener(11, event -> {
            Table table = (Table)event.widget;
            table.getColumn(1).setWidth(220);
            table.getColumn(2).setWidth(220);
        });
        this.populateOptionsData();
        FormData fdData = new FormData();
        fdData.left = new FormAttachment(0, 0);
        fdData.top = new FormAttachment(0, 0);
        fdData.right = new FormAttachment(100, 0);
        fdData.bottom = new FormAttachment(100, 0);
        Arrays.stream(this.optionsTable.getTable().getColumns()).forEach(column -> {
            if (column.getWidth() > 0) {
                column.setWidth(120);
            }
        });
        this.optionsTable.setLayoutData((Object)fdData);
    }

    private ColumnInfo[] getOptionsColumns() {
        ColumnInfo optionName = new ColumnInfo(BaseMessages.getString(PKG, (String)"KafkaProducerOutputDialog.Options.Column.Name", (String[])new String[0]), 1, false, false);
        ColumnInfo value = new ColumnInfo(BaseMessages.getString(PKG, (String)"KafkaProducerOutputDialog.Options.Column.Value", (String[])new String[0]), 1, false, false);
        value.setUsingVariables(true);
        return new ColumnInfo[]{optionName, value};
    }

    private void populateOptionsData() {
        int rowIndex = 0;
        for (Map.Entry<String, String> entry : this.meta.getConfig().entrySet()) {
            TableItem key = this.optionsTable.getTable().getItem(rowIndex++);
            key.setText(1, entry.getKey());
            key.setText(2, entry.getValue());
        }
    }

    private void setOptionsFromTable() {
        this.meta.setConfig(KafkaDialogHelper.getConfig(this.optionsTable));
    }

    private void getData() {
        try {
            List names = this.meta.getNamedClusterService().listNames((IMetaStore)Spoon.getInstance().getMetaStore());
            this.wClusterName.setItems(names.toArray(new String[0]));
        }
        catch (MetaStoreException e) {
            this.log.logError("Failed to get defined named clusters", (Throwable)e);
        }
        if (this.meta.getClusterName() != null) {
            this.wClusterName.setText(this.meta.getClusterName());
        }
        if (this.meta.getDirectBootstrapServers() != null) {
            this.wBootstrapServers.setText(this.meta.getDirectBootstrapServers());
        }
        if (this.meta.getClientId() != null) {
            this.wClientId.setText(this.meta.getClientId());
        }
        if (this.meta.getTopic() != null) {
            this.wTopic.setText(this.meta.getTopic());
        }
        if (this.meta.getKeyField() != null) {
            this.wKeyField.setText(this.meta.getKeyField());
        }
        if (this.meta.getMessageField() != null) {
            this.wMessageField.setText(this.meta.getMessageField());
        }
        this.wbCluster.setSelection(!this.isDirect());
        this.wbDirect.setSelection(this.isDirect());
        this.toggleConnectionType(this.isDirect());
    }

    private boolean isDirect() {
        return KafkaProducerOutputMeta.ConnectionType.DIRECT.equals((Object)this.meta.getConnectionType());
    }

    private Image getImage() {
        PluginInterface plugin = PluginRegistry.getInstance().getPlugin(StepPluginType.class, (Object)this.stepMeta.getStepMetaInterface());
        String id = plugin.getIds()[0];
        if (id != null) {
            return ((SwtUniversalImage)GUIResource.getInstance().getImagesSteps().get(id)).getAsBitmapForSize((Device)this.shell.getDisplay(), 48, 48);
        }
        return null;
    }

    private void cancel() {
        this.meta.setChanged(false);
        this.dispose();
    }

    private void ok() {
        this.stepname = this.wStepname.getText();
        this.meta.setClusterName(this.wClusterName.getText());
        this.meta.setConnectionType(this.wbDirect.getSelection() ? KafkaProducerOutputMeta.ConnectionType.DIRECT : KafkaProducerOutputMeta.ConnectionType.CLUSTER);
        this.meta.setDirectBootstrapServers(this.wBootstrapServers.getText());
        this.meta.setClientId(this.wClientId.getText());
        this.meta.setTopic(this.wTopic.getText());
        this.meta.setKeyField(this.wKeyField.getText());
        this.meta.setMessageField(this.wMessageField.getText());
        this.setOptionsFromTable();
        this.dispose();
    }
}

