/*
 * Decompiled with CFR 0.152.
 */
package org.pentaho.big.data.kettle.plugins.kafka;

import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import org.pentaho.big.data.kettle.plugins.kafka.KafkaConsumerField;
import org.pentaho.big.data.kettle.plugins.kafka.KafkaConsumerInputMeta;
import org.pentaho.big.data.kettle.plugins.kafka.KafkaResourceInfo;
import org.pentaho.big.data.kettle.plugins.kafka.KafkaStepAnalyzer;
import org.pentaho.di.core.exception.KettleException;
import org.pentaho.di.core.exception.KettleStepException;
import org.pentaho.di.core.row.RowMeta;
import org.pentaho.di.core.row.RowMetaInterface;
import org.pentaho.di.core.variables.VariableSpace;
import org.pentaho.di.repository.Repository;
import org.pentaho.di.trans.ISubTransAwareMeta;
import org.pentaho.di.trans.StepWithMappingMeta;
import org.pentaho.di.trans.TransMeta;
import org.pentaho.di.trans.step.BaseStepMeta;
import org.pentaho.di.trans.steps.transexecutor.TransExecutorMeta;
import org.pentaho.metastore.api.IMetaStore;
import org.pentaho.metaverse.api.IComponentDescriptor;
import org.pentaho.metaverse.api.IMetaverseNode;
import org.pentaho.metaverse.api.MetaverseAnalyzerException;
import org.pentaho.metaverse.api.MetaverseComponentDescriptor;
import org.pentaho.metaverse.api.StepField;
import org.pentaho.metaverse.api.analyzer.kettle.ComponentDerivationRecord;
import org.pentaho.metaverse.api.analyzer.kettle.KettleAnalyzerUtil;
import org.pentaho.metaverse.api.analyzer.kettle.step.ConnectionExternalResourceStepAnalyzer;
import org.pentaho.metaverse.api.analyzer.kettle.step.StepAnalyzer;
import org.pentaho.metaverse.api.analyzer.kettle.step.StepNodes;
import org.pentaho.metaverse.api.analyzer.kettle.step.SubtransAnalyzer;
import org.pentaho.metaverse.api.model.IExternalResourceInfo;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class KafkaConsumerStepAnalyzer
extends ConnectionExternalResourceStepAnalyzer<KafkaConsumerInputMeta> {
    private final transient Logger log = LoggerFactory.getLogger(KafkaConsumerStepAnalyzer.class);

    public KafkaConsumerStepAnalyzer() {
        KafkaStepAnalyzer.registerEntityTypes();
    }

    protected void customAnalyze(KafkaConsumerInputMeta meta, IMetaverseNode node) {
        try {
            super.customAnalyze((BaseStepMeta)meta, node);
            TransMeta subTransMeta = TransExecutorMeta.loadMappingMeta((StepWithMappingMeta)((StepWithMappingMeta)this.baseStepMeta), (Repository)this.parentTransMeta.getRepository(), (IMetaStore)this.parentTransMeta.getMetaStore(), (VariableSpace)this.parentTransMeta);
            SubtransAnalyzer subtransAnalyzer = new SubtransAnalyzer((StepAnalyzer)this, this.log);
            HashSet<StepField> stepFields = new HashSet<StepField>();
            for (KafkaConsumerField.Name kafkaField : KafkaConsumerField.Name.values()) {
                stepFields.add(new StepField("_resource_", kafkaField.toString()));
            }
            IMetaverseNode subTransNode = KettleAnalyzerUtil.analyze((StepAnalyzer)this, (TransMeta)this.parentTransMeta, (ISubTransAwareMeta)((ISubTransAwareMeta)this.baseStepMeta), (IMetaverseNode)this.rootNode);
            for (StepField stepField : stepFields) {
                IMetaverseNode inputNode = this.getInputs().findNode(stepField);
                String outputName = ((KafkaConsumerInputMeta)this.baseStepMeta).getFieldDefinitions().stream().filter(kcf -> kcf.getKafkaName().toString().equals(stepField.getFieldName())).map(KafkaConsumerField::getOutputName).findFirst().orElse("");
                subtransAnalyzer.linkUsedFieldToSubTrans(inputNode, subTransMeta, subTransNode, this.descriptor, fieldName -> fieldName.equals(outputName));
            }
            String resultFieldsStep = ((KafkaConsumerInputMeta)this.baseStepMeta).getSubStep();
            StepNodes outputNodes = this.getOutputs();
            for (String stepName : outputNodes.getStepNames()) {
                for (String fieldName2 : outputNodes.getFieldNames(stepName)) {
                    subtransAnalyzer.linkResultFieldToSubTrans(outputNodes.findNode(stepName, fieldName2), subTransMeta, subTransNode, this.descriptor, resultFieldsStep);
                }
            }
        }
        catch (KettleException | MetaverseAnalyzerException e) {
            this.log.warn(e.getMessage(), e);
        }
    }

    protected IMetaverseNode createTableNode(IExternalResourceInfo resource) {
        KafkaResourceInfo kafkaResourceInfo = (KafkaResourceInfo)resource;
        MetaverseComponentDescriptor topicDescriptor = new MetaverseComponentDescriptor(kafkaResourceInfo.getTopic(), "Kafka Topic", this.getConnectionNode(), this.getDescriptor().getContext());
        return this.createNodeFromDescriptor((IComponentDescriptor)topicDescriptor);
    }

    protected Map<String, RowMetaInterface> getInputRowMetaInterfaces(KafkaConsumerInputMeta meta) {
        HashMap<String, RowMetaInterface> inputRows = new HashMap<String, RowMetaInterface>();
        try {
            RowMeta rowMeta = new RowMeta();
            for (KafkaConsumerField.Name kafkaField : KafkaConsumerField.Name.values()) {
                ((KafkaConsumerInputMeta)this.baseStepMeta).putFieldOnRowMeta(new KafkaConsumerField(kafkaField, kafkaField.toString()), (RowMetaInterface)rowMeta, "", (VariableSpace)this.parentTransMeta);
            }
            inputRows.put("_resource_", (RowMetaInterface)rowMeta);
        }
        catch (KettleStepException e) {
            this.log.warn(e.getMessage(), (Throwable)e);
        }
        return inputRows;
    }

    public IMetaverseNode getConnectionNode() {
        if (this.connectionNode == null) {
            MetaverseComponentDescriptor connectionDescriptor = new MetaverseComponentDescriptor(((KafkaConsumerInputMeta)this.baseStepMeta).getBootstrapServers(), "Kafka Server", this.getDescriptor().getNamespace(), this.getDescriptor().getContext());
            this.connectionNode = this.createNodeFromDescriptor((IComponentDescriptor)connectionDescriptor);
        }
        return this.connectionNode;
    }

    protected boolean isPassthrough(StepField originalFieldName) {
        return false;
    }

    protected Set<ComponentDerivationRecord> getChanges() {
        return Collections.emptySet();
    }

    public String getResourceInputNodeType() {
        return null;
    }

    public String getResourceOutputNodeType() {
        return null;
    }

    public boolean isOutput() {
        return false;
    }

    public boolean isInput() {
        return true;
    }

    public Set<Class<? extends BaseStepMeta>> getSupportedSteps() {
        return Collections.singleton(KafkaConsumerInputMeta.class);
    }

    protected Set<StepField> getUsedFields(KafkaConsumerInputMeta meta) {
        return Collections.emptySet();
    }
}

