/*
 * Decompiled with CFR 0.152.
 */
package org.apache.pig.backend.hadoop.executionengine.physicalLayer.relationalOperators;

import java.util.List;
import java.util.Map;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.pig.backend.executionengine.ExecException;
import org.apache.pig.backend.hadoop.executionengine.physicalLayer.PhysicalOperator;
import org.apache.pig.backend.hadoop.executionengine.physicalLayer.Result;
import org.apache.pig.backend.hadoop.executionengine.physicalLayer.relationalOperators.POFRJoin;
import org.apache.pig.backend.hadoop.executionengine.physicalLayer.relationalOperators.POLocalRearrange;
import org.apache.pig.backend.hadoop.executionengine.physicalLayer.relationalOperators.POMergeJoin;
import org.apache.pig.data.DataType;
import org.apache.pig.data.SchemaTupleBackend;
import org.apache.pig.data.SchemaTupleClassGenerator;
import org.apache.pig.data.SchemaTupleFactory;
import org.apache.pig.data.Tuple;
import org.apache.pig.impl.logicalLayer.schema.Schema;

public class POFRJoinSpark
extends POFRJoin {
    private static final Log log = LogFactory.getLog(POFRJoinSpark.class);
    private Map<String, List<Tuple>> broadcasts;

    public POFRJoinSpark(POFRJoin copy) throws ExecException {
        super(copy);
    }

    @Override
    protected void setUpHashMap() throws ExecException {
        int i;
        log.info((Object)"Building replication hash table");
        SchemaTupleFactory[] inputSchemaTupleFactories = new SchemaTupleFactory[this.inputSchemas.length];
        SchemaTupleFactory[] keySchemaTupleFactories = new SchemaTupleFactory[this.inputSchemas.length];
        for (i = 0; i < this.inputSchemas.length; ++i) {
            this.addSchemaToFactories(this.inputSchemas[i], inputSchemaTupleFactories, i);
            this.addSchemaToFactories(this.keySchemas[i], keySchemaTupleFactories, i);
        }
        this.replicates.set(this.fragment, null);
        i = -1;
        long start = System.currentTimeMillis();
        for (int k = 0; k < this.inputSchemas.length; ++k) {
            SchemaTupleFactory inputSchemaTupleFactory = inputSchemaTupleFactories[++i];
            SchemaTupleFactory keySchemaTupleFactory = keySchemaTupleFactories[i];
            if (i == this.fragment) {
                this.replicates.set(i, null);
                continue;
            }
            POFRJoin.TupleToMapKey replicate = new POFRJoin.TupleToMapKey(1000, keySchemaTupleFactory);
            log.debug((Object)"Completed setup. Trying to build replication hash table");
            List<Tuple> tuples = this.broadcasts.get(((PhysicalOperator)this.parentPlan.getPredecessors(this).get(i)).getOperatorKey().toString());
            POLocalRearrange localRearrange = this.LRs[i];
            for (Tuple t : tuples) {
                Tuple tuple;
                localRearrange.attachInput(t);
                Result res = localRearrange.getNextTuple();
                if (POFRJoinSpark.getReporter() != null) {
                    POFRJoinSpark.getReporter().progress();
                }
                if (this.isKeyNull((tuple = (Tuple)res.result).get(1))) continue;
                Object key = tuple.get(1);
                Tuple value = this.getValueTuple(localRearrange, tuple);
                if (replicate.get(key) == null) {
                    replicate.put(key, new POMergeJoin.TuplesToSchemaTupleList(1, inputSchemaTupleFactory));
                }
                replicate.get(key).add(value);
            }
            this.replicates.set(i, replicate);
        }
        long end = System.currentTimeMillis();
        log.debug((Object)("Hash Table built. Time taken: " + (end - start)));
    }

    @Override
    public String name() {
        return this.getAliasString() + "FRJoinSpark[" + DataType.findTypeName(this.resultType) + "]" + " - " + this.mKey.toString();
    }

    private void addSchemaToFactories(Schema schema, SchemaTupleFactory[] schemaTupleFactories, int index) {
        if (schema != null) {
            log.debug((Object)("Using SchemaTuple for FR Join Schema: " + schema));
            schemaTupleFactories[index] = SchemaTupleBackend.newSchemaTupleFactory(schema, false, SchemaTupleClassGenerator.GenContext.FR_JOIN);
        }
    }

    public void attachInputs(Map<String, List<Tuple>> broadcasts) {
        this.broadcasts = broadcasts;
    }
}

