/*
 * Decompiled with CFR 0.152.
 */
package org.pentaho.reporting.libraries.resourceloader.loader.fileobject;

import java.io.File;
import java.net.URL;
import java.util.Map;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.commons.vfs2.FileObject;
import org.apache.commons.vfs2.FileSystemException;
import org.apache.commons.vfs2.VFS;
import org.apache.commons.vfs2.provider.UriParser;
import org.pentaho.reporting.libraries.resourceloader.ResourceData;
import org.pentaho.reporting.libraries.resourceloader.ResourceException;
import org.pentaho.reporting.libraries.resourceloader.ResourceKey;
import org.pentaho.reporting.libraries.resourceloader.ResourceKeyCreationException;
import org.pentaho.reporting.libraries.resourceloader.ResourceKeyData;
import org.pentaho.reporting.libraries.resourceloader.ResourceKeyUtils;
import org.pentaho.reporting.libraries.resourceloader.ResourceLoader;
import org.pentaho.reporting.libraries.resourceloader.ResourceLoadingException;
import org.pentaho.reporting.libraries.resourceloader.loader.fileobject.FileObjectResourceData;

public class FileObjectResourceLoader
implements ResourceLoader {
    public static final String SCHEMA_NAME = FileObjectResourceLoader.class.getName();
    private static final Log logger = LogFactory.getLog(FileObjectResourceLoader.class);

    @Override
    public boolean isSupportedKey(ResourceKey key) {
        if (key == null) {
            throw new NullPointerException();
        }
        return SCHEMA_NAME.equals(key.getSchema());
    }

    @Override
    public ResourceKey createKey(Object value, Map factoryKeys) throws ResourceKeyCreationException {
        try {
            if (value instanceof FileObject) {
                FileObject f = (FileObject)value;
                if (f.exists() && f.isFile()) {
                    return new ResourceKey(SCHEMA_NAME, f, factoryKeys);
                }
            } else if (value instanceof String) {
                UriParser.checkUriEncoding((String)String.valueOf(value));
                File file = new File(String.valueOf(value));
                FileObject f = VFS.getManager().resolveFile(file.toURI().toString());
                if (f.exists() && f.isFile()) {
                    return new ResourceKey(SCHEMA_NAME, f, factoryKeys);
                }
            }
        }
        catch (FileSystemException fse) {
            return null;
        }
        return null;
    }

    @Override
    public ResourceKey deriveKey(ResourceKey parent, String path, Map factoryKeys) throws ResourceKeyCreationException {
        if (!this.isSupportedKey(parent)) {
            throw new ResourceKeyCreationException("Assertation: Unsupported parent key type");
        }
        return parent;
    }

    @Override
    public URL toURL(ResourceKey key) {
        if (key == null) {
            throw new NullPointerException();
        }
        if (!this.isSupportedKey(key)) {
            throw new IllegalArgumentException("Key format is not recognized.");
        }
        try {
            FileObject fileObject = (FileObject)key.getIdentifier();
            return fileObject.getURL();
        }
        catch (FileSystemException e) {
            return null;
        }
    }

    @Override
    public ResourceData load(ResourceKey key) throws ResourceLoadingException {
        if (!this.isSupportedKey(key)) {
            throw new ResourceLoadingException("Key format is not recognized.");
        }
        return new FileObjectResourceData(key);
    }

    @Override
    public String serialize(ResourceKey bundleKey, ResourceKey key) throws ResourceException {
        if (key == null) {
            throw new NullPointerException("The ResourceKey can not be null");
        }
        if (!this.isSupportedKey(key)) {
            throw new IllegalArgumentException("Key format is not recognized.");
        }
        if (!(key.getIdentifier() instanceof FileObject)) {
            throw new IllegalArgumentException("ResourceKey is invalid - identifier is not a File object");
        }
        logger.debug((Object)"Serializing a FileObject Resource Key...");
        if (key.getParent() != null) {
            throw new ResourceException("Unable to serialize a FileObject-ResourceKey with a parent. This type is not expected to have a parent.");
        }
        try {
            FileObject fileObject = (FileObject)key.getIdentifier();
            String strIdentifier = fileObject.getName().getURI();
            String result = ResourceKeyUtils.createStringResourceKey(key.getSchema().toString(), strIdentifier, key.getFactoryParameters());
            logger.debug((Object)("Serialized FileObject Resource Key: [" + result + "]"));
            return result;
        }
        catch (Exception ioe) {
            throw new IllegalArgumentException("Could not determine fileObject URL specified in ResourceKey: " + ioe.getMessage());
        }
    }

    @Override
    public ResourceKey deserialize(ResourceKey bundleKey, String stringKey) throws ResourceKeyCreationException {
        ResourceKeyData keyData = ResourceKeyUtils.parse(stringKey);
        if (!SCHEMA_NAME.equals(keyData.getSchema())) {
            throw new ResourceKeyCreationException("Serialized version of fileObject key does not contain correct schema");
        }
        try {
            FileObject fileObject = VFS.getManager().resolveFile(keyData.getIdentifier());
            return new ResourceKey(SCHEMA_NAME, fileObject, keyData.getFactoryParameters());
        }
        catch (FileSystemException fse) {
            throw new ResourceKeyCreationException("Serialized version of fileObject key does not result into a valid FileObject");
        }
    }

    @Override
    public boolean isSupportedDeserializer(String data) {
        return SCHEMA_NAME.equals(ResourceKeyUtils.readSchemaFromString(data));
    }
}

