/*
 * Decompiled with CFR 0.152.
 */
package org.pentaho.reporting.libraries.resourceloader.loader.fileobject;

import java.io.BufferedInputStream;
import java.io.InputStream;
import org.apache.commons.vfs2.FileObject;
import org.apache.commons.vfs2.FileSystemException;
import org.pentaho.reporting.libraries.resourceloader.ResourceKey;
import org.pentaho.reporting.libraries.resourceloader.ResourceLoadingException;
import org.pentaho.reporting.libraries.resourceloader.ResourceManager;
import org.pentaho.reporting.libraries.resourceloader.loader.AbstractResourceData;

public class FileObjectResourceData
extends AbstractResourceData {
    private ResourceKey key;
    private FileObject fileObject;
    private volatile int length;
    private static final long serialVersionUID = 1L;

    public FileObjectResourceData(ResourceKey key) throws ResourceLoadingException {
        if (key == null) {
            throw new NullPointerException();
        }
        FileObject fileObject = (FileObject)key.getIdentifier();
        try {
            if (!fileObject.exists()) {
                throw new ResourceLoadingException("File-handle given does not point to an existing file.");
            }
            if (!fileObject.isFile()) {
                throw new ResourceLoadingException("File-handle given does not point to a regular file.");
            }
            if (!fileObject.isReadable()) {
                throw new ResourceLoadingException("File '" + fileObject + "' is not readable.");
            }
        }
        catch (FileSystemException fse) {
            throw new ResourceLoadingException("Unable to create FileObjectResourceData : ", (Exception)((Object)fse));
        }
        this.key = key;
        this.fileObject = fileObject;
    }

    @Override
    public InputStream getResourceAsStream(ResourceManager caller) throws ResourceLoadingException {
        if (caller == null) {
            throw new NullPointerException();
        }
        try {
            int buffer = (int)Math.max(4096L, Math.min(this.fileObject.getContent().getSize(), 131072L));
            return new BufferedInputStream(this.fileObject.getContent().getInputStream(), buffer);
        }
        catch (Exception e) {
            throw new ResourceLoadingException("Unable to open Stream: ", e);
        }
    }

    @Override
    public Object getAttribute(String attrkey) {
        if (attrkey == null) {
            throw new NullPointerException();
        }
        try {
            if (attrkey.equals("filename")) {
                return this.fileObject.getName().getBaseName();
            }
            if (attrkey.equals("content-length")) {
                return new Long(this.fileObject.getContent().getSize());
            }
        }
        catch (FileSystemException fileSystemException) {
            // empty catch block
        }
        return null;
    }

    @Override
    public long getVersion(ResourceManager caller) throws ResourceLoadingException {
        if (caller == null) {
            throw new NullPointerException();
        }
        try {
            return this.fileObject.getContent().getLastModifiedTime();
        }
        catch (FileSystemException fse) {
            throw new ResourceLoadingException("Unable to get version: ", (Exception)((Object)fse));
        }
    }

    @Override
    public ResourceKey getKey() {
        return this.key;
    }
}

