/*
 * Decompiled with CFR 0.152.
 */
package org.apache.karaf.http.command;

import java.util.Arrays;
import org.apache.karaf.http.core.ServletInfo;
import org.apache.karaf.http.core.ServletService;
import org.apache.karaf.shell.commands.Command;
import org.apache.karaf.shell.commands.Option;
import org.apache.karaf.shell.console.OsgiCommandSupport;
import org.apache.karaf.shell.table.Col;
import org.apache.karaf.shell.table.ShellTable;

@Command(scope="http", name="list", description="Lists details for servlets.")
public class ServletListCommand
extends OsgiCommandSupport {
    @Option(name="--no-format", description="Disable table rendered output", required=false, multiValued=false)
    boolean noFormat;
    private ServletService servletService;

    public ServletListCommand(ServletService servletService) {
        this.servletService = servletService;
    }

    protected Object doExecute() throws Exception {
        ShellTable table = new ShellTable();
        table.column(new Col("ID"));
        table.column(new Col("Servlet"));
        table.column(new Col("Servlet-Name"));
        table.column(new Col("State"));
        table.column(new Col("Alias"));
        table.column(new Col("Url"));
        for (ServletInfo info : this.servletService.getServlets()) {
            table.addRow().addContent(new Object[]{info.getBundle().getBundleId(), info.getClassName(), info.getName(), info.getStateString(), info.getAlias(), Arrays.toString(info.getUrls())});
        }
        table.print(System.out, !this.noFormat);
        return null;
    }
}

