/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.yarn.server.resourcemanager.scheduler.fair;

import com.google.common.annotations.VisibleForTesting;
import com.google.common.collect.ArrayListMultimap;
import com.google.common.collect.ListMultimap;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.PriorityQueue;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.hadoop.yarn.server.resourcemanager.scheduler.SchedulerApplicationAttempt;
import org.apache.hadoop.yarn.server.resourcemanager.scheduler.fair.AllocationConfiguration;
import org.apache.hadoop.yarn.server.resourcemanager.scheduler.fair.FSAppAttempt;
import org.apache.hadoop.yarn.server.resourcemanager.scheduler.fair.FSLeafQueue;
import org.apache.hadoop.yarn.server.resourcemanager.scheduler.fair.FSParentQueue;
import org.apache.hadoop.yarn.server.resourcemanager.scheduler.fair.FSQueue;
import org.apache.hadoop.yarn.server.resourcemanager.scheduler.fair.FairScheduler;

public class MaxRunningAppsEnforcer {
    private static final Log LOG = LogFactory.getLog(FairScheduler.class);
    private final FairScheduler scheduler;
    private final Map<String, Integer> usersNumRunnableApps;
    @VisibleForTesting
    final ListMultimap<String, FSAppAttempt> usersNonRunnableApps;

    public MaxRunningAppsEnforcer(FairScheduler scheduler) {
        this.scheduler = scheduler;
        this.usersNumRunnableApps = new HashMap<String, Integer>();
        this.usersNonRunnableApps = ArrayListMultimap.create();
    }

    public boolean canAppBeRunnable(FSQueue queue, FSAppAttempt attempt) {
        boolean ret = true;
        if (this.exceedUserMaxApps(attempt.getUser())) {
            attempt.updateAMContainerDiagnostics(SchedulerApplicationAttempt.AMState.INACTIVATED, "The user \"" + attempt.getUser() + "\" has reached the maximum limit of runnable applications.");
            ret = false;
        } else if (this.exceedQueueMaxRunningApps(queue)) {
            attempt.updateAMContainerDiagnostics(SchedulerApplicationAttempt.AMState.INACTIVATED, "The queue \"" + queue.getName() + "\" has reached the maximum limit of runnable applications.");
            ret = false;
        }
        return ret;
    }

    public boolean exceedUserMaxApps(String user) {
        AllocationConfiguration allocConf = this.scheduler.getAllocationConfiguration();
        Integer userNumRunnable = this.usersNumRunnableApps.get(user);
        if (userNumRunnable == null) {
            userNumRunnable = 0;
        }
        return userNumRunnable >= allocConf.getUserMaxApps(user);
    }

    public boolean exceedQueueMaxRunningApps(FSQueue queue) {
        while (queue != null) {
            if (queue.getNumRunnableApps() >= queue.getMaxRunningApps()) {
                return true;
            }
            queue = queue.getParent();
        }
        return false;
    }

    public void trackRunnableApp(FSAppAttempt app) {
        String user = app.getUser();
        FSLeafQueue queue = app.getQueue();
        for (FSParentQueue parent = queue.getParent(); parent != null; parent = parent.getParent()) {
            parent.incrementRunnableApps();
        }
        Integer userNumRunnable = this.usersNumRunnableApps.get(user);
        this.usersNumRunnableApps.put(user, (userNumRunnable == null ? 0 : userNumRunnable) + 1);
    }

    public void trackNonRunnableApp(FSAppAttempt app) {
        String user = app.getUser();
        this.usersNonRunnableApps.put((Object)user, (Object)app);
    }

    public void updateRunnabilityOnReload() {
        FSParentQueue rootQueue = this.scheduler.getQueueManager().getRootQueue();
        ArrayList<List<FSAppAttempt>> appsNowMaybeRunnable = new ArrayList<List<FSAppAttempt>>();
        this.gatherPossiblyRunnableAppLists(rootQueue, appsNowMaybeRunnable);
        this.updateAppsRunnability(appsNowMaybeRunnable, Integer.MAX_VALUE);
    }

    public void updateRunnabilityOnAppRemoval(FSAppAttempt app, FSLeafQueue queue) {
        List userWaitingApps;
        String user;
        Integer userNumRunning;
        AllocationConfiguration allocConf = this.scheduler.getAllocationConfiguration();
        FSQueue highestQueueWithAppsNowRunnable = queue.getNumRunnableApps() == queue.getMaxRunningApps() - 1 ? queue : null;
        for (FSParentQueue parent = queue.getParent(); parent != null; parent = parent.getParent()) {
            if (parent.getNumRunnableApps() != parent.getMaxRunningApps() - 1) continue;
            highestQueueWithAppsNowRunnable = parent;
        }
        ArrayList<List<FSAppAttempt>> appsNowMaybeRunnable = new ArrayList<List<FSAppAttempt>>();
        if (highestQueueWithAppsNowRunnable != null) {
            this.gatherPossiblyRunnableAppLists(highestQueueWithAppsNowRunnable, appsNowMaybeRunnable);
        }
        if ((userNumRunning = this.usersNumRunnableApps.get(user = app.getUser())) == null) {
            userNumRunning = 0;
        }
        if (userNumRunning == allocConf.getUserMaxApps(user) - 1 && (userWaitingApps = this.usersNonRunnableApps.get((Object)user)) != null) {
            appsNowMaybeRunnable.add(userWaitingApps);
        }
        this.updateAppsRunnability(appsNowMaybeRunnable, appsNowMaybeRunnable.size());
    }

    private void updateAppsRunnability(List<List<FSAppAttempt>> appsNowMaybeRunnable, int maxRunnableApps) {
        MultiListStartTimeIterator iter = new MultiListStartTimeIterator(appsNowMaybeRunnable);
        FSAppAttempt prev = null;
        ArrayList<FSAppAttempt> noLongerPendingApps = new ArrayList<FSAppAttempt>();
        while (iter.hasNext()) {
            FSAppAttempt next = (FSAppAttempt)iter.next();
            if (next == prev) continue;
            if (this.canAppBeRunnable(next.getQueue(), next)) {
                this.trackRunnableApp(next);
                FSAppAttempt appSched = next;
                next.getQueue().addApp(appSched, true);
                noLongerPendingApps.add(appSched);
                if (noLongerPendingApps.size() >= maxRunnableApps) break;
            }
            prev = next;
        }
        for (FSAppAttempt appSched : noLongerPendingApps) {
            if (!appSched.getQueue().removeNonRunnableApp(appSched)) {
                LOG.error((Object)("Can't make app runnable that does not already exist in queue as non-runnable: " + appSched + ". This should never happen."));
            }
            if (this.usersNonRunnableApps.remove((Object)appSched.getUser(), (Object)appSched)) continue;
            LOG.error((Object)("Waiting app " + appSched + " expected to be in usersNonRunnableApps, but was not. This should never happen."));
        }
    }

    public void untrackRunnableApp(FSAppAttempt app) {
        String user = app.getUser();
        int newUserNumRunning = this.usersNumRunnableApps.get(user) - 1;
        if (newUserNumRunning == 0) {
            this.usersNumRunnableApps.remove(user);
        } else {
            this.usersNumRunnableApps.put(user, newUserNumRunning);
        }
        FSLeafQueue queue = app.getQueue();
        for (FSParentQueue parent = queue.getParent(); parent != null; parent = parent.getParent()) {
            parent.decrementRunnableApps();
        }
    }

    public void untrackNonRunnableApp(FSAppAttempt app) {
        this.usersNonRunnableApps.remove((Object)app.getUser(), (Object)app);
    }

    private void gatherPossiblyRunnableAppLists(FSQueue queue, List<List<FSAppAttempt>> appLists) {
        if (queue.getNumRunnableApps() < queue.getMaxRunningApps()) {
            if (queue instanceof FSLeafQueue) {
                appLists.add(((FSLeafQueue)queue).getCopyOfNonRunnableAppSchedulables());
            } else {
                for (FSQueue child : queue.getChildQueues()) {
                    this.gatherPossiblyRunnableAppLists(child, appLists);
                }
            }
        }
    }

    static class MultiListStartTimeIterator
    implements Iterator<FSAppAttempt> {
        private List<FSAppAttempt>[] appLists;
        private int[] curPositionsInAppLists;
        private PriorityQueue<IndexAndTime> appListsByCurStartTime;

        public MultiListStartTimeIterator(List<List<FSAppAttempt>> appListList) {
            this.appLists = appListList.toArray(new List[appListList.size()]);
            this.curPositionsInAppLists = new int[this.appLists.length];
            this.appListsByCurStartTime = new PriorityQueue();
            for (int i = 0; i < this.appLists.length; ++i) {
                long time = this.appLists[i].isEmpty() ? Long.MAX_VALUE : this.appLists[i].get(0).getStartTime();
                this.appListsByCurStartTime.add(new IndexAndTime(i, time));
            }
        }

        @Override
        public boolean hasNext() {
            return !this.appListsByCurStartTime.isEmpty() && this.appListsByCurStartTime.peek().time != Long.MAX_VALUE;
        }

        @Override
        public FSAppAttempt next() {
            IndexAndTime indexAndTime = (IndexAndTime)this.appListsByCurStartTime.remove();
            int nextListIndex = indexAndTime.index;
            FSAppAttempt next = this.appLists[nextListIndex].get(this.curPositionsInAppLists[nextListIndex]);
            int n = nextListIndex;
            this.curPositionsInAppLists[n] = this.curPositionsInAppLists[n] + 1;
            indexAndTime.time = this.curPositionsInAppLists[nextListIndex] < this.appLists[nextListIndex].size() ? this.appLists[nextListIndex].get(this.curPositionsInAppLists[nextListIndex]).getStartTime() : Long.MAX_VALUE;
            this.appListsByCurStartTime.add(indexAndTime);
            return next;
        }

        @Override
        public void remove() {
            throw new UnsupportedOperationException("Remove not supported");
        }

        private static class IndexAndTime
        implements Comparable<IndexAndTime> {
            public int index;
            public long time;

            public IndexAndTime(int index, long time) {
                this.index = index;
                this.time = time;
            }

            @Override
            public int compareTo(IndexAndTime o) {
                return this.time < o.time ? -1 : (this.time > o.time ? 1 : 0);
            }

            public boolean equals(Object o) {
                if (!(o instanceof IndexAndTime)) {
                    return false;
                }
                IndexAndTime other = (IndexAndTime)o;
                return other.time == this.time;
            }

            public int hashCode() {
                return (int)this.time;
            }
        }
    }
}

