/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.yarn.server.resourcemanager.scheduler;

import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentSkipListSet;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.atomic.AtomicLong;
import java.util.concurrent.locks.ReentrantReadWriteLock;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.hadoop.classification.InterfaceAudience;
import org.apache.hadoop.classification.InterfaceStability;
import org.apache.hadoop.yarn.api.records.ApplicationAttemptId;
import org.apache.hadoop.yarn.api.records.ApplicationId;
import org.apache.hadoop.yarn.api.records.Container;
import org.apache.hadoop.yarn.api.records.ExecutionType;
import org.apache.hadoop.yarn.api.records.Resource;
import org.apache.hadoop.yarn.api.records.ResourceRequest;
import org.apache.hadoop.yarn.server.resourcemanager.rmcontainer.RMContainer;
import org.apache.hadoop.yarn.server.resourcemanager.rmcontainer.RMContainerState;
import org.apache.hadoop.yarn.server.resourcemanager.scheduler.AbstractUsersManager;
import org.apache.hadoop.yarn.server.resourcemanager.scheduler.ContainerUpdateContext;
import org.apache.hadoop.yarn.server.resourcemanager.scheduler.NodeType;
import org.apache.hadoop.yarn.server.resourcemanager.scheduler.Queue;
import org.apache.hadoop.yarn.server.resourcemanager.scheduler.QueueMetrics;
import org.apache.hadoop.yarn.server.resourcemanager.scheduler.ResourceUsage;
import org.apache.hadoop.yarn.server.resourcemanager.scheduler.SchedulerNode;
import org.apache.hadoop.yarn.server.resourcemanager.scheduler.capacity.SchedulingMode;
import org.apache.hadoop.yarn.server.resourcemanager.scheduler.common.PendingAsk;
import org.apache.hadoop.yarn.server.resourcemanager.scheduler.placement.AppPlacementAllocator;
import org.apache.hadoop.yarn.server.resourcemanager.scheduler.placement.LocalityAppPlacementAllocator;
import org.apache.hadoop.yarn.server.resourcemanager.scheduler.placement.ResourceRequestUpdateResult;
import org.apache.hadoop.yarn.server.scheduler.SchedulerRequestKey;
import org.apache.hadoop.yarn.util.resource.Resources;

@InterfaceAudience.Private
@InterfaceStability.Unstable
public class AppSchedulingInfo {
    private static final Log LOG = LogFactory.getLog(AppSchedulingInfo.class);
    private final ApplicationId applicationId;
    private final ApplicationAttemptId applicationAttemptId;
    private final AtomicLong containerIdCounter;
    private final String user;
    private Queue queue;
    private AbstractUsersManager abstractUsersManager;
    private volatile boolean pending = true;
    private ResourceUsage appResourceUsage;
    private AtomicBoolean userBlacklistChanged = new AtomicBoolean(false);
    private final Set<String> placesBlacklistedBySystem = new HashSet<String>();
    private Set<String> placesBlacklistedByApp = new HashSet<String>();
    private Set<String> requestedPartitions = new HashSet<String>();
    private final ConcurrentSkipListSet<SchedulerRequestKey> schedulerKeys = new ConcurrentSkipListSet();
    private final Map<SchedulerRequestKey, AppPlacementAllocator<SchedulerNode>> schedulerKeyToAppPlacementAllocator = new ConcurrentHashMap<SchedulerRequestKey, AppPlacementAllocator<SchedulerNode>>();
    private final ReentrantReadWriteLock.ReadLock readLock;
    private final ReentrantReadWriteLock.WriteLock writeLock;
    public final ContainerUpdateContext updateContext;

    public AppSchedulingInfo(ApplicationAttemptId appAttemptId, String user, Queue queue, AbstractUsersManager abstractUsersManager, long epoch, ResourceUsage appResourceUsage) {
        this.applicationAttemptId = appAttemptId;
        this.applicationId = appAttemptId.getApplicationId();
        this.queue = queue;
        this.user = user;
        this.abstractUsersManager = abstractUsersManager;
        this.containerIdCounter = new AtomicLong(epoch << 40);
        this.appResourceUsage = appResourceUsage;
        ReentrantReadWriteLock lock = new ReentrantReadWriteLock();
        this.updateContext = new ContainerUpdateContext(this);
        this.readLock = lock.readLock();
        this.writeLock = lock.writeLock();
    }

    public ApplicationId getApplicationId() {
        return this.applicationId;
    }

    public ApplicationAttemptId getApplicationAttemptId() {
        return this.applicationAttemptId;
    }

    public String getUser() {
        return this.user;
    }

    public long getNewContainerId() {
        return this.containerIdCounter.incrementAndGet();
    }

    public String getQueueName() {
        try {
            this.readLock.lock();
            String string = this.queue.getQueueName();
            return string;
        }
        finally {
            this.readLock.unlock();
        }
    }

    public boolean isPending() {
        return this.pending;
    }

    public Set<String> getRequestedPartitions() {
        return this.requestedPartitions;
    }

    private void clearRequests() {
        this.schedulerKeys.clear();
        this.schedulerKeyToAppPlacementAllocator.clear();
        LOG.info((Object)("Application " + this.applicationId + " requests cleared"));
    }

    public ContainerUpdateContext getUpdateContext() {
        return this.updateContext;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean updateResourceRequests(List<ResourceRequest> requests, boolean recoverPreemptedRequestForAContainer) {
        if (null == requests || requests.isEmpty()) {
            return false;
        }
        boolean offswitchResourcesUpdated = false;
        try {
            this.writeLock.lock();
            HashMap<SchedulerRequestKey, Map<String, ResourceRequest>> dedupRequests = new HashMap<SchedulerRequestKey, Map<String, ResourceRequest>>();
            for (ResourceRequest request : requests) {
                SchedulerRequestKey schedulerKey = SchedulerRequestKey.create((ResourceRequest)request);
                if (!dedupRequests.containsKey(schedulerKey)) {
                    dedupRequests.put(schedulerKey, new HashMap());
                }
                ((Map)dedupRequests.get(schedulerKey)).put(request.getResourceName(), request);
            }
            boolean bl = offswitchResourcesUpdated = this.addRequestToAppPlacement(recoverPreemptedRequestForAContainer, dedupRequests);
            return bl;
        }
        finally {
            this.writeLock.unlock();
        }
    }

    public void removeAppPlacement(SchedulerRequestKey schedulerRequestKey) {
        this.schedulerKeyToAppPlacementAllocator.remove(schedulerRequestKey);
    }

    boolean addRequestToAppPlacement(boolean recoverPreemptedRequestForAContainer, Map<SchedulerRequestKey, Map<String, ResourceRequest>> dedupRequests) {
        boolean offswitchResourcesUpdated = false;
        for (Map.Entry<SchedulerRequestKey, Map<String, ResourceRequest>> entry : dedupRequests.entrySet()) {
            ResourceRequestUpdateResult pendingAmountChanges;
            SchedulerRequestKey schedulerRequestKey = entry.getKey();
            if (!this.schedulerKeyToAppPlacementAllocator.containsKey(schedulerRequestKey)) {
                this.schedulerKeyToAppPlacementAllocator.put(schedulerRequestKey, new LocalityAppPlacementAllocator(this));
            }
            if (null == (pendingAmountChanges = this.schedulerKeyToAppPlacementAllocator.get(schedulerRequestKey).updateResourceRequests(entry.getValue().values(), recoverPreemptedRequestForAContainer))) continue;
            this.updatePendingResources(pendingAmountChanges.getLastAnyResourceRequest(), pendingAmountChanges.getNewResourceRequest(), schedulerRequestKey, this.queue.getMetrics());
            offswitchResourcesUpdated = true;
        }
        return offswitchResourcesUpdated;
    }

    private void updatePendingResources(ResourceRequest lastRequest, ResourceRequest request, SchedulerRequestKey schedulerKey, QueueMetrics metrics) {
        int lastRequestContainers;
        int n = lastRequestContainers = lastRequest != null ? lastRequest.getNumContainers() : 0;
        if (request.getNumContainers() <= 0) {
            if (lastRequestContainers >= 0) {
                this.schedulerKeys.remove(schedulerKey);
                this.schedulerKeyToAppPlacementAllocator.remove(schedulerKey);
            }
            LOG.info((Object)("checking for deactivate of application :" + this.applicationId));
            this.checkForDeactivation();
        } else if (lastRequestContainers <= 0) {
            this.schedulerKeys.add(schedulerKey);
            this.abstractUsersManager.activateApplication(this.user, this.applicationId);
        }
        Resource lastRequestCapability = lastRequest != null ? lastRequest.getCapability() : Resources.none();
        metrics.incrPendingResources(request.getNodeLabelExpression(), this.user, request.getNumContainers(), request.getCapability());
        if (lastRequest != null) {
            metrics.decrPendingResources(lastRequest.getNodeLabelExpression(), this.user, lastRequestContainers, lastRequestCapability);
        }
        Resource increasedResource = Resources.multiply((Resource)request.getCapability(), (double)request.getNumContainers());
        this.queue.incPendingResource(request.getNodeLabelExpression(), increasedResource);
        this.appResourceUsage.incPending(request.getNodeLabelExpression(), increasedResource);
        if (lastRequest != null) {
            Resource decreasedResource = Resources.multiply((Resource)lastRequestCapability, (double)lastRequestContainers);
            this.queue.decPendingResource(lastRequest.getNodeLabelExpression(), decreasedResource);
            this.appResourceUsage.decPending(lastRequest.getNodeLabelExpression(), decreasedResource);
        }
    }

    public void addRequestedPartition(String partition) {
        this.requestedPartitions.add(partition);
    }

    public void decPendingResource(String partition, Resource toDecrease) {
        this.queue.decPendingResource(partition, toDecrease);
        this.appResourceUsage.decPending(partition, toDecrease);
    }

    public void updatePlacesBlacklistedByApp(List<String> blacklistAdditions, List<String> blacklistRemovals) {
        if (AppSchedulingInfo.updateBlacklistedPlaces(this.placesBlacklistedByApp, blacklistAdditions, blacklistRemovals)) {
            this.userBlacklistChanged.set(true);
        }
    }

    public void updatePlacesBlacklistedBySystem(List<String> blacklistAdditions, List<String> blacklistRemovals) {
        AppSchedulingInfo.updateBlacklistedPlaces(this.placesBlacklistedBySystem, blacklistAdditions, blacklistRemovals);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static boolean updateBlacklistedPlaces(Set<String> blacklist, List<String> blacklistAdditions, List<String> blacklistRemovals) {
        boolean changed = false;
        Set<String> set = blacklist;
        synchronized (set) {
            if (blacklistAdditions != null) {
                changed = blacklist.addAll(blacklistAdditions);
            }
            if (blacklistRemovals != null) {
                changed = blacklist.removeAll(blacklistRemovals) || changed;
            }
        }
        return changed;
    }

    public boolean getAndResetBlacklistChanged() {
        return this.userBlacklistChanged.getAndSet(false);
    }

    public Collection<SchedulerRequestKey> getSchedulerKeys() {
        return this.schedulerKeys;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public List<ResourceRequest> getAllResourceRequests() {
        ArrayList<ResourceRequest> ret = new ArrayList<ResourceRequest>();
        try {
            this.readLock.lock();
            for (AppPlacementAllocator<SchedulerNode> ap : this.schedulerKeyToAppPlacementAllocator.values()) {
                ret.addAll(ap.getResourceRequests().values());
            }
        }
        finally {
            this.readLock.unlock();
        }
        return ret;
    }

    public PendingAsk getNextPendingAsk() {
        try {
            this.readLock.lock();
            SchedulerRequestKey firstRequestKey = this.schedulerKeys.first();
            PendingAsk pendingAsk = this.getPendingAsk(firstRequestKey, "*");
            return pendingAsk;
        }
        finally {
            this.readLock.unlock();
        }
    }

    public PendingAsk getPendingAsk(SchedulerRequestKey schedulerKey) {
        return this.getPendingAsk(schedulerKey, "*");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public PendingAsk getPendingAsk(SchedulerRequestKey schedulerKey, String resourceName) {
        try {
            this.readLock.lock();
            AppPlacementAllocator<SchedulerNode> ap = this.schedulerKeyToAppPlacementAllocator.get(schedulerKey);
            PendingAsk pendingAsk = ap == null ? PendingAsk.ZERO : ap.getPendingAsk(resourceName);
            return pendingAsk;
        }
        finally {
            this.readLock.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean isPlaceBlacklisted(String resourceName, boolean blacklistedBySystem) {
        if (blacklistedBySystem) {
            Set<String> set = this.placesBlacklistedBySystem;
            synchronized (set) {
                return this.placesBlacklistedBySystem.contains(resourceName);
            }
        }
        Set<String> set = this.placesBlacklistedByApp;
        synchronized (set) {
            return this.placesBlacklistedByApp.contains(resourceName);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public List<ResourceRequest> allocate(NodeType type, SchedulerNode node, SchedulerRequestKey schedulerKey, Container containerAllocated) {
        try {
            this.writeLock.lock();
            if (null != containerAllocated) {
                this.updateMetricsForAllocatedContainer(type, node, containerAllocated);
            }
            List<ResourceRequest> list = this.schedulerKeyToAppPlacementAllocator.get(schedulerKey).allocate(schedulerKey, type, node);
            return list;
        }
        finally {
            this.writeLock.unlock();
        }
    }

    public void checkForDeactivation() {
        if (this.schedulerKeys.isEmpty()) {
            this.abstractUsersManager.deactivateApplication(this.user, this.applicationId);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void move(Queue newQueue) {
        try {
            this.writeLock.lock();
            QueueMetrics oldMetrics = this.queue.getMetrics();
            QueueMetrics newMetrics = newQueue.getMetrics();
            for (AppPlacementAllocator<SchedulerNode> ap : this.schedulerKeyToAppPlacementAllocator.values()) {
                PendingAsk ask = ap.getPendingAsk("*");
                if (ask.getCount() <= 0) continue;
                oldMetrics.decrPendingResources(ap.getPrimaryRequestedNodePartition(), this.user, ask.getCount(), ask.getPerAllocationResource());
                newMetrics.incrPendingResources(ap.getPrimaryRequestedNodePartition(), this.user, ask.getCount(), ask.getPerAllocationResource());
                Resource delta = Resources.multiply((Resource)ask.getPerAllocationResource(), (double)ask.getCount());
                this.queue.decPendingResource(ap.getPrimaryRequestedNodePartition(), delta);
                newQueue.incPendingResource(ap.getPrimaryRequestedNodePartition(), delta);
            }
            oldMetrics.moveAppFrom(this);
            newMetrics.moveAppTo(this);
            this.abstractUsersManager.deactivateApplication(this.user, this.applicationId);
            this.abstractUsersManager = newQueue.getAbstractUsersManager();
            this.abstractUsersManager.activateApplication(this.user, this.applicationId);
            this.queue = newQueue;
        }
        finally {
            this.writeLock.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void stop() {
        try {
            this.writeLock.lock();
            QueueMetrics metrics = this.queue.getMetrics();
            for (AppPlacementAllocator<SchedulerNode> ap : this.schedulerKeyToAppPlacementAllocator.values()) {
                PendingAsk ask = ap.getPendingAsk("*");
                if (ask.getCount() <= 0) continue;
                metrics.decrPendingResources(ap.getPrimaryRequestedNodePartition(), this.user, ask.getCount(), ask.getPerAllocationResource());
                this.queue.decPendingResource(ap.getPrimaryRequestedNodePartition(), Resources.multiply((Resource)ask.getPerAllocationResource(), (double)ask.getCount()));
            }
            metrics.finishAppAttempt(this.applicationId, this.pending, this.user);
            this.clearRequests();
        }
        finally {
            this.writeLock.unlock();
        }
    }

    public void setQueue(Queue queue) {
        try {
            this.writeLock.lock();
            this.queue = queue;
        }
        finally {
            this.writeLock.unlock();
        }
    }

    private Set<String> getBlackList() {
        return this.placesBlacklistedByApp;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Set<String> getBlackListCopy() {
        Set<String> set = this.placesBlacklistedByApp;
        synchronized (set) {
            return new HashSet<String>(this.placesBlacklistedByApp);
        }
    }

    public void transferStateFromPreviousAppSchedulingInfo(AppSchedulingInfo appInfo) {
        this.placesBlacklistedByApp = appInfo.getBlackList();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void recoverContainer(RMContainer rmContainer, String partition) {
        if (rmContainer.getExecutionType() != ExecutionType.GUARANTEED) {
            return;
        }
        try {
            this.writeLock.lock();
            QueueMetrics metrics = this.queue.getMetrics();
            if (this.pending) {
                this.pending = false;
                metrics.runAppAttempt(this.applicationId, this.user);
            }
            if (rmContainer.getState().equals((Object)RMContainerState.COMPLETED)) {
                return;
            }
            metrics.allocateResources(partition, this.user, 1, rmContainer.getAllocatedResource(), false);
        }
        finally {
            this.writeLock.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean checkAllocation(NodeType type, SchedulerNode node, SchedulerRequestKey schedulerKey) {
        try {
            this.readLock.lock();
            AppPlacementAllocator<SchedulerNode> ap = this.schedulerKeyToAppPlacementAllocator.get(schedulerKey);
            if (null == ap) {
                boolean bl = false;
                return bl;
            }
            boolean bl = ap.canAllocate(type, node);
            return bl;
        }
        finally {
            this.readLock.unlock();
        }
    }

    private void updateMetricsForAllocatedContainer(NodeType type, SchedulerNode node, Container containerAllocated) {
        QueueMetrics metrics = this.queue.getMetrics();
        if (this.pending) {
            this.pending = false;
            metrics.runAppAttempt(this.applicationId, this.user);
        }
        if (LOG.isDebugEnabled()) {
            LOG.debug((Object)("allocate: applicationId=" + this.applicationId + " container=" + containerAllocated.getId() + " host=" + containerAllocated.getNodeId().toString() + " user=" + this.user + " resource=" + containerAllocated.getResource() + " type=" + (Object)((Object)type)));
        }
        if (node != null) {
            metrics.allocateResources(node.getPartition(), this.user, 1, containerAllocated.getResource(), true);
        }
        metrics.incrNodeTypeAggregations(this.user, type);
    }

    public <N extends SchedulerNode> AppPlacementAllocator<N> getAppPlacementAllocator(SchedulerRequestKey schedulerkey) {
        return this.schedulerKeyToAppPlacementAllocator.get(schedulerkey);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean canDelayTo(SchedulerRequestKey schedulerKey, String resourceName) {
        try {
            this.readLock.lock();
            AppPlacementAllocator<SchedulerNode> ap = this.schedulerKeyToAppPlacementAllocator.get(schedulerKey);
            boolean bl = ap == null || ap.canDelayTo(resourceName);
            return bl;
        }
        finally {
            this.readLock.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean acceptNodePartition(SchedulerRequestKey schedulerKey, String nodePartition, SchedulingMode schedulingMode) {
        try {
            this.readLock.lock();
            AppPlacementAllocator<SchedulerNode> ap = this.schedulerKeyToAppPlacementAllocator.get(schedulerKey);
            boolean bl = ap != null && ap.acceptNodePartition(nodePartition, schedulingMode);
            return bl;
        }
        finally {
            this.readLock.unlock();
        }
    }
}

