/*
 * Decompiled with CFR 0.152.
 */
package de.simplicit.vjdbc.serial;

import java.io.ByteArrayInputStream;
import java.io.Externalizable;
import java.io.IOException;
import java.io.InputStream;
import java.io.ObjectInput;
import java.io.ObjectOutput;
import java.io.OutputStream;
import java.io.Reader;
import java.io.StringReader;
import java.io.Writer;
import java.lang.reflect.Constructor;
import java.sql.SQLException;
import java.sql.SQLXML;
import javax.xml.transform.Result;
import javax.xml.transform.Source;
import org.xml.sax.InputSource;

public class SerialSQLXML
implements SQLXML,
Externalizable {
    static final long serialVersionUID = 68757548812947189L;
    private StringBuilder xml;

    public SerialSQLXML() {
        this.xml = new StringBuilder();
    }

    public SerialSQLXML(String xml) {
        this.xml = new StringBuilder(xml);
    }

    public SerialSQLXML(SQLXML sqlxml) throws SQLException {
        this.xml = new StringBuilder(sqlxml.getString());
        sqlxml.free();
    }

    @Override
    public void free() throws SQLException {
        this.xml.delete(0, this.xml.length());
    }

    @Override
    public InputStream getBinaryStream() throws SQLException {
        return new ByteArrayInputStream(this.xml.toString().getBytes());
    }

    @Override
    public Reader getCharacterStream() throws SQLException {
        return new StringReader(this.xml.toString());
    }

    @Override
    public <T extends Source> T getSource(Class<T> sourceClass) throws SQLException {
        try {
            Constructor<T> constructor = sourceClass.getConstructor(InputSource.class);
            return (T)((Source)constructor.newInstance(new InputSource(this.getCharacterStream())));
        }
        catch (Exception exception) {
            return null;
        }
    }

    @Override
    public String getString() throws SQLException {
        return this.xml.toString();
    }

    @Override
    public OutputStream setBinaryStream() throws SQLException {
        throw new UnsupportedOperationException("SQLXML.setBinaryStream() not supported, use setString(String value) instead");
    }

    @Override
    public Writer setCharacterStream() throws SQLException {
        throw new UnsupportedOperationException("SQLXML.setCharacterStream() not supported, use setString(String value) instead");
    }

    @Override
    public <T extends Result> T setResult(Class<T> resultClass) throws SQLException {
        throw new UnsupportedOperationException("SQLXML.setResult() not supported");
    }

    @Override
    public void setString(String value) throws SQLException {
        this.xml.delete(0, this.xml.length());
        this.xml.append(value);
    }

    @Override
    public void writeExternal(ObjectOutput out) throws IOException {
        out.writeUTF(this.xml.toString());
    }

    @Override
    public void readExternal(ObjectInput in) throws IOException, ClassNotFoundException {
        this.xml.append(in.readUTF());
    }
}

