/*
 * Decompiled with CFR 0.152.
 */
package org.apache.oozie.workflow.lite;

import com.google.common.base.Joiner;
import com.google.common.base.Objects;
import com.google.common.base.Optional;
import java.util.ArrayDeque;
import java.util.Deque;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.apache.commons.collections.CollectionUtils;
import org.apache.oozie.ErrorCode;
import org.apache.oozie.service.ActionService;
import org.apache.oozie.service.Services;
import org.apache.oozie.util.ParamChecker;
import org.apache.oozie.util.XmlUtils;
import org.apache.oozie.workflow.WorkflowException;
import org.apache.oozie.workflow.lite.ActionNodeDef;
import org.apache.oozie.workflow.lite.DecisionNodeDef;
import org.apache.oozie.workflow.lite.EndNodeDef;
import org.apache.oozie.workflow.lite.ForkNodeDef;
import org.apache.oozie.workflow.lite.JoinNodeDef;
import org.apache.oozie.workflow.lite.KillNodeDef;
import org.apache.oozie.workflow.lite.LiteWorkflowApp;
import org.apache.oozie.workflow.lite.NodeDef;
import org.apache.oozie.workflow.lite.StartNodeDef;
import org.jdom.Element;
import org.jdom.JDOMException;

public class LiteWorkflowValidator {
    public void validateWorkflow(LiteWorkflowApp app, boolean validateForkJoin) throws WorkflowException {
        NodeDef startNode = app.getNode(":start:");
        if (startNode == null) {
            throw new WorkflowException(ErrorCode.E0700, "no start node");
        }
        ForkJoinCount forkJoinCount = new ForkJoinCount();
        this.performBasicValidation(app, startNode, new ArrayDeque<String>(), new HashSet<NodeDef>(), forkJoinCount);
        if (validateForkJoin) {
            if (forkJoinCount.forks != forkJoinCount.joins) {
                throw new WorkflowException(ErrorCode.E0730, new Object[0]);
            }
            this.validateForkJoin(app, startNode, null, null, true, new ArrayDeque<String>(), new HashMap<String, String>(), new HashMap<String, Optional<String>>());
        }
    }

    private void performBasicValidation(LiteWorkflowApp app, NodeDef node, Deque<String> path, Set<NodeDef> checkedNodes, ForkJoinCount forkJoinCount) throws WorkflowException {
        String nodeName = node.getName();
        this.checkActionName(node);
        if (node instanceof ActionNodeDef) {
            this.checkActionNode(node);
        } else if (node instanceof ForkNodeDef) {
            ++forkJoinCount.forks;
        } else if (node instanceof JoinNodeDef) {
            ++forkJoinCount.joins;
        }
        this.checkCycle(path, nodeName);
        path.addLast(nodeName);
        List<String> transitions = node.getTransitions();
        if (!transitions.isEmpty()) {
            for (String t : transitions) {
                NodeDef transitionNode = app.getNode(t);
                if (transitionNode == null) {
                    throw new WorkflowException(ErrorCode.E0708, node.getName(), t);
                }
                if (checkedNodes.contains(transitionNode)) continue;
                this.performBasicValidation(app, transitionNode, path, checkedNodes, forkJoinCount);
                checkedNodes.add(transitionNode);
            }
        }
        path.remove(nodeName);
    }

    private void validateForkJoin(LiteWorkflowApp app, NodeDef node, NodeDef currentFork, String topDecisionParent, boolean okPath, Deque<String> path, Map<String, String> forkJoins, Map<String, Optional<String>> nodeAndDecisionParents) throws WorkflowException {
        List<String> transitions;
        String nodeName = node.getName();
        path.addLast(nodeName);
        if (okPath && !(node instanceof KillNodeDef) && !(node instanceof JoinNodeDef) && !(node instanceof EndNodeDef)) {
            Optional<String> decisionParentOpt = nodeAndDecisionParents.get(nodeName);
            if (decisionParentOpt == null) {
                nodeAndDecisionParents.put(node.getName(), (Optional<String>)Optional.fromNullable((Object)topDecisionParent));
            } else {
                Iterator<String> decisionParent;
                Iterator<String> iterator = decisionParent = decisionParentOpt.isPresent() ? (String)decisionParentOpt.get() : null;
                if (decisionParent == null && topDecisionParent == null || !Objects.equal(decisionParent, (Object)topDecisionParent)) {
                    throw new WorkflowException(ErrorCode.E0743, nodeName);
                }
            }
        }
        if (node instanceof ForkNodeDef) {
            transitions = node.getTransitions();
            this.checkForkTransitions(app, transitions, node);
            for (String t : transitions) {
                NodeDef transition = app.getNode(t);
                this.validateForkJoin(app, transition, node, topDecisionParent, okPath, path, forkJoins, nodeAndDecisionParents);
            }
            HashSet<String> joins = new HashSet<String>();
            this.collectJoins(app, forkJoins, nodeName, joins);
            this.checkJoins(joins, nodeName);
            List<String> joinTransitions = app.getNode((String)joins.iterator().next()).getTransitions();
            NodeDef next = app.getNode(joinTransitions.get(0));
            this.validateForkJoin(app, next, currentFork, topDecisionParent, okPath, path, forkJoins, nodeAndDecisionParents);
        } else if (node instanceof JoinNodeDef) {
            if (currentFork == null) {
                throw new WorkflowException(ErrorCode.E0742, node.getName());
            }
            String forkNode = forkJoins.get(nodeName);
            if (forkNode == null) {
                forkJoins.put(nodeName, currentFork.getName());
            } else if (!forkNode.equals(currentFork.getName())) {
                throw new WorkflowException(ErrorCode.E0758, node.getName(), forkNode + "," + currentFork);
            }
        } else if (node instanceof DecisionNodeDef) {
            transitions = node.getTransitions();
            String parentDecisionNode = topDecisionParent;
            if (parentDecisionNode == null) {
                parentDecisionNode = nodeName;
            }
            for (String t : transitions) {
                NodeDef transition = app.getNode(t);
                this.validateForkJoin(app, transition, currentFork, parentDecisionNode, okPath, path, forkJoins, nodeAndDecisionParents);
            }
        } else if (!(node instanceof KillNodeDef)) {
            String transition;
            if (node instanceof EndNodeDef) {
                if (currentFork != null) {
                    path.removeLast();
                    String previous = path.peekLast();
                    throw new WorkflowException(ErrorCode.E0737, previous, node.getName());
                }
            } else if (node instanceof ActionNodeDef) {
                transition = node.getTransitions().get(0);
                NodeDef okNode = app.getNode(transition);
                this.validateForkJoin(app, okNode, currentFork, topDecisionParent, okPath, path, forkJoins, nodeAndDecisionParents);
                transition = node.getTransitions().get(1);
                NodeDef errorNode = app.getNode(transition);
                this.validateForkJoin(app, errorNode, currentFork, topDecisionParent, false, path, forkJoins, nodeAndDecisionParents);
            } else if (node instanceof StartNodeDef) {
                transition = node.getTransitions().get(0);
                NodeDef tranNode = app.getNode(transition);
                this.validateForkJoin(app, tranNode, currentFork, topDecisionParent, okPath, path, forkJoins, nodeAndDecisionParents);
            } else {
                throw new WorkflowException(ErrorCode.E0740, node.getClass());
            }
        }
        path.remove(nodeName);
    }

    private void checkActionName(NodeDef node) throws WorkflowException {
        if (!(node instanceof StartNodeDef)) {
            try {
                ParamChecker.validateActionName(node.getName());
            }
            catch (IllegalArgumentException ex) {
                throw new WorkflowException(ErrorCode.E0724, ex.getMessage());
            }
        }
    }

    private void checkActionNode(NodeDef node) throws WorkflowException {
        try {
            Element action = XmlUtils.parseXml(node.getConf());
            ActionService actionService = Services.get().get(ActionService.class);
            boolean supportedAction = actionService.hasActionType(action.getName());
            if (!supportedAction) {
                throw new WorkflowException(ErrorCode.E0723, node.getName(), action.getName());
            }
        }
        catch (JDOMException ex) {
            throw new WorkflowException(ErrorCode.E0700, "JDOMException: " + ex.getMessage());
        }
    }

    private void checkCycle(Deque<String> path, String nodeName) throws WorkflowException {
        if (path.contains(nodeName)) {
            path.addLast(nodeName);
            throw new WorkflowException(ErrorCode.E0707, nodeName, Joiner.on((String)"->").join(path));
        }
    }

    private void checkForkTransitions(LiteWorkflowApp app, List<String> transitionsList, NodeDef node) throws WorkflowException {
        for (String t : transitionsList) {
            int count;
            NodeDef aNode = app.getNode(t);
            if (aNode instanceof JoinNodeDef || aNode instanceof KillNodeDef || (count = CollectionUtils.cardinality((Object)t, transitionsList)) <= 1) continue;
            throw new WorkflowException(ErrorCode.E0744, node.getName(), t);
        }
    }

    private void collectJoins(LiteWorkflowApp app, Map<String, String> forkJoinPairs, String nodeName, Set<String> joins) {
        for (Map.Entry<String, String> entry : forkJoinPairs.entrySet()) {
            if (!entry.getValue().equals(nodeName)) continue;
            joins.add(app.getNode(entry.getKey()).getName());
        }
    }

    private void checkJoins(Set<String> joinNodes, String forkName) throws WorkflowException {
        if (joinNodes.size() == 0) {
            throw new WorkflowException(ErrorCode.E0733, forkName);
        }
        if (joinNodes.size() > 1) {
            throw new WorkflowException(ErrorCode.E0757, forkName, Joiner.on((String)",").join(joinNodes));
        }
    }

    private class ForkJoinCount {
        int forks = 0;
        int joins = 0;

        private ForkJoinCount() {
        }
    }
}

