/*
 * Decompiled with CFR 0.152.
 */
package org.apache.oozie.util.graph;

import com.google.common.base.Charsets;
import com.google.common.base.Preconditions;
import com.google.common.base.Strings;
import java.awt.image.BufferedImage;
import java.awt.image.RenderedImage;
import java.io.IOException;
import java.io.OutputStream;
import java.util.LinkedHashMap;
import java.util.Locale;
import java.util.Map;
import javax.imageio.ImageIO;
import org.apache.oozie.client.WorkflowAction;
import org.apache.oozie.client.WorkflowJob;
import org.apache.oozie.util.Instrumentation;
import org.apache.oozie.util.graph.GraphRenderer;
import org.apache.oozie.util.graph.OutputFormat;
import org.apache.oozie.util.graph.WorkflowActionNode;
import org.xml.sax.Attributes;
import org.xml.sax.SAXException;
import org.xml.sax.helpers.DefaultHandler;

public class WorkflowGraphHandler
extends DefaultHandler {
    private OutputStream out;
    private final OutputFormat outputFormat;
    private final WorkflowJob job;
    private boolean showKill;
    private final GraphRenderer graphRenderer;
    private final Map<String, WorkflowActionNode> tags = new LinkedHashMap<String, WorkflowActionNode>();
    private final WorkflowParseState state = new WorkflowParseState();

    WorkflowGraphHandler(OutputStream out, OutputFormat outputFormat, WorkflowJob job, boolean showKill, GraphRenderer graphRenderer) {
        this.out = out;
        this.job = job;
        this.showKill = showKill;
        this.graphRenderer = graphRenderer;
        this.outputFormat = outputFormat;
    }

    @Override
    public void startDocument() throws SAXException {
    }

    @Override
    public void endDocument() throws SAXException {
        Instrumentation.Cron cron = new Instrumentation.Cron();
        cron.start();
        if (this.tags.isEmpty()) {
            return;
        }
        Map<String, WorkflowAction> workflowActions = this.fillWorkflowActions();
        for (Map.Entry<String, WorkflowActionNode> entry : this.tags.entrySet()) {
            String name = entry.getKey();
            WorkflowActionNode parent = entry.getValue();
            if (workflowActions.containsKey(name)) {
                parent.setStatus(workflowActions.get(name).getStatus());
            }
            this.graphRenderer.addNode(parent);
            for (Map.Entry<String, Boolean> arc : parent.getArcs().entrySet()) {
                WorkflowActionNode child;
                if (!this.showKill && arc.getValue().booleanValue() && this.tags.get(arc.getKey()).getType().equals("kill") || (child = this.tags.get(arc.getKey())) == null) continue;
                if (workflowActions.containsKey(arc.getKey())) {
                    child.setStatus(workflowActions.get(arc.getKey()).getStatus());
                }
                this.graphRenderer.addEdge(parent, child);
            }
            this.graphRenderer.persist(parent);
        }
        switch (this.outputFormat) {
            case PNG: {
                this.renderAndWritePng();
                break;
            }
            case DOT: {
                this.renderAndWriteDot();
                break;
            }
            case SVG: {
                this.renderAndWriteSvg();
                break;
            }
            default: {
                throw new IllegalArgumentException(String.format("Unknown outputFormat %s", new Object[]{this.outputFormat}));
            }
        }
    }

    private void renderAndWritePng() throws SAXException {
        BufferedImage source = this.graphRenderer.renderPng();
        try {
            ImageIO.write((RenderedImage)source, "png", this.out);
        }
        catch (IOException ioe) {
            throw new SAXException(ioe);
        }
        finally {
            source.flush();
        }
    }

    private void renderAndWriteDot() throws SAXException {
        this.renderStringContent(this.graphRenderer.renderDot());
    }

    private void renderAndWriteSvg() throws SAXException {
        this.renderStringContent(this.graphRenderer.renderSvg());
    }

    private void renderStringContent(String content) throws SAXException {
        Preconditions.checkState((!Strings.isNullOrEmpty((String)content) ? 1 : 0) != 0, (Object)"No output generated from graph.");
        try {
            this.out.write(content.getBytes(Charsets.UTF_8));
        }
        catch (IOException ioe) {
            throw new SAXException(ioe);
        }
    }

    private Map<String, WorkflowAction> fillWorkflowActions() {
        LinkedHashMap<String, WorkflowAction> workflowActions = new LinkedHashMap<String, WorkflowAction>();
        boolean found = false;
        for (WorkflowAction wfAction : this.job.getActions()) {
            workflowActions.put(wfAction.getName(), wfAction);
            if (found) continue;
            switch (wfAction.getStatus()) {
                case KILLED: 
                case ERROR: 
                case FAILED: {
                    this.showKill = true;
                    found = true;
                    break;
                }
            }
        }
        return workflowActions;
    }

    @Override
    public void startElement(String namespaceURI, String localName, String qName, Attributes atts) throws SAXException {
        String name;
        if (localName.equalsIgnoreCase("start")) {
            String start = localName.toLowerCase(Locale.getDefault());
            if (!this.tags.containsKey(start)) {
                WorkflowActionNode v = new WorkflowActionNode(start, start);
                v.addArc(atts.getValue("to"));
                this.tags.put(start, v);
            }
        } else if (localName.equalsIgnoreCase("action")) {
            this.state.action = atts.getValue("name");
        } else if (this.state.action != null && this.state.actionType == null) {
            this.state.actionType = localName.toLowerCase(Locale.getDefault());
        } else if (localName.equalsIgnoreCase("ok") && this.state.action != null && this.state.actionOK == null) {
            this.state.actionOK = atts.getValue("to");
        } else if (localName.equalsIgnoreCase("error") && this.state.action != null && this.state.actionErr == null) {
            this.state.actionErr = atts.getValue("to");
        } else if (localName.equalsIgnoreCase("fork")) {
            this.state.fork = atts.getValue("name");
            if (!this.tags.containsKey(this.state.fork)) {
                this.tags.put(this.state.fork, new WorkflowActionNode(this.state.fork, localName.toLowerCase(Locale.getDefault())));
            }
        } else if (localName.equalsIgnoreCase("path")) {
            this.tags.get(this.state.fork).addArc(atts.getValue("start"));
        } else if (localName.equalsIgnoreCase("join")) {
            String join = atts.getValue("name");
            if (!this.tags.containsKey(join)) {
                WorkflowActionNode v = new WorkflowActionNode(join, localName.toLowerCase(Locale.getDefault()));
                v.addArc(atts.getValue("to"));
                this.tags.put(join, v);
            }
        } else if (localName.equalsIgnoreCase("decision")) {
            this.state.decision = atts.getValue("name");
            if (!this.tags.containsKey(this.state.decision)) {
                this.tags.put(this.state.decision, new WorkflowActionNode(this.state.decision, localName.toLowerCase(Locale.getDefault())));
            }
        } else if (localName.equalsIgnoreCase("case") || localName.equalsIgnoreCase("default")) {
            this.tags.get(this.state.decision).addArc(atts.getValue("to"));
        } else if ((localName.equalsIgnoreCase("kill") || localName.equalsIgnoreCase("end")) && !this.tags.containsKey(name = atts.getValue("name"))) {
            this.tags.put(name, new WorkflowActionNode(name, localName.toLowerCase(Locale.getDefault())));
        }
    }

    @Override
    public void endElement(String namespaceURI, String localName, String qName) throws SAXException {
        if (localName.equalsIgnoreCase("action")) {
            this.tags.put(this.state.action, new WorkflowActionNode(this.state.action, this.state.actionType));
            this.tags.get(this.state.action).addArc(this.state.actionOK);
            this.tags.get(this.state.action).addArc(this.state.actionErr, true);
            this.state.reset();
        }
    }

    private static class WorkflowParseState {
        private String action;
        private String actionOK;
        private String actionErr;
        private String actionType;
        private String fork;
        private String decision;

        private WorkflowParseState() {
        }

        public void reset() {
            this.action = null;
            this.actionOK = null;
            this.actionErr = null;
            this.actionType = null;
        }
    }
}

