/*
 * Decompiled with CFR 0.152.
 */
package org.apache.oozie.util;

import java.io.IOException;
import java.util.Date;
import java.util.Map;
import org.apache.oozie.command.CommandException;
import org.apache.oozie.service.ConfigurationService;
import org.apache.oozie.service.Services;
import org.apache.oozie.service.XLogService;
import org.apache.oozie.util.XLogAuditFilter;
import org.apache.oozie.util.XLogFilter;
import org.apache.oozie.util.XLogStreamer;
import org.apache.oozie.util.XLogUserFilterParam;

public class XLogAuditStreamer
extends XLogStreamer {
    public static final String STREAM_BUFFER_LEN = "oozie.service.XLogStreamingService.audit.buffer.len";

    public XLogAuditStreamer(XLogFilter logFilter, Map<String, String[]> requestParameters) {
        super(logFilter, Services.get().get(XLogService.class).getOozieAuditLogPath(), Services.get().get(XLogService.class).getOozieAuditLogName(), Services.get().get(XLogService.class).getOozieAuditLogRotation());
        this.requestParam = requestParameters;
        this.bufferLen = ConfigurationService.getInt(STREAM_BUFFER_LEN, 3);
    }

    public XLogAuditStreamer(Map<String, String[]> requestParameters) throws CommandException {
        this(new XLogAuditFilter(new XLogUserFilterParam(requestParameters)), requestParameters);
    }

    @Override
    protected void calculateAndValidateDateRange(Date startTime, Date endTime) throws IOException {
        this.logFilter.calculateAndCheckDates(startTime, endTime);
    }

    @Override
    public boolean isLogEnabled() {
        return Services.get().get(XLogService.class).isAuditLogEnabled();
    }

    @Override
    public String getLogType() {
        return "auditlog";
    }

    @Override
    public String getLogDisableMessage() {
        return "Audit Log is disabled!!";
    }

    @Override
    public boolean shouldFlushOutput(int byteCountIgnored) {
        ++this.totalDataWritten;
        if (this.totalDataWritten > this.getBufferLen()) {
            this.totalDataWritten = 0;
            return true;
        }
        return false;
    }
}

