/*
 * Decompiled with CFR 0.152.
 */
package org.apache.oozie.util;

import com.google.common.base.Preconditions;
import org.apache.hadoop.conf.Configuration;
import org.apache.oozie.service.ConfigurationService;
import org.apache.oozie.servlet.ServicesLoader;
import org.apache.oozie.util.PropertiesUtils;
import org.apache.oozie.util.XLog;

public class ConfigUtils {
    private static final XLog LOG = XLog.getLog(ConfigUtils.class);
    public static final String OOZIE_HTTPS_ENABLED = "oozie.https.enabled";
    public static final String OOZIE_HTTP_HOSTNAME = "oozie.http.hostname";
    public static final String OOZIE_HTTPS_PORT = "oozie.https.port";
    public static final String OOZIE_HTTP_PORT = "oozie.http.port";
    public static boolean BOOLEAN_DEFAULT = false;
    public static String STRING_DEFAULT = "";
    public static int INT_DEFAULT = 0;
    public static float FLOAT_DEFAULT = 0.0f;
    public static long LONG_DEFAULT = 0L;

    public static String getWithDeprecatedCheck(Configuration conf, String newName, String oldName, String defaultValue) {
        String value = conf.get(oldName, null);
        if (value == null) {
            value = conf.get(newName, defaultValue);
        } else {
            LOG.warn("Using a deprecated configuration property [{0}], should use [{1}].  Please delete the deprecated property in order for the new property to take effect.", oldName, newName);
        }
        return value;
    }

    public static boolean getWithDeprecatedCheck(Configuration conf, String newName, String oldName, boolean defaultValue) {
        String value = ConfigUtils.getWithDeprecatedCheck(conf, newName, oldName, Boolean.toString(defaultValue));
        return Boolean.parseBoolean(value);
    }

    public static String getOozieURL(boolean secure) {
        StringBuilder sb = new StringBuilder();
        if (secure) {
            sb.append("https://");
        } else {
            sb.append("http://");
        }
        sb.append(ConfigurationService.get(OOZIE_HTTP_HOSTNAME));
        sb.append(":");
        if (secure) {
            sb.append(ConfigurationService.get(OOZIE_HTTPS_PORT));
        } else {
            sb.append(ConfigurationService.get(OOZIE_HTTP_PORT));
        }
        sb.append("/oozie");
        return sb.toString();
    }

    public static String getOozieEffectiveUrl() {
        return ConfigUtils.getOozieURL(ServicesLoader.isSSLEnabled() || ConfigurationService.getBoolean(OOZIE_HTTPS_ENABLED));
    }

    public static boolean isBackwardSupportForCoordStatus() {
        return ConfigurationService.getBoolean("oozie.service.StatusTransitService.backward.support.for.coord.status");
    }

    public static <E extends Exception> void checkAndSetDisallowedProperties(Configuration base, String newValue, E toThrow, boolean performWrite) throws E {
        Preconditions.checkNotNull((Object)base, (Object)"base");
        Preconditions.checkNotNull((Object)newValue, (Object)"newValue");
        Preconditions.checkNotNull(toThrow, (Object)"toThrow");
        for (String defaultDisallowedProperty : PropertiesUtils.DEFAULT_DISALLOWED_PROPERTIES) {
            ConfigUtils.checkAndSetConfigValue(base, defaultDisallowedProperty, newValue, toThrow, performWrite);
        }
    }

    private static <E extends Exception> void checkAndSetConfigValue(Configuration base, String key, String newValue, E toThrow, boolean performWrite) throws E {
        boolean isPresent;
        boolean shouldCheckAndSet = ConfigurationService.getBoolean("oozie.configuration.check-and-set." + key, false);
        boolean bl = isPresent = base.get(key) != null;
        if (isPresent && !base.get(key).equals(newValue)) {
            LOG.trace("Base configuration contains config property [{0}={1}] that is different from new value [{2}]", key, base.get(key), newValue);
            if (shouldCheckAndSet && performWrite) {
                LOG.trace("Setting [{0}] to [{1}]", key, newValue);
                base.set(key, newValue);
            } else if (!shouldCheckAndSet) {
                LOG.error("Cannot set [{0}] to [{1}]. {2}", key, newValue, toThrow.getMessage());
                throw toThrow;
            }
        }
    }
}

