/*
 * Decompiled with CFR 0.152.
 */
package org.apache.oozie.util;

import com.google.common.annotations.VisibleForTesting;
import java.io.File;
import java.io.IOException;
import java.net.URI;
import java.net.URISyntaxException;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import org.apache.commons.lang.StringUtils;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.FileContext;
import org.apache.hadoop.fs.FileSystem;
import org.apache.hadoop.fs.Path;
import org.apache.hadoop.mapreduce.MRJobConfig;
import org.apache.hadoop.mapreduce.filecache.DistributedCache;
import org.apache.hadoop.mapreduce.v2.util.MRApps;
import org.apache.hadoop.yarn.api.ApplicationConstants;
import org.apache.hadoop.yarn.conf.YarnConfiguration;

public class ClasspathUtils {
    private static boolean usingMiniYarnCluster = false;
    private static final List<String> CLASSPATH_ENTRIES = Arrays.asList(ApplicationConstants.Environment.PWD.$(), ApplicationConstants.Environment.PWD.$() + "/" + "*");

    @VisibleForTesting
    public static void setUsingMiniYarnCluster(boolean useMiniYarnCluster) {
        usingMiniYarnCluster = useMiniYarnCluster;
    }

    public static void setupClasspath(Map<String, String> env, Configuration conf) throws IOException {
        if (usingMiniYarnCluster) {
            MRApps.addToEnvironment(env, (String)ApplicationConstants.Environment.CLASSPATH.name(), (String)System.getProperty("java.class.path"), (Configuration)conf);
        }
        for (String entry : CLASSPATH_ENTRIES) {
            MRApps.addToEnvironment(env, (String)ApplicationConstants.Environment.CLASSPATH.name(), (String)entry, (Configuration)conf);
        }
        ClasspathUtils.addToClasspathIfNotJar(DistributedCache.getFileClassPaths((Configuration)conf), DistributedCache.getCacheFiles((Configuration)conf), conf, env, ApplicationConstants.Environment.PWD.$());
        ClasspathUtils.addToClasspathIfNotJar(DistributedCache.getArchiveClassPaths((Configuration)conf), DistributedCache.getCacheArchives((Configuration)conf), conf, env, ApplicationConstants.Environment.PWD.$());
        boolean crossPlatform = conf.getBoolean("mapreduce.app-submission.cross-platform", false);
        for (String c : conf.getStrings("yarn.application.classpath", crossPlatform ? YarnConfiguration.DEFAULT_YARN_CROSS_PLATFORM_APPLICATION_CLASSPATH : YarnConfiguration.DEFAULT_YARN_APPLICATION_CLASSPATH)) {
            MRApps.addToEnvironment(env, (String)ApplicationConstants.Environment.CLASSPATH.name(), (String)c.trim(), (Configuration)conf);
        }
        ClasspathUtils.addGPLExtrasJarsAndNativeLibs(env, conf);
    }

    private static void addGPLExtrasJarsAndNativeLibs(Map<String, String> env, Configuration conf) {
        MRApps.addToEnvironment(env, (String)ApplicationConstants.Environment.CLASSPATH.name(), (String)"$MR2_CLASSPATH", (Configuration)conf);
        MRApps.addToEnvironment(env, (String)ApplicationConstants.Environment.LD_LIBRARY_PATH.name(), (String)"$JAVA_LIBRARY_PATH", (Configuration)conf);
    }

    public static void addMapReduceToClasspath(Map<String, String> env, Configuration conf) throws IOException {
        boolean crossPlatform = conf.getBoolean("mapreduce.app-submission.cross-platform", false);
        for (String c : conf.getStrings("mapreduce.application.classpath", crossPlatform ? org.apache.hadoop.util.StringUtils.getStrings((String)MRJobConfig.DEFAULT_MAPREDUCE_CROSS_PLATFORM_APPLICATION_CLASSPATH) : org.apache.hadoop.util.StringUtils.getStrings((String)MRJobConfig.DEFAULT_MAPREDUCE_APPLICATION_CLASSPATH))) {
            MRApps.addToEnvironment(env, (String)ApplicationConstants.Environment.CLASSPATH.name(), (String)c.trim(), (Configuration)conf);
        }
        ClasspathUtils.addMRFrameworkToDistributedCache(conf);
    }

    private static void addMRFrameworkToDistributedCache(Configuration conf) throws IOException {
        String framework = conf.get("mapreduce.application.framework.path", "");
        if (!framework.isEmpty()) {
            URI uri;
            try {
                uri = new URI(framework);
            }
            catch (URISyntaxException e) {
                throw new IllegalArgumentException("Unable to parse '" + framework + "' as a URI, check the setting for " + "mapreduce.application.framework.path", e);
            }
            String linkedName = uri.getFragment();
            FileSystem fs = FileSystem.get((URI)uri, (Configuration)conf);
            Path frameworkPath = fs.makeQualified(new Path(uri.getScheme(), uri.getAuthority(), uri.getPath()));
            FileContext fc = FileContext.getFileContext((URI)frameworkPath.toUri(), (Configuration)conf);
            frameworkPath = fc.resolvePath(frameworkPath);
            uri = frameworkPath.toUri();
            try {
                uri = new URI(uri.getScheme(), uri.getAuthority(), uri.getPath(), null, linkedName);
            }
            catch (URISyntaxException e) {
                throw new IllegalArgumentException(e);
            }
            DistributedCache.addCacheArchive((URI)uri, (Configuration)conf);
        }
    }

    private static void addToClasspathIfNotJar(Path[] paths, URI[] withLinks, Configuration conf, Map<String, String> environment, String classpathEnvVar) throws IOException {
        if (paths != null) {
            HashMap<Path, String> linkLookup = new HashMap<Path, String>();
            if (withLinks != null) {
                for (URI uRI : withLinks) {
                    String name;
                    Path p = new Path(uRI);
                    FileSystem remoteFS = p.getFileSystem(conf);
                    p = remoteFS.resolvePath(p.makeQualified(remoteFS.getUri(), remoteFS.getWorkingDirectory()));
                    String string = name = null == uRI.getFragment() ? p.getName() : uRI.getFragment();
                    if (name.toLowerCase(Locale.ENGLISH).endsWith(".jar")) continue;
                    linkLookup.put(p, name);
                }
            }
            for (URI uRI : paths) {
                FileSystem remoteFS = uRI.getFileSystem(conf);
                Path path = remoteFS.resolvePath(uRI.makeQualified(remoteFS.getUri(), remoteFS.getWorkingDirectory()));
                String name = (String)linkLookup.get(path);
                if (name == null) {
                    name = path.getName();
                }
                if (name.toLowerCase(Locale.ENGLISH).endsWith(".jar")) continue;
                MRApps.addToEnvironment(environment, (String)classpathEnvVar, (String)(ApplicationConstants.Environment.PWD.$() + "/" + name), (Configuration)conf);
            }
        }
    }

    public static Configuration addToClasspathFromLocalShareLib(Configuration conf, Path libPath) {
        if (conf == null) {
            conf = new Configuration(false);
        }
        String pathStr = ClasspathUtils.normalizedLocalFsPath(libPath);
        String appClassPath = conf.get("yarn.application.classpath");
        if (StringUtils.isEmpty((String)appClassPath)) {
            ClasspathUtils.addPathToYarnClasspathInConfig(conf, pathStr, org.apache.hadoop.util.StringUtils.join((CharSequence)File.pathSeparator, (String[])YarnConfiguration.DEFAULT_YARN_CROSS_PLATFORM_APPLICATION_CLASSPATH));
        } else {
            ClasspathUtils.addPathToYarnClasspathInConfig(conf, pathStr, appClassPath);
        }
        return conf;
    }

    private static void addPathToYarnClasspathInConfig(Configuration conf, String pathStr, String appClassPath) {
        conf.set("yarn.application.classpath", appClassPath + File.pathSeparator + pathStr);
    }

    private static String normalizedLocalFsPath(Path libPath) {
        return StringUtils.replace((String)libPath.toString(), (String)"file:", (String)"");
    }
}

