/*
 * Decompiled with CFR 0.152.
 */
package org.apache.oozie.sla.service;

import com.google.common.annotations.VisibleForTesting;
import java.util.Date;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.apache.hadoop.conf.Configuration;
import org.apache.oozie.ErrorCode;
import org.apache.oozie.client.event.JobEvent;
import org.apache.oozie.executor.jpa.JPAExecutorException;
import org.apache.oozie.service.ConfigurationService;
import org.apache.oozie.service.EventHandlerService;
import org.apache.oozie.service.SchedulerService;
import org.apache.oozie.service.Service;
import org.apache.oozie.service.ServiceException;
import org.apache.oozie.service.Services;
import org.apache.oozie.sla.SLACalculator;
import org.apache.oozie.sla.SLACalculatorMemory;
import org.apache.oozie.sla.SLARegistrationBean;
import org.apache.oozie.util.Pair;
import org.apache.oozie.util.XLog;

public class SLAService
implements Service {
    public static final String CONF_PREFIX = "oozie.sla.service.SLAService.";
    public static final String CONF_CALCULATOR_IMPL = "oozie.sla.service.SLAService.calculator.impl";
    public static final String CONF_CAPACITY = "oozie.sla.service.SLAService.capacity";
    public static final String CONF_ALERT_EVENTS = "oozie.sla.service.SLAService.alert.events";
    public static final String CONF_EVENTS_MODIFIED_AFTER = "oozie.sla.service.SLAService.events.modified.after";
    public static final String CONF_JOB_EVENT_LATENCY = "oozie.sla.service.SLAService.job.event.latency";
    public static final String CONF_SLA_CHECK_INTERVAL = "oozie.sla.service.SLAService.check.interval";
    public static final String CONF_SLA_CHECK_INITIAL_DELAY = "oozie.sla.service.SLAService.check.initial.delay";
    public static final String CONF_SLA_CALC_LOCK_TIMEOUT = "oozie.sla.service.SLAService.oozie.sla.calc.default.lock.timeout";
    public static final String CONF_SLA_HISTORY_PURGE_INTERVAL = "oozie.sla.service.SLAService.history.purge.interval";
    public static final String CONF_MAXIMUM_RETRY_COUNT = "oozie.sla.service.SLAService.maximum.retry.count";
    private static SLACalculator calcImpl;
    private static boolean slaEnabled;
    private EventHandlerService eventHandler;
    public static XLog LOG;

    @Override
    public void init(Services services) throws ServiceException {
        try {
            Configuration conf = services.getConf();
            Class<?> calcClazz = ConfigurationService.getClass(conf, CONF_CALCULATOR_IMPL);
            calcImpl = calcClazz == null ? new SLACalculatorMemory() : (SLACalculator)calcClazz.newInstance();
            calcImpl.init(conf);
            this.eventHandler = Services.get().get(EventHandlerService.class);
            if (this.eventHandler == null) {
                throw new ServiceException(ErrorCode.E0103, "EventHandlerService", "Add it under config oozie.services.ext or declare it BEFORE SLAService");
            }
            LOG = XLog.getLog(this.getClass());
            Set<String> appTypes = this.eventHandler.getAppTypes();
            appTypes.add("workflow_action");
            this.eventHandler.setAppTypes(appTypes);
            SLAWorker slaThread = new SLAWorker(calcImpl);
            int slaCheckInterval = ConfigurationService.getInt(conf, CONF_SLA_CHECK_INTERVAL);
            int slaCheckInitialDelay = ConfigurationService.getInt(conf, CONF_SLA_CHECK_INITIAL_DELAY);
            services.get(SchedulerService.class).schedule(slaThread, (long)slaCheckInitialDelay, (long)slaCheckInterval, SchedulerService.Unit.SEC);
            slaEnabled = true;
            LOG.info("SLAService initialized with impl [{0}] capacity [{1}]", calcImpl.getClass().getName(), conf.get(CONF_CAPACITY));
        }
        catch (Exception ex) {
            throw new ServiceException(ErrorCode.E0102, ex.getMessage(), ex);
        }
    }

    @Override
    public void destroy() {
        slaEnabled = false;
    }

    @Override
    public Class<? extends Service> getInterface() {
        return SLAService.class;
    }

    public static boolean isEnabled() {
        return slaEnabled;
    }

    @VisibleForTesting
    public SLACalculator getSLACalculator() {
        return calcImpl;
    }

    public void runSLAWorker() {
        new SLAWorker(calcImpl).run();
    }

    @VisibleForTesting
    public void startSLAWorker() {
        new Thread(new SLAWorker(calcImpl)).start();
    }

    public boolean addRegistrationEvent(SLARegistrationBean reg) throws ServiceException {
        try {
            if (calcImpl.addRegistration(reg.getId(), reg)) {
                return true;
            }
            LOG.warn("SLA queue full. Unable to add new SLA entry for job [{0}]", reg.getId());
        }
        catch (JPAExecutorException ex) {
            LOG.warn("Could not add new SLA entry for job [{0}]", reg.getId(), ex);
        }
        return false;
    }

    public boolean updateRegistrationEvent(SLARegistrationBean reg) throws ServiceException {
        try {
            if (calcImpl.updateRegistration(reg.getId(), reg)) {
                return true;
            }
            LOG.warn("SLA queue full. Unable to update the SLA entry for job [{0}]", reg.getId());
        }
        catch (JPAExecutorException ex) {
            LOG.warn("Could not update SLA entry for job [{0}]", reg.getId(), ex);
        }
        return false;
    }

    public boolean addStatusEvent(String jobId, String status, JobEvent.EventStatus eventStatus, Date startTime, Date endTime) throws ServiceException {
        try {
            if (calcImpl.addJobStatus(jobId, status, eventStatus, startTime, endTime)) {
                return true;
            }
        }
        catch (JPAExecutorException jpe) {
            LOG.error("Exception while adding SLA Status event for Job [{0}]", jobId);
        }
        return false;
    }

    public void removeRegistration(String jobId) {
        calcImpl.removeRegistration(jobId);
    }

    public boolean enableAlert(List<String> jobIds) throws ServiceException {
        try {
            return calcImpl.enableAlert(jobIds);
        }
        catch (JPAExecutorException jpe) {
            LOG.error("Exception while updating SLA alerting for Job [{0}]", jobIds.get(0));
            throw new ServiceException(jpe);
        }
    }

    public boolean enableChildJobAlert(List<String> parentJobIds) throws ServiceException {
        try {
            return calcImpl.enableChildJobAlert(parentJobIds);
        }
        catch (JPAExecutorException jpe) {
            LOG.error("Exception while updating SLA alerting for Job [{0}]", parentJobIds.get(0));
            throw new ServiceException(jpe);
        }
    }

    public boolean disableAlert(List<String> jobIds) throws ServiceException {
        try {
            return calcImpl.disableAlert(jobIds);
        }
        catch (JPAExecutorException jpe) {
            LOG.error("Exception while updating SLA alerting for Job [{0}]", jobIds.get(0));
            throw new ServiceException(jpe);
        }
    }

    public boolean disableChildJobAlert(List<String> parentJobIds) throws ServiceException {
        try {
            return calcImpl.disableChildJobAlert(parentJobIds);
        }
        catch (JPAExecutorException jpe) {
            LOG.error("Exception while updating SLA alerting for Job [{0}]", parentJobIds.get(0));
            throw new ServiceException(jpe);
        }
    }

    public boolean changeDefinition(List<Pair<String, Map<String, String>>> idSlaDefinitionList) throws ServiceException {
        try {
            return calcImpl.changeDefinition(idSlaDefinitionList);
        }
        catch (JPAExecutorException jpe) {
            throw new ServiceException(jpe);
        }
    }

    static {
        slaEnabled = false;
    }

    private class SLAWorker
    implements Runnable {
        SLACalculator calc;

        public SLAWorker(SLACalculator calc) {
            this.calc = calc;
        }

        @Override
        public void run() {
            if (Thread.currentThread().isInterrupted()) {
                return;
            }
            try {
                this.calc.updateAllSlaStatus();
            }
            catch (Throwable error) {
                XLog.getLog(SLAService.class).debug((Object)"Throwable in SLAWorker thread run : ", error);
            }
        }
    }
}

