/*
 * Decompiled with CFR 0.152.
 */
package org.apache.oozie.servlet;

import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Reader;
import java.io.StringReader;
import java.io.StringWriter;
import java.net.URI;
import java.util.Arrays;
import javax.servlet.ServletException;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import javax.xml.transform.stream.StreamSource;
import javax.xml.validation.Schema;
import javax.xml.validation.Validator;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.FileSystem;
import org.apache.hadoop.fs.Path;
import org.apache.oozie.ErrorCode;
import org.apache.oozie.cli.OozieCLIException;
import org.apache.oozie.service.HadoopAccessorService;
import org.apache.oozie.service.SchemaService;
import org.apache.oozie.service.Services;
import org.apache.oozie.servlet.JsonRestServlet;
import org.apache.oozie.servlet.XServletException;
import org.apache.oozie.util.IOUtils;
import org.json.simple.JSONObject;
import org.json.simple.JSONStreamAware;
import org.xml.sax.SAXException;

public class V2ValidateServlet
extends JsonRestServlet {
    private static final String INSTRUMENTATION_NAME = "v2validate";
    private static final JsonRestServlet.ResourceInfo RESOURCE_INFO = new JsonRestServlet.ResourceInfo("", Arrays.asList("POST"), Arrays.asList(new JsonRestServlet.ParameterInfo("file", String.class, true, Arrays.asList("POST")), new JsonRestServlet.ParameterInfo("user", String.class, true, Arrays.asList("POST"))));

    public V2ValidateServlet() {
        super(INSTRUMENTATION_NAME, RESOURCE_INFO);
    }

    protected void doPost(HttpServletRequest request, HttpServletResponse response) throws ServletException, IOException {
        this.validateContentType(request, "application/xml");
        String file = request.getParameter("file");
        String user = request.getParameter("user");
        this.stopCron();
        StringWriter stringWriter = new StringWriter();
        if (file.startsWith("hdfs://")) {
            try {
                URI uri = new URI(file);
                HadoopAccessorService has = Services.get().get(HadoopAccessorService.class);
                Configuration fsConf = has.createConfiguration(uri.getAuthority());
                FileSystem fs = has.createFileSystem(user, uri, fsConf);
                Path path = new Path(uri.getPath());
                IOUtils.copyCharStream(new InputStreamReader((InputStream)fs.open(path)), stringWriter);
            }
            catch (Exception e) {
                throw new XServletException(400, ErrorCode.E0505, "File does not exist, " + file);
            }
        } else {
            IOUtils.copyCharStream(new InputStreamReader((InputStream)request.getInputStream()), stringWriter);
        }
        try {
            this.validate(stringWriter.toString());
        }
        catch (Exception e) {
            throw new XServletException(400, ErrorCode.E0701, file + ", " + e.toString());
        }
        JSONObject json = this.createJSON("Valid workflow-app");
        this.startCron();
        this.sendJsonResponse(response, 200, (JSONStreamAware)json);
    }

    private void validate(String xml) throws Exception {
        SchemaService schemaService = Services.get().get(SchemaService.class);
        Schema[] schemas = new Schema[]{schemaService.getSchema(SchemaService.SchemaName.WORKFLOW), schemaService.getSchema(SchemaService.SchemaName.COORDINATOR), schemaService.getSchema(SchemaService.SchemaName.BUNDLE), schemaService.getSchema(SchemaService.SchemaName.SLA_ORIGINAL)};
        Exception exception = null;
        for (int i = 0; i < schemas.length; ++i) {
            try {
                this.validateSchema(schemas[i], new StringReader(xml));
                exception = null;
            }
            catch (SAXException e) {
                if (i == 0) {
                    exception = e;
                }
                if (e.getMessage().contains("cvc-elt.1")) continue;
                exception = e;
            }
            catch (Exception e) {
                exception = e;
            }
            break;
        }
        if (exception != null) {
            throw exception;
        }
    }

    private void validateSchema(Schema schema, Reader src) throws SAXException, IOException, OozieCLIException {
        Validator validator = SchemaService.getValidator(schema);
        validator.validate(new StreamSource(src));
    }

    private JSONObject createJSON(String content) {
        JSONObject jsonObject = new JSONObject();
        jsonObject.put((Object)"validate", (Object)content);
        return jsonObject;
    }
}

