/*
 * Decompiled with CFR 0.152.
 */
package org.apache.oozie.service;

import java.io.BufferedReader;
import java.io.IOException;
import java.io.Writer;
import java.net.URLEncoder;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import java.util.Map;
import java.util.TreeMap;
import org.apache.commons.lang.StringUtils;
import org.apache.curator.x.discovery.ServiceInstance;
import org.apache.oozie.ErrorCode;
import org.apache.oozie.service.JobsConcurrencyService;
import org.apache.oozie.service.Service;
import org.apache.oozie.service.ServiceException;
import org.apache.oozie.service.Services;
import org.apache.oozie.service.XLogStreamingService;
import org.apache.oozie.util.AuthUrlClient;
import org.apache.oozie.util.Instrumentable;
import org.apache.oozie.util.Instrumentation;
import org.apache.oozie.util.SimpleTimestampedMessageParser;
import org.apache.oozie.util.TimestampedMessageParser;
import org.apache.oozie.util.XLog;
import org.apache.oozie.util.XLogStreamer;
import org.apache.oozie.util.ZKUtils;

public class ZKXLogStreamingService
extends XLogStreamingService
implements Service,
Instrumentable {
    private ZKUtils zk;
    private XLog log;

    @Override
    public void init(Services services) throws ServiceException {
        super.init(services);
        try {
            this.zk = ZKUtils.register(this);
        }
        catch (Exception ex) {
            throw new ServiceException(ErrorCode.E1700, ex.getMessage(), ex);
        }
        this.log = XLog.getLog(this.getClass());
    }

    @Override
    public void destroy() {
        if (this.zk != null) {
            this.zk.unregister(this);
        }
        this.zk = null;
        super.destroy();
    }

    @Override
    public void instrument(Instrumentation instr) {
        super.instrument(instr);
    }

    @Override
    public void streamLog(XLogStreamer logStreamer, Date startTime, Date endTime, Writer writer) throws IOException {
        if (!logStreamer.isLogEnabled()) {
            writer.write(logStreamer.getLogDisableMessage());
            return;
        }
        if (!Services.get().get(JobsConcurrencyService.class).isAllServerRequest(logStreamer.getRequestParam())) {
            super.streamLog(logStreamer, startTime, endTime, writer, false);
        } else {
            this.collateLogs(logStreamer, startTime, endTime, writer);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void collateLogs(XLogStreamer logStreamer, Date startTime, Date endTime, Writer writer) throws IOException {
        ArrayList<String> badOozies = new ArrayList<String>();
        List<ServiceInstance<Map>> oozies = null;
        try {
            oozies = this.zk.getAllMetaData();
        }
        catch (Exception ex) {
            throw new IOException("Issue communicating with ZooKeeper: " + ex.getMessage(), ex);
        }
        ArrayList<TimestampedMessageParser> parsers = new ArrayList<TimestampedMessageParser>(oozies.size());
        try {
            for (ServiceInstance<Map> serviceInstance : oozies) {
                Map oozieMeta = (Map)serviceInstance.getPayload();
                String otherId = (String)oozieMeta.get("OOZIE_ID");
                if (otherId.equals(this.zk.getZKId())) {
                    BufferedReader reader = logStreamer.makeReader(startTime, endTime);
                    parsers.add(new TimestampedMessageParser(reader, logStreamer.getXLogFilter()));
                    continue;
                }
                String otherUrl = (String)oozieMeta.get("OOZIE_URL");
                String jobId = logStreamer.getXLogFilter().getFilterParams().get("JOB");
                try {
                    String url = otherUrl + "/v" + 2L + "/" + "job" + "/" + jobId + "?" + "show" + "=" + logStreamer.getLogType() + "&" + "allservers" + "=false" + AuthUrlClient.getQueryParamString(logStreamer.getRequestParam());
                    String key = "doAs";
                    String[] value = null;
                    if (logStreamer.getRequestParam() != null) {
                        value = logStreamer.getRequestParam().get(key);
                    }
                    String urlWithoutdoAs = null;
                    urlWithoutdoAs = value != null && value.length > 0 && value[0] != null && value[0].length() > 0 ? url.replace("&" + key + "=" + URLEncoder.encode(value[0], "UTF-8"), "") : url;
                    BufferedReader reader = AuthUrlClient.callServer(urlWithoutdoAs);
                    parsers.add(new SimpleTimestampedMessageParser(reader, logStreamer.getXLogFilter()));
                }
                catch (IOException ioe) {
                    this.log.warn((Object)("Failed to retrieve logs for job [" + jobId + "] from Oozie server with ID [" + otherId + "] at [" + otherUrl + "]; log information may be incomplete"), ioe);
                    badOozies.add(otherId);
                }
            }
            if (!StringUtils.isEmpty((String)logStreamer.getXLogFilter().getTruncatedMessage())) {
                writer.write(logStreamer.getXLogFilter().getTruncatedMessage());
            }
            if (logStreamer.getXLogFilter().isDebugMode()) {
                writer.write(logStreamer.getXLogFilter().getDebugMessage());
            }
            if (!badOozies.isEmpty()) {
                writer.write("Unable to contact the following Oozie Servers for logs (log information may be incomplete):\n");
                for (String string : badOozies) {
                    writer.write("     ");
                    writer.write(string);
                    writer.write("\n");
                }
                writer.write("\n");
                writer.flush();
            }
            if (parsers.size() == 1) {
                TimestampedMessageParser parser = (TimestampedMessageParser)parsers.get(0);
                parser.processRemaining(writer, logStreamer);
            } else {
                TreeMap<String, TimestampedMessageParser> timestampMap = new TreeMap<String, TimestampedMessageParser>();
                for (TimestampedMessageParser parser : parsers) {
                    if (!parser.increment()) continue;
                    timestampMap.put(parser.getLastTimestamp(), parser);
                }
                while (timestampMap.size() > 1) {
                    TimestampedMessageParser timestampedMessageParser = (TimestampedMessageParser)timestampMap.pollFirstEntry().getValue();
                    writer.write(timestampedMessageParser.getLastMessage());
                    if (logStreamer.shouldFlushOutput(timestampedMessageParser.getLastMessage().length())) {
                        writer.flush();
                    }
                    if (!timestampedMessageParser.increment()) continue;
                    timestampMap.put(timestampedMessageParser.getLastTimestamp(), timestampedMessageParser);
                }
                if (timestampMap.size() == 1) {
                    TimestampedMessageParser timestampedMessageParser = (TimestampedMessageParser)timestampMap.values().iterator().next();
                    writer.write(timestampedMessageParser.getLastMessage());
                    timestampedMessageParser.processRemaining(writer, logStreamer);
                }
            }
        }
        finally {
            for (TimestampedMessageParser timestampedMessageParser : parsers) {
                timestampedMessageParser.closeReader();
            }
        }
    }
}

