/*
 * Decompiled with CFR 0.152.
 */
package org.apache.oozie.service;

import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import org.apache.commons.logging.LogFactory;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.util.ReflectionUtils;
import org.apache.hadoop.util.VersionInfo;
import org.apache.oozie.BuildInfo;
import org.apache.oozie.ErrorCode;
import org.apache.oozie.client.OozieClient;
import org.apache.oozie.service.ConfigurationService;
import org.apache.oozie.service.InstrumentationService;
import org.apache.oozie.service.Service;
import org.apache.oozie.service.ServiceException;
import org.apache.oozie.service.XLogService;
import org.apache.oozie.util.DateUtils;
import org.apache.oozie.util.IOUtils;
import org.apache.oozie.util.Instrumentable;
import org.apache.oozie.util.Instrumentation;
import org.apache.oozie.util.XLog;

public class Services {
    private static final int MAX_SYSTEM_ID_LEN = 10;
    public static final String OOZIE_HOME_DIR = "oozie.home.dir";
    public static final String CONF_SYSTEM_ID = "oozie.system.id";
    public static final String CONF_SERVICE_CLASSES = "oozie.services";
    public static final String CONF_SERVICE_EXT_CLASSES = "oozie.services.ext";
    public static final String CONF_SYSTEM_MODE = "oozie.systemmode";
    public static final String CONF_DELETE_RUNTIME_DIR = "oozie.delete.runtime.dir.on.shutdown";
    private static Services SERVICES;
    private OozieClient.SYSTEM_MODE systemMode;
    private String runtimeDir;
    private Configuration conf;
    private Map<Class<? extends Service>, Service> services = new LinkedHashMap<Class<? extends Service>, Service>();
    private String systemId;
    private static String oozieHome;

    public static void setOozieHome() throws ServiceException {
        oozieHome = System.getProperty(OOZIE_HOME_DIR);
        if (oozieHome == null) {
            throw new ServiceException(ErrorCode.E0000, new Object[0]);
        }
        File file = new File(oozieHome);
        if (!file.isAbsolute()) {
            throw new ServiceException(ErrorCode.E0003, oozieHome);
        }
        if (!file.exists()) {
            throw new ServiceException(ErrorCode.E0004, oozieHome);
        }
    }

    public static String getOozieHome() throws ServiceException {
        return oozieHome;
    }

    public Services() throws ServiceException {
        Services.setOozieHome();
        if (SERVICES != null) {
            XLog log = XLog.getLog(this.getClass());
            log.warn(4, "Previous services singleton active, destroying it", new Object[0]);
            SERVICES.destroy();
            SERVICES = null;
        }
        this.setServiceInternal(XLogService.class, false);
        this.setServiceInternal(ConfigurationService.class, true);
        this.conf = this.get(ConfigurationService.class).getConf();
        DateUtils.setConf(this.conf);
        if (!DateUtils.getOozieProcessingTimeZone().equals(DateUtils.UTC)) {
            XLog.getLog(this.getClass()).warn("Oozie configured to work in a timezone other than UTC: {0}", DateUtils.getOozieProcessingTimeZone().getID());
        }
        this.systemId = ConfigurationService.get(this.conf, CONF_SYSTEM_ID);
        if (this.systemId.length() > 10) {
            this.systemId = this.systemId.substring(0, 10);
            XLog.getLog(this.getClass()).warn("System ID [{0}] exceeds maximum length [{1}], trimming", this.systemId, 10);
        }
        this.setSystemMode(OozieClient.SYSTEM_MODE.valueOf((String)ConfigurationService.get(this.conf, CONF_SYSTEM_MODE)));
        this.runtimeDir = this.createRuntimeDir();
    }

    private String createRuntimeDir() throws ServiceException {
        try {
            File file = File.createTempFile(this.getSystemId(), ".dir");
            file.delete();
            if (!file.mkdir()) {
                ServiceException ex = new ServiceException(ErrorCode.E0001, file.getAbsolutePath());
                XLog.getLog(this.getClass()).fatal(ex);
                throw ex;
            }
            XLog.getLog(this.getClass()).info("Initialized runtime directory [{0}]", file.getAbsolutePath());
            return file.getAbsolutePath();
        }
        catch (IOException ex) {
            ServiceException sex = new ServiceException(ErrorCode.E0001, "", ex);
            XLog.getLog(this.getClass()).fatal(ex);
            throw sex;
        }
    }

    public OozieClient.SYSTEM_MODE getSystemMode() {
        return this.systemMode;
    }

    public String getRuntimeDir() {
        return this.runtimeDir;
    }

    public String getSystemId() {
        return this.systemId;
    }

    public synchronized void setSystemMode(OozieClient.SYSTEM_MODE sysMode) {
        if (this.systemMode != sysMode) {
            XLog log = XLog.getLog(this.getClass());
            log.info(4, "Exiting " + this.systemMode + " Entering " + sysMode, new Object[0]);
        }
        this.systemMode = sysMode;
    }

    @Deprecated
    public Configuration getConf() {
        return this.conf;
    }

    public void init() throws ServiceException {
        XLog log = new XLog(LogFactory.getLog(this.getClass()));
        log.trace("Initializing");
        SERVICES = this;
        try {
            this.loadServices();
        }
        catch (RuntimeException rex) {
            XLog.getLog(this.getClass()).fatal((Object)rex.getMessage(), rex);
            throw rex;
        }
        catch (ServiceException ex) {
            XLog.getLog(this.getClass()).fatal((Object)ex.getMessage(), ex);
            SERVICES = null;
            throw ex;
        }
        InstrumentationService instrService = this.get(InstrumentationService.class);
        if (instrService != null) {
            Instrumentation instr = instrService.get();
            for (Service service : this.services.values()) {
                if (!(service instanceof Instrumentable)) continue;
                ((Instrumentable)((Object)service)).instrument(instr);
            }
            instr.addVariable("oozie", "version", new Instrumentation.Variable<String>(){

                @Override
                public String getValue() {
                    return BuildInfo.getBuildInfo().getProperty("build.version");
                }
            });
            instr.addVariable("oozie", "mode", new Instrumentation.Variable<String>(){

                @Override
                public String getValue() {
                    return Services.this.getSystemMode().toString();
                }
            });
        }
        log.info("Initialized");
        log.info("Running with JARs for Hadoop version [{0}]", VersionInfo.getVersion());
        log.info("Oozie System ID [{0}] started!", this.getSystemId());
    }

    private void loadServices(Class<?>[] classes, List<Service> list) throws ServiceException {
        XLog log = new XLog(LogFactory.getLog(this.getClass()));
        for (Class<?> klass : classes) {
            try {
                Service service = (Service)klass.newInstance();
                log.debug("Loading service [{0}] implementation [{1}]", service.getInterface(), service.getClass());
                if (!service.getInterface().isInstance(service)) {
                    throw new ServiceException(ErrorCode.E0101, klass, service.getInterface().getName());
                }
                list.add(service);
            }
            catch (ServiceException ex) {
                throw ex;
            }
            catch (Exception ex) {
                throw new ServiceException(ErrorCode.E0102, klass, ex.getMessage(), ex);
            }
        }
    }

    private void loadServices() throws ServiceException {
        XLog log = new XLog(LogFactory.getLog(this.getClass()));
        try {
            LinkedHashMap<Class<? extends Service>, Service> map = new LinkedHashMap<Class<? extends Service>, Service>();
            Class<?>[] classes = ConfigurationService.getClasses(this.conf, CONF_SERVICE_CLASSES);
            log.debug("Services list obtained from property 'oozie.services'");
            Class<?>[] classesExt = ConfigurationService.getClasses(this.conf, CONF_SERVICE_EXT_CLASSES);
            log.debug("Services list obtained from property 'oozie.services.ext'");
            ArrayList<Service> list = new ArrayList<Service>();
            this.loadServices(classes, list);
            this.loadServices(classesExt, list);
            for (Service service : list) {
                if (map.containsKey(service.getInterface())) {
                    log.debug("Replacing service [{0}] implementation [{1}]", service.getInterface(), service.getClass());
                }
                map.put(service.getInterface(), service);
            }
            for (Map.Entry entry : map.entrySet()) {
                this.setService(((Service)entry.getValue()).getClass());
            }
        }
        catch (RuntimeException rex) {
            log.fatal("Runtime Exception during Services Load. Check your list of [{0}] or [{1}]", CONF_SERVICE_CLASSES, CONF_SERVICE_EXT_CLASSES, rex);
            throw new ServiceException(ErrorCode.E0103, rex.getMessage(), rex);
        }
    }

    public void destroy() {
        XLog log = new XLog(LogFactory.getLog(this.getClass()));
        log.trace("Shutting down");
        boolean deleteRuntimeDir = false;
        if (this.conf != null) {
            deleteRuntimeDir = this.conf.getBoolean(CONF_DELETE_RUNTIME_DIR, false);
        }
        if (this.services != null) {
            ArrayList<Service> list = new ArrayList<Service>(this.services.values());
            Collections.reverse(list);
            for (Service service : list) {
                try {
                    log.trace("Destroying service[{0}]", service.getInterface());
                    if (service.getInterface() == XLogService.class) {
                        log.info("Shutdown");
                    }
                    service.destroy();
                }
                catch (Throwable ex) {
                    log.error("Error destroying service[{0}], {1}", service.getInterface(), ex.getMessage(), ex);
                }
            }
        }
        if (deleteRuntimeDir) {
            try {
                IOUtils.delete(new File(this.runtimeDir));
            }
            catch (IOException ex) {
                log.error("Error deleting runtime directory [{0}], {1}", this.runtimeDir, ex.getMessage(), ex);
            }
        }
        this.services = null;
        this.conf = null;
        SERVICES = null;
    }

    public <T extends Service> T get(Class<T> serviceKlass) {
        return (T)this.services.get(serviceKlass);
    }

    public void setService(Class<? extends Service> klass) throws ServiceException {
        this.setServiceInternal(klass, true);
    }

    private void setServiceInternal(Class<? extends Service> klass, boolean logging) throws ServiceException {
        try {
            Service newService = (Service)ReflectionUtils.newInstance(klass, null);
            Service oldService = this.services.get(newService.getInterface());
            if (oldService != null) {
                oldService.destroy();
            }
            if (logging) {
                XLog log = new XLog(LogFactory.getLog(this.getClass()));
                log.trace("Initializing service[{0}] class[{1}]", newService.getInterface(), newService.getClass());
            }
            newService.init(this);
            this.services.put(newService.getInterface(), newService);
        }
        catch (ServiceException ex) {
            XLog.getLog(this.getClass()).fatal((Object)ex.getMessage(), ex);
            this.destroy();
            throw ex;
        }
    }

    public static Services get() {
        return SERVICES;
    }
}

