/*
 * Decompiled with CFR 0.152.
 */
package org.apache.oozie.service;

import com.google.common.annotations.VisibleForTesting;
import org.apache.oozie.lock.LockToken;
import org.apache.oozie.lock.MemoryLocks;
import org.apache.oozie.service.Service;
import org.apache.oozie.service.ServiceException;
import org.apache.oozie.service.Services;
import org.apache.oozie.util.Instrumentable;
import org.apache.oozie.util.Instrumentation;
import org.apache.oozie.util.XLog;

public class MemoryLocksService
implements Service,
Instrumentable {
    private static final XLog LOG = XLog.getLog(MemoryLocksService.class);
    protected static final String INSTRUMENTATION_GROUP = "locks";
    private MemoryLocks locks;

    @Override
    public void init(Services services) throws ServiceException {
        this.locks = new MemoryLocks();
    }

    @Override
    public void destroy() {
        this.locks = null;
    }

    @Override
    public Class<? extends Service> getInterface() {
        return MemoryLocksService.class;
    }

    @Override
    public void instrument(Instrumentation instr) {
        final MemoryLocks finalLocks = this.locks;
        instr.addVariable(INSTRUMENTATION_GROUP, INSTRUMENTATION_GROUP, new Instrumentation.Variable<Long>(){

            @Override
            public Long getValue() {
                return finalLocks.size();
            }
        });
    }

    public LockToken getReadLock(String resource, long wait) throws InterruptedException {
        LOG.trace("Acquiring in-memory read lock. [resource={0};wait={1}]", resource, wait);
        return this.locks.getLock(resource, Type.READ, wait);
    }

    public LockToken getWriteLock(String resource, long wait) throws InterruptedException {
        LOG.trace("Acquiring in-memory write lock. [resource={0};wait={1}]", resource, wait);
        return this.locks.getLock(resource, Type.WRITE, wait);
    }

    @VisibleForTesting
    public MemoryLocks getMemoryLocks() {
        return this.locks;
    }

    public static enum Type {
        READ,
        WRITE;

    }
}

