/*
 * Decompiled with CFR 0.152.
 */
package org.apache.oozie.executor.jpa;

import java.util.List;
import javax.persistence.EntityManager;
import javax.persistence.Query;
import org.apache.oozie.ErrorCode;
import org.apache.oozie.WorkflowActionBean;
import org.apache.oozie.executor.jpa.JPAExecutor;
import org.apache.oozie.executor.jpa.JPAExecutorException;
import org.apache.oozie.util.ParamChecker;
import org.apache.oozie.util.XLog;

public class WorkflowActionGetJPAExecutor
implements JPAExecutor<WorkflowActionBean> {
    public XLog LOG = XLog.getLog(this.getClass());
    private String wfActionId = null;
    private final boolean isNullAcceptable;

    public WorkflowActionGetJPAExecutor(String wfActionId) {
        this(wfActionId, false);
    }

    public WorkflowActionGetJPAExecutor(String wfActionId, boolean isNullAcceptable) {
        ParamChecker.notNull(wfActionId, "wfActionId");
        this.wfActionId = wfActionId;
        this.isNullAcceptable = isNullAcceptable;
    }

    @Override
    public String getName() {
        return "WorkflowActionGetJPAExecutor";
    }

    @Override
    public WorkflowActionBean execute(EntityManager em) throws JPAExecutorException {
        List waBeans;
        try {
            Query q = em.createNamedQuery("GET_ACTION");
            q.setParameter("id", (Object)this.wfActionId);
            waBeans = q.getResultList();
        }
        catch (Exception e) {
            throw new JPAExecutorException(ErrorCode.E0603, e.getMessage(), e);
        }
        WorkflowActionBean bean = null;
        if (waBeans != null && waBeans.size() > 0) {
            bean = (WorkflowActionBean)waBeans.get(0);
            return bean;
        }
        if (this.isNullAcceptable) {
            this.LOG.warn("Could not get workflow action {0}", this.wfActionId);
            return null;
        }
        throw new JPAExecutorException(ErrorCode.E0605, this.wfActionId);
    }
}

