/*
 * Decompiled with CFR 0.152.
 */
package org.apache.oozie.coord.input.dependency;

import java.io.DataInput;
import java.io.DataOutput;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.commons.lang.StringUtils;
import org.apache.oozie.CoordinatorActionBean;
import org.apache.oozie.command.CommandException;
import org.apache.oozie.coord.input.dependency.AbstractCoordInputDependency;
import org.apache.oozie.coord.input.dependency.CoordUnResolvedInputDependency;
import org.apache.oozie.dependency.ActionDependency;
import org.apache.oozie.util.WritableUtils;
import org.jdom.JDOMException;

public class CoordPullInputDependency
extends AbstractCoordInputDependency {
    private Map<String, CoordUnResolvedInputDependency> unResolvedList = new HashMap<String, CoordUnResolvedInputDependency>();

    public void addResolvedList(String dataSet, String list) {
        this.unResolvedList.get(dataSet).addResolvedList(Arrays.asList(list.split(",")));
    }

    public CoordUnResolvedInputDependency getUnResolvedDependency(String dataSet) {
        return this.unResolvedList.get(dataSet);
    }

    @Override
    public boolean isUnResolvedDependencyMet() {
        for (CoordUnResolvedInputDependency coordUnResolvedDependency : this.unResolvedList.values()) {
            if (coordUnResolvedDependency.isResolved()) continue;
            return false;
        }
        return true;
    }

    @Override
    public void addUnResolvedList(String dataSet, String dependency) {
        this.unResolvedList.put(dataSet, new CoordUnResolvedInputDependency(Arrays.asList(dependency.split("#"))));
    }

    @Override
    public String getMissingDependencies() {
        StringBuffer bf = new StringBuffer(super.getMissingDependencies());
        String unresolvedMissingDependencies = this.getUnresolvedMissingDependencies();
        if (!StringUtils.isEmpty((String)unresolvedMissingDependencies)) {
            bf.append("!!");
            bf.append(unresolvedMissingDependencies);
        }
        return bf.toString();
    }

    public String getUnresolvedMissingDependencies() {
        StringBuffer bf = new StringBuffer();
        if (this.unResolvedList != null) {
            for (CoordUnResolvedInputDependency coordUnResolvedDependency : this.unResolvedList.values()) {
                if (coordUnResolvedDependency.isResolved()) continue;
                String unresolvedList = coordUnResolvedDependency.getUnResolvedList();
                if (bf.length() > 0 && !unresolvedList.isEmpty()) {
                    bf.append("#");
                }
                bf.append(unresolvedList);
            }
        }
        return bf.toString();
    }

    @Override
    protected void generateDependencies() {
        super.generateDependencies();
    }

    private void writeObject(ObjectOutputStream os) throws IOException, ClassNotFoundException {
        os.writeObject(this.unResolvedList);
    }

    private void readObject(ObjectInputStream in) throws IOException, ClassNotFoundException {
        this.unResolvedList = (Map)in.readObject();
        this.generateDependencies();
    }

    @Override
    public boolean isDependencyMet() {
        return this.isResolvedDependencyMeet() && this.isUnResolvedDependencyMet();
    }

    public boolean isResolvedDependencyMeet() {
        return super.isDependencyMet();
    }

    @Override
    public void write(DataOutput out) throws IOException {
        super.write(out);
        WritableUtils.writeMap(out, this.unResolvedList);
    }

    @Override
    public void readFields(DataInput in) throws IOException {
        super.readFields(in);
        this.unResolvedList = WritableUtils.readMap(in, CoordUnResolvedInputDependency.class);
    }

    @Override
    public void setMissingDependencies(String join) {
    }

    @Override
    public List<String> getAvailableDependencies(String dataSet) {
        ArrayList<String> availableList = new ArrayList<String>();
        availableList.addAll(super.getAvailableDependencies(dataSet));
        if (this.getUnResolvedDependency(dataSet) != null) {
            availableList.addAll(this.getUnResolvedDependency(dataSet).getResolvedList());
        }
        return availableList;
    }

    @Override
    public boolean isDataSetResolved(String dataSet) {
        if (this.unResolvedList.containsKey(dataSet)) {
            return this.unResolvedList.get(dataSet).isResolved();
        }
        return super.isDataSetResolved(dataSet);
    }

    @Override
    public Map<String, ActionDependency> getMissingDependencies(CoordinatorActionBean coordAction) throws CommandException, IOException, JDOMException {
        HashMap<String, ActionDependency> missingDependenciesMap = new HashMap<String, ActionDependency>();
        missingDependenciesMap.putAll(super.getMissingDependencies(coordAction));
        for (String key : this.unResolvedList.keySet()) {
            if (this.unResolvedList.get(key).isResolved()) continue;
            missingDependenciesMap.put(key, new ActionDependency(this.unResolvedList.get(key).getDependencies(), new ArrayList<String>()));
        }
        return missingDependenciesMap;
    }
}

