/*
 * Decompiled with CFR 0.152.
 */
package org.apache.oozie.coord;

import java.net.URI;
import java.net.URISyntaxException;
import java.util.regex.Pattern;
import org.apache.hadoop.conf.Configuration;
import org.apache.oozie.DagELFunctions;
import org.apache.oozie.WorkflowJobBean;
import org.apache.oozie.dependency.URIHandler;
import org.apache.oozie.service.ConfigurationService;
import org.apache.oozie.service.Services;
import org.apache.oozie.service.URIHandlerService;
import org.apache.oozie.util.ELEvaluator;
import org.apache.oozie.util.HCatURI;
import org.apache.oozie.util.HCatURIParser;
import org.apache.oozie.util.XLog;

public class HCatELFunctions {
    private static final Configuration EMPTY_CONF = new Configuration(true);
    private static final String HCAT_URI_REGEX_CONFIG = ConfigurationService.get("oozie.hcat.uri.regex.pattern");
    private static final Pattern HCAT_URI_PATTERN = Pattern.compile(HCAT_URI_REGEX_CONFIG);

    public static boolean hcat_exists(String uri) throws Exception {
        URI hcatURI = new URI(uri);
        URIHandlerService uriService = Services.get().get(URIHandlerService.class);
        URIHandler handler = uriService.getURIHandler(hcatURI);
        WorkflowJobBean workflow = DagELFunctions.getWorkflow();
        String user = workflow.getUser();
        return handler.exists(hcatURI, EMPTY_CONF, user);
    }

    public static String ph1_coord_databaseIn_echo(String dataInName) {
        HCatELFunctions.isValidDataEvent(dataInName);
        return HCatELFunctions.echoUnResolved("databaseIn", "'" + dataInName + "'");
    }

    public static String ph1_coord_databaseOut_echo(String dataName) {
        HCatELFunctions.isValidDataEvent(dataName);
        return HCatELFunctions.echoUnResolved("databaseOut", "'" + dataName + "'");
    }

    public static String ph1_coord_tableIn_echo(String dataName) {
        HCatELFunctions.isValidDataEvent(dataName);
        return HCatELFunctions.echoUnResolved("tableIn", "'" + dataName + "'");
    }

    public static String ph1_coord_tableOut_echo(String dataName) {
        HCatELFunctions.isValidDataEvent(dataName);
        return HCatELFunctions.echoUnResolved("tableOut", "'" + dataName + "'");
    }

    public static String ph1_coord_dataInPartitionFilter_echo(String dataInName, String type) {
        HCatELFunctions.isValidDataEvent(dataInName);
        return HCatELFunctions.echoUnResolved("dataInPartitionFilter", "'" + dataInName + "', '" + type + "'");
    }

    public static String ph1_coord_dataInPartitionMin_echo(String dataInName, String partition) {
        HCatELFunctions.isValidDataEvent(dataInName);
        return HCatELFunctions.echoUnResolved("dataInPartitionMin", "'" + dataInName + "', '" + partition + "'");
    }

    public static String ph1_coord_dataInPartitionMax_echo(String dataInName, String partition) {
        HCatELFunctions.isValidDataEvent(dataInName);
        return HCatELFunctions.echoUnResolved("dataInPartitionMax", "'" + dataInName + "', '" + partition + "'");
    }

    public static String ph1_coord_dataOutPartitions_echo(String dataOutName) {
        HCatELFunctions.isValidDataEvent(dataOutName);
        return HCatELFunctions.echoUnResolved("dataOutPartitions", "'" + dataOutName + "'");
    }

    public static String ph1_coord_dataInPartitions_echo(String dataInName, String type) {
        HCatELFunctions.isValidDataEvent(dataInName);
        return HCatELFunctions.echoUnResolved("dataInPartitions", "'" + dataInName + "', '" + type + "'");
    }

    public static String ph1_coord_dataOutPartitionValue_echo(String dataOutName, String partition) {
        HCatELFunctions.isValidDataEvent(dataOutName);
        return HCatELFunctions.echoUnResolved("dataOutPartitionValue", "'" + dataOutName + "', '" + partition + "'");
    }

    public static String ph3_coord_databaseIn(String dataInName) {
        HCatURI hcatURI = HCatELFunctions.getURIFromResolved(dataInName, EventType.input);
        if (hcatURI != null) {
            return hcatURI.getDb();
        }
        return "";
    }

    public static String ph3_coord_databaseOut(String dataOutName) {
        HCatURI hcatURI = HCatELFunctions.getURIFromResolved(dataOutName, EventType.output);
        if (hcatURI != null) {
            return hcatURI.getDb();
        }
        return "";
    }

    public static String ph3_coord_tableIn(String dataInName) {
        HCatURI hcatURI = HCatELFunctions.getURIFromResolved(dataInName, EventType.input);
        if (hcatURI != null) {
            return hcatURI.getTable();
        }
        return "";
    }

    public static String ph3_coord_tableOut(String dataOutName) {
        HCatURI hcatURI = HCatELFunctions.getURIFromResolved(dataOutName, EventType.output);
        if (hcatURI != null) {
            return hcatURI.getTable();
        }
        return "";
    }

    public static String ph3_coord_dataInPartitionFilter(String dataInName, String type) {
        ELEvaluator eval = ELEvaluator.getCurrent();
        String uris = (String)eval.getVariable(".datain." + dataInName);
        Boolean unresolved = (Boolean)eval.getVariable(".datain." + dataInName + ".unresolved");
        if (unresolved != null && unresolved.booleanValue()) {
            return "${coord:dataInPartitionFilter('" + dataInName + "', '" + type + "')}";
        }
        return HCatELFunctions.createPartitionFilter(uris, type);
    }

    public static String ph3_coord_dataOutPartitionValue(String dataOutName, String partitionName) {
        ELEvaluator eval = ELEvaluator.getCurrent();
        String uri = (String)eval.getVariable(".dataout." + dataOutName);
        Boolean unresolved = (Boolean)eval.getVariable(".dataout." + dataOutName + ".unresolved");
        if (unresolved != null && unresolved.booleanValue()) {
            return "${coord:dataOutPartitionValue('" + dataOutName + "', '" + partitionName + "')}";
        }
        try {
            HCatURI hcatUri = new HCatURI(uri);
            return hcatUri.getPartitionValue(partitionName);
        }
        catch (URISyntaxException urie) {
            XLog.getLog(HCatELFunctions.class).warn("Exception with uriTemplate [{0}]. Reason [{1}]: ", uri, urie);
            throw new RuntimeException("HCat URI can't be parsed " + urie);
        }
    }

    public static String ph3_coord_dataOutPartitions(String dataOutName) {
        ELEvaluator eval = ELEvaluator.getCurrent();
        String uri = (String)eval.getVariable(".dataout." + dataOutName);
        Boolean unresolved = (Boolean)eval.getVariable(".dataout." + dataOutName + ".unresolved");
        if (unresolved != null && unresolved.booleanValue()) {
            return "${coord:dataOutPartitions('" + dataOutName + "')}";
        }
        try {
            return new HCatURI(uri).toPartitionString();
        }
        catch (URISyntaxException e) {
            throw new RuntimeException("Parsing exception for HCatURI " + uri + ". details: " + e);
        }
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static String ph3_coord_dataInPartitions(String dataInName, String type) {
        ELEvaluator eval = ELEvaluator.getCurrent();
        String uri = (String)eval.getVariable(".datain." + dataInName);
        Boolean unresolved = (Boolean)eval.getVariable(".datain." + dataInName + ".unresolved");
        if (unresolved != null && unresolved.booleanValue()) {
            return "${coord:dataInPartitions('" + dataInName + "', '" + type + "')}";
        }
        String partitionValue = null;
        if (uri != null) {
            if (!type.equals("hive-export")) throw new RuntimeException("Unsupported type: " + type + " dataset name: " + dataInName);
            String[] uriList = HCatURIParser.splitHCatUris((String)uri, (Pattern)HCAT_URI_PATTERN);
            if (uriList.length > 1) {
                throw new RuntimeException("Multiple partitions not supported for hive-export type. Dataset name: " + dataInName + " URI: " + uri);
            }
            try {
                return new HCatURI(uri).toPartitionValueString(type);
            }
            catch (URISyntaxException e) {
                throw new RuntimeException("Parsing exception for HCatURI " + uri, e);
            }
        }
        XLog.getLog(HCatELFunctions.class).warn("URI is null");
        return null;
    }

    public static String ph3_coord_dataInPartitionMin(String dataInName, String partitionName) {
        ELEvaluator eval = ELEvaluator.getCurrent();
        String uris = (String)eval.getVariable(".datain." + dataInName);
        Boolean unresolved = (Boolean)eval.getVariable(".datain." + dataInName + ".unresolved");
        if (unresolved != null && unresolved.booleanValue()) {
            return "${coord:dataInPartitionMin('" + dataInName + "', '" + partitionName + "')}";
        }
        String minPartition = null;
        if (uris != null) {
            String[] uriList = HCatURIParser.splitHCatUris((String)uris, (Pattern)HCAT_URI_PATTERN);
            try {
                minPartition = new HCatURI(uriList[0]).getPartitionValue(partitionName);
                if (minPartition == null || minPartition.isEmpty()) {
                    throw new RuntimeException("No value in data-in uri for partition key: " + partitionName);
                }
                for (int i = 1; i < uriList.length; ++i) {
                    String value = new HCatURI(uriList[i]).getPartitionValue(partitionName);
                    if (value.compareTo(minPartition) >= 0) continue;
                    minPartition = value;
                }
            }
            catch (URISyntaxException urie) {
                throw new RuntimeException("HCat URI can't be parsed " + urie);
            }
        } else {
            XLog.getLog(HCatELFunctions.class).warn("URI is null");
            return null;
        }
        return minPartition;
    }

    public static String ph3_coord_dataInPartitionMax(String dataInName, String partitionName) {
        ELEvaluator eval = ELEvaluator.getCurrent();
        String uris = (String)eval.getVariable(".datain." + dataInName);
        Boolean unresolved = (Boolean)eval.getVariable(".datain." + dataInName + ".unresolved");
        if (unresolved != null && unresolved.booleanValue()) {
            return "${coord:dataInPartitionMin('" + dataInName + "', '" + partitionName + "')}";
        }
        String maxPartition = null;
        if (uris != null) {
            String[] uriList = HCatURIParser.splitHCatUris((String)uris, (Pattern)HCAT_URI_PATTERN);
            try {
                maxPartition = new HCatURI(uriList[0]).getPartitionValue(partitionName);
                if (maxPartition == null || maxPartition.isEmpty()) {
                    throw new RuntimeException("No value in data-in uri for partition key: " + partitionName);
                }
                for (int i = 1; i < uriList.length; ++i) {
                    String value = new HCatURI(uriList[i]).getPartitionValue(partitionName);
                    if (value.compareTo(maxPartition) <= 0) continue;
                    maxPartition = value;
                }
            }
            catch (URISyntaxException urie) {
                throw new RuntimeException("HCat URI can't be parsed " + urie);
            }
        } else {
            XLog.getLog(HCatELFunctions.class).warn("URI is null");
            return null;
        }
        return maxPartition;
    }

    private static String createPartitionFilter(String uris, String type) {
        String[] uriList = HCatURIParser.splitHCatUris((String)uris, (Pattern)HCAT_URI_PATTERN);
        StringBuilder filter = new StringBuilder("");
        if (uriList.length > 0) {
            for (String uri : uriList) {
                if (filter.length() > 0) {
                    filter.append(" OR ");
                }
                try {
                    filter.append(new HCatURI(uri).toPartitionFilter(type));
                }
                catch (URISyntaxException e) {
                    throw new RuntimeException("Parsing exception for HCatURI " + uri + ". details: " + e);
                }
            }
        }
        return filter.toString();
    }

    private static HCatURI getURIFromResolved(String dataInName, EventType type) {
        HCatURI hcatURI;
        XLog LOG = XLog.getLog(HCatELFunctions.class);
        StringBuilder uriTemplate = new StringBuilder();
        ELEvaluator eval = ELEvaluator.getCurrent();
        String uris = type == EventType.input ? (String)eval.getVariable(".datain." + dataInName) : (String)eval.getVariable(".dataout." + dataInName);
        if (uris == null) {
            LOG.warn("URI is NULL");
            return null;
        }
        String[] uri = HCatURIParser.splitHCatUris((String)uris, (Pattern)HCAT_URI_PATTERN);
        uriTemplate.append(uri[0]);
        LOG.info("uriTemplate [{0}] ", uriTemplate);
        try {
            hcatURI = new HCatURI(uriTemplate.toString());
        }
        catch (URISyntaxException e) {
            LOG.info("uriTemplate [{0}]. Reason [{1}]: ", uriTemplate, e);
            throw new RuntimeException("HCat URI can't be parsed " + e);
        }
        return hcatURI;
    }

    private static boolean isValidDataEvent(String dataInName) {
        ELEvaluator eval = ELEvaluator.getCurrent();
        String val = (String)eval.getVariable("oozie.dataname." + dataInName);
        if (val == null || !val.equals("data-in") && !val.equals("data-out")) {
            XLog.getLog(HCatELFunctions.class).error("dataset name " + dataInName + " is not valid. val :" + val);
            throw new RuntimeException("data set name " + dataInName + " is not valid");
        }
        return true;
    }

    private static String echoUnResolved(String functionName, String n) {
        return HCatELFunctions.echoUnResolvedPre(functionName, n, "coord:");
    }

    private static String echoUnResolvedPre(String functionName, String n, String prefix) {
        ELEvaluator eval = ELEvaluator.getCurrent();
        eval.setVariable(".wrap", "true");
        return prefix + functionName + "(" + n + ")";
    }

    static enum EventType {
        input,
        output;

    }
}

