/*
 * Decompiled with CFR 0.152.
 */
package org.apache.oozie.command.wf;

import org.apache.oozie.ErrorCode;
import org.apache.oozie.WorkflowJobBean;
import org.apache.oozie.XException;
import org.apache.oozie.command.CommandException;
import org.apache.oozie.command.PreconditionException;
import org.apache.oozie.command.wf.WorkflowXCommand;
import org.apache.oozie.executor.jpa.WorkflowJobQueryExecutor;
import org.apache.oozie.service.JPAService;
import org.apache.oozie.service.Services;
import org.apache.oozie.util.LogUtils;
import org.apache.oozie.util.ParamChecker;

public class DefinitionXCommand
extends WorkflowXCommand<String> {
    private String jobId;
    private WorkflowJobBean wfJob;

    public DefinitionXCommand(String jobId) {
        super("definition", "definition", 1);
        this.jobId = ParamChecker.notEmpty(jobId, "jobId");
    }

    @Override
    protected void setLogInfo() {
        LogUtils.setLogInfo(this.jobId);
    }

    @Override
    protected boolean isLockRequired() {
        return false;
    }

    @Override
    public String getEntityKey() {
        return this.jobId;
    }

    @Override
    protected void loadState() throws CommandException {
        try {
            JPAService jpaService = Services.get().get(JPAService.class);
            if (jpaService != null) {
                this.wfJob = WorkflowJobQueryExecutor.getInstance().get(WorkflowJobQueryExecutor.WorkflowJobQuery.GET_WORKFLOW_DEFINITION, this.jobId);
                LogUtils.setLogInfo(this.wfJob);
            } else {
                this.LOG.error((Object)ErrorCode.E0610);
            }
        }
        catch (XException ex) {
            throw new CommandException(ex);
        }
    }

    @Override
    protected void verifyPrecondition() throws CommandException, PreconditionException {
    }

    @Override
    protected String execute() throws CommandException {
        if (this.wfJob != null) {
            return this.wfJob.getWorkflowInstance().getApp().getDefinition();
        }
        throw new CommandException(ErrorCode.E0604, "null");
    }
}

