/*
 * Decompiled with CFR 0.152.
 */
package org.apache.oozie.command.coord;

import java.util.Calendar;
import java.util.Date;
import java.util.TimeZone;

class DaylightOffsetCalculator {
    private final Date startMatdTime;
    private final Date endMatdTime;

    DaylightOffsetCalculator(Date startMatdTime, Date endMatdTime) {
        this.startMatdTime = startMatdTime;
        this.endMatdTime = endMatdTime;
    }

    Calendar calculate(TimeZone tz, Calendar target) {
        Calendar targetWithDSTOffset = Calendar.getInstance();
        targetWithDSTOffset.setTimeInMillis(target.getTime().getTime() + DaylightOffsetCalculator.getDSTOffset(tz, this.startMatdTime, this.endMatdTime));
        return targetWithDSTOffset;
    }

    static long getDSTOffset(TimeZone tz, Date beginDate, Date endDate) {
        if (tz.inDaylightTime(beginDate) && !tz.inDaylightTime(endDate)) {
            Calendar cal = Calendar.getInstance(tz);
            cal.setTime(beginDate);
            return cal.get(16);
        }
        if (!tz.inDaylightTime(beginDate) && tz.inDaylightTime(endDate)) {
            Calendar cal = Calendar.getInstance(tz);
            cal.setTime(endDate);
            return -cal.get(16);
        }
        return 0L;
    }
}

