/*
 * Decompiled with CFR 0.152.
 */
package org.apache.oozie.command.coord;

import java.util.ArrayList;
import java.util.List;
import org.apache.oozie.CoordinatorActionBean;
import org.apache.oozie.CoordinatorWfActionBean;
import org.apache.oozie.ErrorCode;
import org.apache.oozie.client.CoordinatorWfAction;
import org.apache.oozie.command.CommandException;
import org.apache.oozie.command.PreconditionException;
import org.apache.oozie.command.coord.CoordinatorXCommand;
import org.apache.oozie.executor.jpa.CoordJobGetActionsSubsetJPAExecutor;
import org.apache.oozie.executor.jpa.JPAExecutorException;
import org.apache.oozie.executor.jpa.WorkflowActionGetJPAExecutor;
import org.apache.oozie.service.JPAService;
import org.apache.oozie.service.Services;
import org.apache.oozie.util.ParamChecker;

public class CoordWfActionInfoXCommand
extends CoordinatorXCommand<List<CoordinatorWfActionBean>> {
    private static final String ACTION_INFO = "action.info";
    private static final int DEFAULT_OFFSET = 1;
    private static final int DEFAULT_LEN = 50;
    private final String jobId;
    private final String actionName;
    private final int offset;
    private final int len;
    private List<CoordinatorActionBean> coordActions;
    private JPAService jpaService = null;

    public CoordWfActionInfoXCommand(String jobId, String actionName) {
        this(jobId, actionName, 1, 50);
    }

    public CoordWfActionInfoXCommand(String jobId, String actionName, int offset, int len) {
        super(ACTION_INFO, ACTION_INFO, 1);
        this.jobId = ParamChecker.notEmpty(jobId, "jobId");
        this.actionName = ParamChecker.notEmpty(actionName, "actionName");
        this.offset = offset;
        this.len = len;
    }

    /*
     * Unable to fully structure code
     */
    @Override
    protected List<CoordinatorWfActionBean> execute() throws CommandException {
        coordWfActions = new ArrayList<CoordinatorWfActionBean>();
        for (CoordinatorActionBean coordAction : this.coordActions) {
            wfId = coordAction.getExternalId();
            nullReason = null;
            wfAction = null;
            if (wfId != null) {
                wfActionId = wfId + "@" + this.actionName;
                try {
                    wfAction = this.jpaService.execute(new WorkflowActionGetJPAExecutor(wfActionId, true));
                    if (wfAction != null) ** GOTO lbl18
                    nullReason = CoordinatorWfAction.NullReason.ACTION_NULL.getNullReason(new Object[]{this.actionName, wfId});
                }
                catch (JPAExecutorException ex) {
                    throw new CommandException(ex);
                }
            } else {
                nullReason = CoordinatorWfAction.NullReason.PARENT_NULL.getNullReason(new Object[0]);
                this.LOG.warn(nullReason);
                wfAction = null;
            }
lbl18:
            // 3 sources

            actionNumber = coordAction.getActionNumber();
            coordWfAction = new CoordinatorWfActionBean(actionNumber, wfAction, nullReason);
            coordWfActions.add(coordWfAction);
        }
        return coordWfActions;
    }

    @Override
    protected void loadState() throws CommandException {
        this.jpaService = Services.get().get(JPAService.class);
        if (this.jpaService != null) {
            try {
                this.coordActions = this.jpaService.execute(new CoordJobGetActionsSubsetJPAExecutor(this.jobId, null, this.offset, this.len, false));
            }
            catch (JPAExecutorException ex) {
                this.LOG.error((Object)ErrorCode.E0612);
                throw new CommandException(ex);
            }
        } else {
            throw new CommandException(ErrorCode.E0610, new Object[0]);
        }
    }

    @Override
    protected void verifyPrecondition() throws CommandException, PreconditionException {
    }

    @Override
    protected boolean isLockRequired() {
        return false;
    }

    @Override
    public String getEntityKey() {
        return null;
    }
}

