/*
 * Decompiled with CFR 0.152.
 */
package org.apache.oozie.command.coord;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import org.apache.oozie.CoordinatorActionBean;
import org.apache.oozie.ErrorCode;
import org.apache.oozie.command.CommandException;
import org.apache.oozie.command.PreconditionException;
import org.apache.oozie.command.XCommand;
import org.apache.oozie.coord.CoordUtils;
import org.apache.oozie.coord.input.dependency.CoordInputDependency;
import org.apache.oozie.dependency.ActionDependency;
import org.apache.oozie.executor.jpa.CoordActionQueryExecutor;
import org.apache.oozie.executor.jpa.JPAExecutorException;
import org.apache.oozie.util.Pair;

public class CoordActionMissingDependenciesXCommand
extends XCommand<List<Pair<CoordinatorActionBean, Map<String, ActionDependency>>>> {
    private String actions;
    private String dates;
    private String jobId;
    private List<CoordinatorActionBean> coordActions = new ArrayList<CoordinatorActionBean>();

    public CoordActionMissingDependenciesXCommand(String id, String actions, String dates) {
        super("CoordActionMissingDependenciesXCommand", "CoordActionMissingDependenciesXCommand", 1);
        this.jobId = id;
        this.actions = actions;
        this.dates = dates;
        if (id.contains("@")) {
            this.jobId = id.substring(0, id.indexOf("@"));
            this.actions = id.substring(id.indexOf("@") + 1);
        }
    }

    public CoordActionMissingDependenciesXCommand(String id) {
        this(id, null, null);
    }

    @Override
    protected boolean isLockRequired() {
        return false;
    }

    @Override
    public String getEntityKey() {
        return null;
    }

    @Override
    protected void eagerVerifyPrecondition() throws CommandException, PreconditionException {
        if (this.actions == null && this.dates == null) {
            throw new CommandException(ErrorCode.E1029, "Action(s) are missing.");
        }
    }

    @Override
    protected void loadState() throws CommandException {
        String actionId = null;
        try {
            List<String> actionIds = CoordUtils.getActionListForScopeAndDate(this.jobId, this.actions, this.dates);
            Iterator<String> iterator = actionIds.iterator();
            while (iterator.hasNext()) {
                String id;
                actionId = id = iterator.next();
                this.coordActions.add(CoordActionQueryExecutor.getInstance().get(CoordActionQueryExecutor.CoordActionQuery.GET_COORD_ACTION_FOR_INPUTCHECK, actionId));
            }
        }
        catch (JPAExecutorException e) {
            if (e.getErrorCode().equals((Object)ErrorCode.E0605)) {
                throw new CommandException(ErrorCode.E0605, actionId);
            }
            throw new CommandException(ErrorCode.E1029, e);
        }
    }

    @Override
    protected void verifyPrecondition() throws CommandException, PreconditionException {
    }

    @Override
    protected List<Pair<CoordinatorActionBean, Map<String, ActionDependency>>> execute() throws CommandException {
        ArrayList<Pair<CoordinatorActionBean, Map<String, ActionDependency>>> inputDependenciesListPair = new ArrayList<Pair<CoordinatorActionBean, Map<String, ActionDependency>>>();
        try {
            for (CoordinatorActionBean coordAction : this.coordActions) {
                CoordInputDependency coordPullInputDependency = coordAction.getPullInputDependencies();
                CoordInputDependency coordPushInputDependency = coordAction.getPushInputDependencies();
                HashMap<String, ActionDependency> dependencyMap = new HashMap<String, ActionDependency>();
                dependencyMap.putAll(coordPullInputDependency.getMissingDependencies(coordAction));
                dependencyMap.putAll(coordPushInputDependency.getMissingDependencies(coordAction));
                inputDependenciesListPair.add(new Pair(coordAction, dependencyMap));
            }
        }
        catch (Exception e) {
            throw new CommandException(ErrorCode.E1028, e.getMessage(), e);
        }
        return inputDependenciesListPair;
    }
}

