/*
 * Decompiled with CFR 0.152.
 */
package org.apache.oozie.client.rest;

import com.google.common.collect.ImmutableSet;
import java.util.List;
import java.util.Set;
import org.apache.oozie.BundleJobBean;
import org.apache.oozie.CoordinatorActionBean;
import org.apache.oozie.CoordinatorJobBean;
import org.apache.oozie.client.BulkResponse;
import org.apache.oozie.client.rest.JsonBean;
import org.json.simple.JSONArray;
import org.json.simple.JSONObject;

public class BulkResponseImpl
implements BulkResponse,
JsonBean {
    private BundleJobBean bundle;
    private CoordinatorJobBean coordinator;
    private CoordinatorActionBean action;
    public static final String BULK_FILTER_BUNDLE = "bundle";
    public static final String BULK_FILTER_COORD = "coordinators";
    public static final String BULK_FILTER_LEVEL = "filterlevel";
    public static final String BULK_FILTER_STATUS = "actionstatus";
    public static final String BULK_FILTER_START_CREATED_EPOCH = "startcreatedtime";
    public static final String BULK_FILTER_END_CREATED_EPOCH = "endcreatedtime";
    public static final String BULK_FILTER_START_NOMINAL_EPOCH = "startscheduledtime";
    public static final String BULK_FILTER_END_NOMINAL_EPOCH = "endscheduledtime";
    public static final String BULK_DATE_FORMAT = "yyyy-MM-dd'T'HH:mm:SS'Z'";
    public static final Set<String> BULK_FILTER_NAMES = ImmutableSet.of((Object)"bundle", (Object)"coordinators", (Object)"filterlevel", (Object)"actionstatus", (Object)"startcreatedtime", (Object)"endcreatedtime", (Object[])new String[]{"startscheduledtime", "endscheduledtime"});

    @Override
    public JSONObject toJSONObject() {
        return this.toJSONObject("GMT");
    }

    @Override
    public JSONObject toJSONObject(String timeZoneId) {
        JSONObject json = new JSONObject();
        json.put((Object)"bulkbundle", (Object)this.bundle.toJSONObject());
        json.put((Object)"bulkcoord", (Object)this.coordinator.toJSONObject());
        json.put((Object)"bulkaction", (Object)this.action.toJSONObject());
        return json;
    }

    public BundleJobBean getBundle() {
        return this.bundle;
    }

    public CoordinatorJobBean getCoordinator() {
        return this.coordinator;
    }

    public CoordinatorActionBean getAction() {
        return this.action;
    }

    public void setBundle(BundleJobBean bj) {
        this.bundle = bj;
    }

    public void setCoordinator(CoordinatorJobBean cj) {
        this.coordinator = cj;
    }

    public void setAction(CoordinatorActionBean ca) {
        this.action = ca;
    }

    public static JSONArray toJSONArray(List<? extends BulkResponseImpl> responses, String timeZoneId) {
        JSONArray array = new JSONArray();
        for (BulkResponseImpl bulkResponseImpl : responses) {
            array.add((Object)bulkResponseImpl.toJSONObject(timeZoneId));
        }
        return array;
    }
}

