/*
 * Decompiled with CFR 0.152.
 */
package org.apache.oozie.action.hadoop;

import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.io.Text;
import org.apache.hadoop.security.Credentials;
import org.apache.hadoop.security.token.Token;
import org.apache.hadoop.yarn.client.ClientRMProxy;
import org.apache.hadoop.yarn.client.api.YarnClient;
import org.apache.hadoop.yarn.util.ConverterUtils;
import org.apache.oozie.ErrorCode;
import org.apache.oozie.action.ActionExecutor;
import org.apache.oozie.action.hadoop.CredentialException;
import org.apache.oozie.action.hadoop.CredentialsProperties;
import org.apache.oozie.action.hadoop.CredentialsProvider;
import org.apache.oozie.action.hadoop.HadoopTokenHelper;
import org.apache.oozie.service.HadoopAccessorService;
import org.apache.oozie.service.Services;
import org.apache.oozie.util.XLog;

public class YarnRMCredentials
implements CredentialsProvider {
    @Override
    public void updateCredentials(Credentials credentials, Configuration config, CredentialsProperties props, ActionExecutor.Context context) throws Exception {
        Text rmDelegationTokenService = ClientRMProxy.getRMDelegationTokenService((Configuration)config);
        if (rmDelegationTokenService == null) {
            throw new CredentialException(ErrorCode.E0512, "Can't create RMDelegationTokenService");
        }
        try (YarnClient yarnClient = Services.get().get(HadoopAccessorService.class).createYarnClient(context.getWorkflow().getUser(), config);){
            org.apache.hadoop.yarn.api.records.Token rmDelegationToken = yarnClient.getRMDelegationToken(new Text(new HadoopTokenHelper().getServerPrincipal(config)));
            if (rmDelegationToken == null) {
                throw new CredentialException(ErrorCode.E0512, "Returned token is null");
            }
            Token rmToken = ConverterUtils.convertFromYarn((org.apache.hadoop.yarn.api.records.Token)rmDelegationToken, (Text)rmDelegationTokenService);
            credentials.addToken(rmDelegationTokenService, rmToken);
        }
        catch (Exception e) {
            XLog.getLog(this.getClass()).debug((Object)"Exception in updateCredentials", e);
            throw e;
        }
    }
}

