/*
 * Decompiled with CFR 0.152.
 */
package org.apache.oozie.action.hadoop;

import java.util.HashMap;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.yarn.api.records.ApplicationAccessType;
import org.apache.hadoop.yarn.api.records.ContainerLaunchContext;
import org.apache.oozie.util.XLog;

class YarnACLHandler {
    private XLog LOG = XLog.getLog(this.getClass());
    private final Configuration launcherConf;

    public YarnACLHandler(Configuration launcherConf) {
        this.launcherConf = launcherConf;
    }

    public void setACLs(ContainerLaunchContext containerLaunchContext) {
        boolean mrAclsEnabled = this.launcherConf.getBoolean("mapreduce.cluster.acls.enabled", true);
        if (mrAclsEnabled) {
            String modifyAcl;
            HashMap<ApplicationAccessType, String> aclDefinition = new HashMap<ApplicationAccessType, String>();
            String viewAcl = this.launcherConf.get("oozie.launcher.view.acl");
            if (viewAcl != null) {
                aclDefinition.put(ApplicationAccessType.VIEW_APP, viewAcl);
            }
            if ((modifyAcl = this.launcherConf.get("oozie.launcher.modify.acl")) != null) {
                aclDefinition.put(ApplicationAccessType.MODIFY_APP, modifyAcl);
            }
            if (!aclDefinition.isEmpty()) {
                containerLaunchContext.setApplicationACLs(aclDefinition);
            }
        } else {
            this.LOG.info("Not setting ACLs because {0} is set to false", "mapreduce.cluster.acls.enabled");
        }
    }
}

