/*
 * Decompiled with CFR 0.152.
 */
package org.apache.oozie.action.hadoop;

import java.io.IOException;
import java.net.InetSocketAddress;
import java.security.PrivilegedAction;
import org.apache.commons.lang.StringUtils;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.io.Text;
import org.apache.hadoop.mapreduce.v2.api.HSClientProtocol;
import org.apache.hadoop.mapreduce.v2.api.MRClientProtocol;
import org.apache.hadoop.mapreduce.v2.api.protocolrecords.GetDelegationTokenRequest;
import org.apache.hadoop.net.NetUtils;
import org.apache.hadoop.security.Credentials;
import org.apache.hadoop.security.SecurityUtil;
import org.apache.hadoop.security.UserGroupInformation;
import org.apache.hadoop.security.token.Token;
import org.apache.hadoop.yarn.factory.providers.RecordFactoryProvider;
import org.apache.hadoop.yarn.ipc.YarnRPC;
import org.apache.hadoop.yarn.util.ConverterUtils;
import org.apache.oozie.ErrorCode;
import org.apache.oozie.action.ActionExecutor;
import org.apache.oozie.action.hadoop.CredentialException;
import org.apache.oozie.action.hadoop.CredentialsProperties;
import org.apache.oozie.action.hadoop.CredentialsProvider;
import org.apache.oozie.action.hadoop.HadoopTokenHelper;
import org.apache.oozie.service.Services;
import org.apache.oozie.service.UserGroupInformationService;
import org.apache.oozie.util.XLog;

public class JHSCredentials
implements CredentialsProvider {
    protected XLog LOG = XLog.getLog(this.getClass());

    @Override
    public void updateCredentials(Credentials credentials, Configuration config, CredentialsProperties props, ActionExecutor.Context context) throws Exception {
        try {
            this.LOG.debug("Instantiating JHS Proxy");
            MRClientProtocol hsProxy = this.instantiateHistoryProxy(config, context);
            Text hsService = SecurityUtil.buildTokenService((InetSocketAddress)hsProxy.getConnectAddress());
            this.LOG.debug("Getting delegation token for {0}", hsService.toString());
            Token<?> jhsToken = this.getDelegationTokenFromJHS(hsProxy, new HadoopTokenHelper().getServerPrincipal(config));
            this.LOG.debug("Acquired token {0}", jhsToken);
            credentials.addToken(hsService, jhsToken);
        }
        catch (IOException | InterruptedException ex) {
            this.LOG.debug((Object)"exception in updateCredentials", ex);
            throw new CredentialException(ErrorCode.E0512, ex.getMessage(), ex);
        }
    }

    private Token<?> getDelegationTokenFromJHS(MRClientProtocol hsProxy, String renewer) throws IOException, InterruptedException {
        GetDelegationTokenRequest request = (GetDelegationTokenRequest)RecordFactoryProvider.getRecordFactory(null).newRecordInstance(GetDelegationTokenRequest.class);
        this.LOG.debug("Creating requsest to JHS using renewer [{0}]", renewer);
        request.setRenewer(renewer);
        org.apache.hadoop.yarn.api.records.Token mrDelegationToken = hsProxy.getDelegationToken(request).getDelegationToken();
        this.LOG.debug("Got token to JHS : {0}. Converting token.", mrDelegationToken);
        return ConverterUtils.convertFromYarn((org.apache.hadoop.yarn.api.records.Token)mrDelegationToken, (InetSocketAddress)hsProxy.getConnectAddress());
    }

    private MRClientProtocol instantiateHistoryProxy(final Configuration configuration, ActionExecutor.Context context) throws IOException {
        final String serviceAddr = configuration.get("mapreduce.jobhistory.address");
        if (StringUtils.isEmpty((String)serviceAddr)) {
            return null;
        }
        this.LOG.debug("Connecting to JHS at: " + serviceAddr);
        final YarnRPC rpc = YarnRPC.create((Configuration)configuration);
        this.LOG.debug("Connected to JHS at: " + serviceAddr);
        UserGroupInformation currentUser = Services.get().get(UserGroupInformationService.class).getProxyUser(context.getWorkflow().getUser());
        return (MRClientProtocol)currentUser.doAs((PrivilegedAction)new PrivilegedAction<MRClientProtocol>(){

            @Override
            public MRClientProtocol run() {
                return (MRClientProtocol)rpc.getProxy(HSClientProtocol.class, NetUtils.createSocketAddr((String)serviceAddr), configuration);
            }
        });
    }
}

