/*
 * Decompiled with CFR 0.152.
 */
package org.apache.oozie.action.hadoop;

import com.google.common.base.Preconditions;
import com.google.common.base.Strings;
import java.io.IOException;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.net.NetUtils;
import org.apache.hadoop.security.SecurityUtil;
import org.apache.oozie.util.XLog;

public class HadoopTokenHelper {
    protected static final String RM_PRINCIPAL = "yarn.resourcemanager.principal";
    protected static final String HADOOP_YARN_RM = "yarn.resourcemanager.address";
    private XLog LOG = XLog.getLog(this.getClass());

    private String getServicePrincipal(Configuration configuration) {
        return configuration.get(RM_PRINCIPAL);
    }

    String getServerPrincipal(Configuration configuration) throws IOException {
        return this.getServerPrincipal(configuration, this.getServicePrincipal(configuration));
    }

    private String getServerPrincipal(Configuration configuration, String servicePrincipal) throws IOException {
        String serverPrincipal;
        Preconditions.checkNotNull((Object)configuration, (Object)"configuration has to be filled");
        Preconditions.checkArgument((!Strings.isNullOrEmpty((String)servicePrincipal) ? 1 : 0) != 0, (Object)"servicePrincipal has to be filled");
        Preconditions.checkArgument((!Strings.isNullOrEmpty((String)configuration.get(HADOOP_YARN_RM)) ? 1 : 0) != 0, (Object)String.format("configuration entry %s has to be filled", HADOOP_YARN_RM));
        String target = configuration.get(HADOOP_YARN_RM);
        try {
            String addr = NetUtils.createSocketAddr((String)target).getHostName();
            serverPrincipal = SecurityUtil.getServerPrincipal((String)servicePrincipal, (String)addr);
            this.LOG.info("Delegation Token Renewer details: Principal={0},Target={1}", serverPrincipal, target);
        }
        catch (IllegalArgumentException iae) {
            this.LOG.warn((Object)"An error happened while trying to get server principal. Getting it from service principal anyway.", iae);
            serverPrincipal = servicePrincipal.split("[/@]")[0];
            this.LOG.info("Delegation Token Renewer for {0} is {1}", target, serverPrincipal);
        }
        return serverPrincipal;
    }
}

