/*
 * Decompiled with CFR 0.152.
 */
package org.apache.oozie.action.hadoop;

import java.util.HashMap;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.security.Credentials;
import org.apache.oozie.ErrorCode;
import org.apache.oozie.action.ActionExecutor;
import org.apache.oozie.action.hadoop.CredentialException;
import org.apache.oozie.action.hadoop.CredentialsProperties;
import org.apache.oozie.action.hadoop.CredentialsProvider;
import org.apache.oozie.action.hadoop.HCatCredentialHelper;
import org.apache.oozie.service.HCatAccessorService;
import org.apache.oozie.service.Services;
import org.apache.oozie.util.XLog;

public class HCatCredentials
implements CredentialsProvider {
    private static final String HCAT_METASTORE_PRINCIPAL = "hcat.metastore.principal";
    private static final String HCAT_METASTORE_URI = "hcat.metastore.uri";
    private static final String HIVE_METASTORE_PRINCIPAL = "hive.metastore.kerberos.principal";
    private static final String HIVE_METASTORE_URI = "hive.metastore.uris";
    private static final Configuration hiveConf = new Configuration(false);

    @Override
    public void updateCredentials(Credentials credentials, Configuration config, CredentialsProperties props, ActionExecutor.Context context) throws Exception {
        try {
            String principal = this.getProperty(props.getProperties(), HCAT_METASTORE_PRINCIPAL, HIVE_METASTORE_PRINCIPAL);
            if (principal == null || principal.isEmpty()) {
                throw new CredentialException(ErrorCode.E0510, "hcat.metastore.principal is required to get hcat credential");
            }
            String server = this.getProperty(props.getProperties(), HCAT_METASTORE_URI, HIVE_METASTORE_URI);
            if (server == null || server.isEmpty()) {
                throw new CredentialException(ErrorCode.E0510, "hcat.metastore.uri is required to get hcat credential");
            }
            HCatCredentialHelper hcch = new HCatCredentialHelper();
            hcch.set(credentials, config, principal, server);
        }
        catch (Exception e) {
            XLog.getLog(this.getClass()).warn((Object)"Exception in updateCredentials", e);
            throw e;
        }
    }

    private String getProperty(HashMap<String, String> prop, String oozieConfName, String hiveConfName) {
        HCatAccessorService hCatService;
        Configuration hCatConf;
        String value;
        String string = value = prop.get(oozieConfName) == null ? prop.get(hiveConfName) : prop.get(oozieConfName);
        if ((value == null || value.isEmpty()) && (hCatConf = (hCatService = Services.get().get(HCatAccessorService.class)).getHCatConf()) != null) {
            value = hCatConf.get(hiveConfName);
        }
        if (value == null || value.isEmpty()) {
            value = hiveConf.get(hiveConfName);
        }
        return value;
    }

    static {
        hiveConf.addResource("hive-site.xml");
    }
}

