/*
 * Decompiled with CFR 0.152.
 */
package org.apache.oozie.action.hadoop;

import java.util.ArrayList;
import java.util.List;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.Path;
import org.apache.oozie.action.ActionExecutor;
import org.apache.oozie.action.ActionExecutorException;
import org.apache.oozie.action.hadoop.JavaActionExecutor;
import org.apache.oozie.service.ConfigurationService;
import org.apache.oozie.util.StringUtils;
import org.apache.oozie.util.XLog;
import org.jdom.Element;

public class DistcpActionExecutor
extends JavaActionExecutor {
    public static final String CONF_OOZIE_DISTCP_ACTION_MAIN_CLASS = "org.apache.oozie.action.hadoop.DistcpMain";
    private static final String DISTCP_MAIN_CLASS_NAME = "org.apache.hadoop.tools.DistCp";
    public static final String CLASS_NAMES = "oozie.actions.main.classnames";
    private static final XLog LOG = XLog.getLog(DistcpActionExecutor.class);
    public static final String DISTCP_TYPE = "distcp";
    private static final String OOZIE_LAUNCHER_MAPREDUCE_JOB_HDFS_SERVERS = "oozie.launcher.mapreduce.job.hdfs-servers";
    private static final String OOZIE_LAUNCHER_MAPREDUCE_JOB_HDFS_SERVERS_TOKEN_RENEWAL_EXCLUDE = "oozie.launcher.mapreduce.job.hdfs-servers.token-renewal.exclude";
    private static final String JOB_NAMENODES_TOKEN_RENEWAL_EXCLUDE = "mapreduce.job.hdfs-servers.token-renewal.exclude";

    public DistcpActionExecutor() {
        super(DISTCP_TYPE);
    }

    @Override
    Configuration setupActionConf(Configuration actionConf, ActionExecutor.Context context, Element actionXml, Path appPath) throws ActionExecutorException {
        actionConf = super.setupActionConf(actionConf, context, actionXml, appPath);
        actionConf.set("oozie.action.java.main", DISTCP_MAIN_CLASS_NAME);
        return actionConf;
    }

    @Override
    public List<Class<?>> getLauncherClasses() {
        ArrayList classes = new ArrayList();
        try {
            classes.add(Class.forName(CONF_OOZIE_DISTCP_ACTION_MAIN_CLASS));
        }
        catch (ClassNotFoundException e) {
            throw new RuntimeException("Class not found", e);
        }
        return classes;
    }

    public static String getClassNamebyType(String type) {
        String classname = null;
        for (String function : ConfigurationService.getStrings(CLASS_NAMES)) {
            function = StringUtils.trim(function);
            LOG.debug("class for Distcp Action: " + function);
            String[] str = function.split("=");
            if (str.length <= 0 || !type.equalsIgnoreCase(str[0])) continue;
            classname = new String(str[1]);
        }
        return classname;
    }

    @Override
    protected String getDefaultShareLibName(Element actionXml) {
        return DISTCP_TYPE;
    }

    @Override
    protected String getLauncherMain(Configuration launcherConf, Element actionXml) {
        return launcherConf.get("oozie.launcher.action.main.class", CONF_OOZIE_DISTCP_ACTION_MAIN_CLASS);
    }

    @Override
    protected void setActionTokenProperties(Configuration jobconf) {
        String hdfsServers = jobconf.get(OOZIE_LAUNCHER_MAPREDUCE_JOB_HDFS_SERVERS);
        if (hdfsServers != null) {
            jobconf.set("mapreduce.job.hdfs-servers", hdfsServers);
            String tokenRenewalExclude = jobconf.get(OOZIE_LAUNCHER_MAPREDUCE_JOB_HDFS_SERVERS_TOKEN_RENEWAL_EXCLUDE);
            if (tokenRenewalExclude != null) {
                jobconf.set(JOB_NAMENODES_TOKEN_RENEWAL_EXCLUDE, tokenRenewalExclude);
            }
        }
    }
}

