/*
 * Decompiled with CFR 0.152.
 */
package org.apache.oozie.action.hadoop;

import com.google.common.annotations.VisibleForTesting;
import java.io.IOException;
import java.util.HashMap;
import java.util.Map;
import org.apache.hadoop.io.Text;
import org.apache.hadoop.security.UserGroupInformation;
import org.apache.hadoop.security.token.Token;
import org.apache.oozie.action.hadoop.CredentialsProvider;
import org.apache.oozie.action.hadoop.HDFSCredentials;
import org.apache.oozie.action.hadoop.JHSCredentials;
import org.apache.oozie.action.hadoop.YarnRMCredentials;
import org.apache.oozie.service.ConfigurationService;
import org.apache.oozie.util.StringUtils;
import org.apache.oozie.util.XLog;

public class CredentialsProviderFactory {
    public static final String CRED_KEY = "oozie.credentials.credentialclasses";
    private static final XLog LOG = XLog.getLog(CredentialsProviderFactory.class);
    public static final String HDFS = "hdfs";
    public static final String YARN = "yarnRM";
    public static final String JHS = "jhs";
    private static CredentialsProviderFactory instance;
    private final Map<String, Class<? extends CredentialsProvider>> providerCache = new HashMap<String, Class<? extends CredentialsProvider>>();

    @VisibleForTesting
    static void destroy() {
        instance = null;
    }

    public static CredentialsProviderFactory getInstance() throws Exception {
        if (instance == null) {
            instance = new CredentialsProviderFactory();
        }
        return instance;
    }

    private CredentialsProviderFactory() throws Exception {
        for (String function : ConfigurationService.getStrings(CRED_KEY)) {
            function = StringUtils.trim(function);
            LOG.debug("Creating Credential class for : " + function);
            String[] str = function.split("=");
            if (str.length <= 0) continue;
            String type = str[0];
            String classname = str[1];
            if (classname != null) {
                LOG.debug("Creating Credential type : '{0}', class Name : '{1}'", type, classname);
                Class<?> klass = null;
                try {
                    klass = Thread.currentThread().getContextClassLoader().loadClass(classname);
                }
                catch (ClassNotFoundException ex) {
                    LOG.warn("Exception while loading the class '{0}'", classname, ex);
                    throw ex;
                }
                this.providerCache.put(type, klass);
                continue;
            }
            LOG.warn("Credential provider class is null for '{0}', skipping", type);
        }
        this.providerCache.put(HDFS, HDFSCredentials.class);
        this.providerCache.put(YARN, YarnRMCredentials.class);
        this.providerCache.put(JHS, JHSCredentials.class);
    }

    static Text getUniqueAlias(Token<?> token) {
        return new Text(String.format("%s_%s_%d", token.getKind().toString(), token.getService().toString(), System.currentTimeMillis()));
    }

    public CredentialsProvider createCredentialsProvider(String type) throws Exception {
        Class<? extends CredentialsProvider> providerClass = this.providerCache.get(type);
        if (providerClass == null) {
            return null;
        }
        return providerClass.newInstance();
    }

    public static void ensureKerberosLogin() throws IOException {
        LOG.debug("About to relogin from keytab");
        UserGroupInformation.getLoginUser().checkTGTAndReloginFromKeytab();
        LOG.debug("Relogin from keytab successful");
    }
}

