/*
 * Decompiled with CFR 0.152.
 */
package org.apache.oozie;

import java.io.ByteArrayInputStream;
import java.io.DataInputStream;
import java.io.IOException;
import org.apache.oozie.compression.CodecFactory;
import org.apache.oozie.compression.CompressionCodec;
import org.apache.oozie.util.ByteArrayUtils;
import org.apache.oozie.util.StringUtils;

public class StringBlob {
    private byte[] rawBlob;
    private String string;

    public StringBlob(byte[] byteArray) {
        this.rawBlob = ByteArrayUtils.weakIntern(byteArray);
    }

    public StringBlob(String inputString) {
        this.string = StringUtils.intern(inputString);
        this.rawBlob = null;
    }

    public void setString(String str) {
        this.string = StringUtils.intern(str);
        this.rawBlob = null;
    }

    public String getString() {
        if (this.string != null) {
            return this.string;
        }
        if (this.rawBlob == null) {
            return null;
        }
        try {
            DataInputStream dais = new DataInputStream(new ByteArrayInputStream(this.rawBlob));
            CompressionCodec codec = CodecFactory.getDeCompressionCodec(dais);
            this.string = codec != null ? StringUtils.intern(codec.decompressToString(dais)) : StringUtils.intern(new String(this.rawBlob, "UTF-8"));
            dais.close();
        }
        catch (IOException ex) {
            throw new RuntimeException(ex);
        }
        this.rawBlob = null;
        return this.string;
    }

    public byte[] getRawBlob() {
        if (this.rawBlob != null) {
            return this.rawBlob;
        }
        if (this.string == null) {
            return null;
        }
        if (CodecFactory.isCompressionEnabled()) {
            byte[] bytes = CodecFactory.getHeaderBytes();
            try {
                this.rawBlob = ByteArrayUtils.weakIntern(CodecFactory.getCompressionCodec().compressString(bytes, this.string));
            }
            catch (IOException ex) {
                throw new RuntimeException(ex);
            }
        } else {
            this.rawBlob = ByteArrayUtils.weakIntern(this.string.getBytes());
        }
        return this.rawBlob;
    }
}

