/*
 * Decompiled with CFR 0.152.
 */
package org.apache.oozie;

import java.util.ArrayList;
import java.util.List;
import java.util.Properties;
import org.apache.oozie.BaseEngineException;
import org.apache.oozie.BaseLocalOozieClient;
import org.apache.oozie.CoordinatorActionBean;
import org.apache.oozie.CoordinatorActionInfo;
import org.apache.oozie.CoordinatorEngine;
import org.apache.oozie.CoordinatorEngineException;
import org.apache.oozie.CoordinatorJobBean;
import org.apache.oozie.CoordinatorJobInfo;
import org.apache.oozie.ErrorCode;
import org.apache.oozie.client.CoordinatorAction;
import org.apache.oozie.client.CoordinatorJob;
import org.apache.oozie.client.OozieClientException;
import org.apache.oozie.client.WorkflowJob;
import org.apache.oozie.command.CommandException;
import org.apache.oozie.coord.CoordUtils;
import org.apache.oozie.util.XConfiguration;

public class LocalOozieClientCoord
extends BaseLocalOozieClient {
    private final CoordinatorEngine coordEngine;

    public LocalOozieClientCoord(CoordinatorEngine coordEngine) {
        super(coordEngine);
        this.coordEngine = coordEngine;
    }

    @Override
    public List<CoordinatorAction> reRunCoord(String jobId, String rerunType, String scope, boolean refresh, boolean noCleanup) throws OozieClientException {
        return this.getCoordinatorActions(jobId, rerunType, scope, refresh, noCleanup, false, null);
    }

    @Override
    public List<CoordinatorAction> reRunCoord(String jobId, String rerunType, String scope, boolean refresh, boolean noCleanup, boolean failed, Properties conf) throws OozieClientException {
        return this.getCoordinatorActions(jobId, rerunType, scope, refresh, noCleanup, failed, conf);
    }

    private List<CoordinatorAction> getCoordinatorActions(String jobId, String rerunType, String scope, boolean refresh, boolean noCleanup, boolean failed, Properties prop) throws OozieClientException {
        try {
            XConfiguration conf = null;
            if (prop != null) {
                conf = new XConfiguration(prop);
            }
            if (!rerunType.equals("date") && !rerunType.equals("action")) {
                throw new CommandException(ErrorCode.E1018, "date or action expected.");
            }
            CoordinatorActionInfo coordInfo = this.coordEngine.reRun(jobId, rerunType, scope, refresh, noCleanup, failed, conf);
            List<CoordinatorActionBean> actionBeans = coordInfo != null ? coordInfo.getCoordActions() : CoordUtils.getCoordActions(rerunType, jobId, scope, false);
            ArrayList<CoordinatorAction> actions = new ArrayList<CoordinatorAction>();
            for (CoordinatorActionBean actionBean : actionBeans) {
                actions.add(actionBean);
            }
            return actions;
        }
        catch (CommandException ce) {
            throw new OozieClientException(ce.getErrorCode().toString(), (Throwable)ce);
        }
        catch (BaseEngineException ex) {
            throw new OozieClientException(ex.getErrorCode().toString(), (Throwable)ex);
        }
    }

    @Override
    public CoordinatorJob getCoordJobInfo(String jobId) throws OozieClientException {
        try {
            return this.coordEngine.getCoordJob(jobId);
        }
        catch (CoordinatorEngineException ex) {
            throw new OozieClientException(ex.getErrorCode().toString(), (Throwable)ex);
        }
        catch (BaseEngineException bex) {
            throw new OozieClientException(bex.getErrorCode().toString(), (Throwable)bex);
        }
    }

    @Override
    public CoordinatorJob getCoordJobInfo(String jobId, String filter, int start, int len) throws OozieClientException {
        try {
            return this.coordEngine.getCoordJob(jobId, filter, start, len, false);
        }
        catch (BaseEngineException bex) {
            throw new OozieClientException(bex.getErrorCode().toString(), (Throwable)bex);
        }
    }

    @Override
    public CoordinatorAction getCoordActionInfo(String actionId) throws OozieClientException {
        try {
            return this.coordEngine.getCoordAction(actionId);
        }
        catch (BaseEngineException bex) {
            throw new OozieClientException(bex.getErrorCode().toString(), (Throwable)bex);
        }
    }

    @Override
    public List<CoordinatorJob> getCoordJobsInfo(String filter, int start, int len) throws OozieClientException {
        try {
            CoordinatorJobInfo info = this.coordEngine.getCoordJobs(filter, start, len);
            ArrayList<CoordinatorJob> jobs = new ArrayList<CoordinatorJob>();
            List<CoordinatorJobBean> jobBeans = info.getCoordJobs();
            for (CoordinatorJobBean jobBean : jobBeans) {
                jobs.add(jobBean);
            }
            return jobs;
        }
        catch (CoordinatorEngineException ex) {
            throw new OozieClientException(ex.getErrorCode().toString(), (Throwable)ex);
        }
    }

    @Override
    public String updateCoord(String jobId, Properties conf, String dryrun, String showDiff) throws OozieClientException {
        try {
            return this.coordEngine.updateJob(new XConfiguration(conf), jobId, Boolean.valueOf(dryrun), Boolean.valueOf(showDiff));
        }
        catch (CoordinatorEngineException e) {
            throw new OozieClientException(e.getErrorCode().toString(), (Throwable)e);
        }
    }

    @Override
    public String updateCoord(String jobId, String dryrun, String showDiff) throws OozieClientException {
        try {
            return this.coordEngine.updateJob(new XConfiguration(), jobId, Boolean.valueOf(dryrun), Boolean.valueOf(showDiff));
        }
        catch (CoordinatorEngineException e) {
            throw new OozieClientException(e.getErrorCode().toString(), (Throwable)e);
        }
    }

    @Override
    public CoordinatorJob getCoordJobInfo(String jobId, String filter, int start, int len, String order) throws OozieClientException {
        try {
            return this.coordEngine.getCoordJob(jobId, filter, start, len, order.equalsIgnoreCase("DESC"));
        }
        catch (BaseEngineException e) {
            throw new OozieClientException(e.getErrorCode().toString(), (Throwable)e);
        }
    }

    @Override
    public List<CoordinatorAction> kill(String jobId, String rangeType, String scope) throws OozieClientException {
        try {
            return this.coordEngine.killActions(jobId, rangeType, scope).getCoordActions();
        }
        catch (CoordinatorEngineException e) {
            throw new OozieClientException(e.getErrorCode().toString(), (Throwable)e);
        }
    }

    @Override
    public List<CoordinatorAction> ignore(String jobId, String scope) throws OozieClientException {
        try {
            return this.coordEngine.ignore(jobId, "action", scope).getCoordActions();
        }
        catch (CoordinatorEngineException e) {
            throw new OozieClientException(e.getErrorCode().toString(), (Throwable)e);
        }
    }

    @Override
    public List<WorkflowJob> getWfsForCoordAction(String coordActionId) throws OozieClientException {
        try {
            return this.coordEngine.getReruns(coordActionId);
        }
        catch (CoordinatorEngineException e) {
            throw new OozieClientException(e.getErrorCode().toString(), (Throwable)e);
        }
    }
}

