/*
 * Decompiled with CFR 0.152.
 */
package org.apache.oozie;

import java.util.List;
import org.apache.oozie.BaseEngineException;
import org.apache.oozie.BaseLocalOozieClient;
import org.apache.oozie.DagEngine;
import org.apache.oozie.DagEngineException;
import org.apache.oozie.client.OozieClientException;
import org.apache.oozie.client.WorkflowAction;
import org.apache.oozie.client.WorkflowJob;

public class LocalOozieClient
extends BaseLocalOozieClient {
    private DagEngine dagEngine;

    public LocalOozieClient(DagEngine dagEngine) {
        super(dagEngine);
        this.dagEngine = dagEngine;
    }

    @Override
    public WorkflowJob getJobInfo(String jobId) throws OozieClientException {
        try {
            return this.dagEngine.getJob(jobId);
        }
        catch (DagEngineException ex) {
            throw new OozieClientException(ex.getErrorCode().toString(), (Throwable)ex);
        }
    }

    @Override
    public List<WorkflowJob> getJobsInfo(String filter, int start, int len) throws OozieClientException {
        try {
            return this.dagEngine.getJobs(filter, start, len).getWorkflows();
        }
        catch (DagEngineException ex) {
            throw new OozieClientException(ex.getErrorCode().toString(), (Throwable)ex);
        }
    }

    @Override
    public List<WorkflowJob> getJobsInfo(String filter) throws OozieClientException {
        return this.getJobsInfo(filter, 1, 100);
    }

    @Override
    public WorkflowJob getJobInfo(String jobId, int start, int len) throws OozieClientException {
        try {
            return this.dagEngine.getJob(jobId, start, len);
        }
        catch (DagEngineException e) {
            throw new OozieClientException(e.getErrorCode().toString(), (Throwable)e);
        }
    }

    @Override
    public WorkflowAction getWorkflowActionInfo(String actionId) throws OozieClientException {
        try {
            return this.dagEngine.getWorkflowAction(actionId);
        }
        catch (BaseEngineException e) {
            throw new OozieClientException(e.getErrorCode().toString(), (Throwable)e);
        }
    }
}

