/*
 * Decompiled with CFR 0.152.
 */
package org.apache.oozie;

import java.io.ByteArrayInputStream;
import java.io.DataInputStream;
import java.io.IOException;
import org.apache.oozie.compression.CodecFactory;
import org.apache.oozie.compression.CompressionCodec;
import org.apache.oozie.util.ByteArrayUtils;

public class BinaryBlob {
    private byte[] rawBlob;
    private byte[] bytes;

    public BinaryBlob(byte[] byteArray, boolean isUncompressed) {
        if (isUncompressed) {
            this.bytes = ByteArrayUtils.weakIntern(byteArray);
            this.rawBlob = null;
        } else {
            this.rawBlob = ByteArrayUtils.weakIntern(byteArray);
        }
    }

    public void setBytes(byte[] byteArray) {
        this.bytes = ByteArrayUtils.weakIntern(byteArray);
        this.rawBlob = null;
    }

    public byte[] getBytes() {
        if (this.bytes != null) {
            return this.bytes;
        }
        if (this.rawBlob == null) {
            return null;
        }
        try {
            DataInputStream dais = new DataInputStream(new ByteArrayInputStream(this.rawBlob));
            CompressionCodec codec = CodecFactory.getDeCompressionCodec(dais);
            this.bytes = codec != null ? ByteArrayUtils.weakIntern(codec.decompressToBytes(dais)) : ByteArrayUtils.weakIntern(this.rawBlob);
            dais.close();
        }
        catch (IOException ex) {
            throw new RuntimeException(ex);
        }
        this.rawBlob = null;
        return this.bytes;
    }

    public byte[] getRawBlob() {
        if (this.rawBlob != null) {
            return this.rawBlob;
        }
        if (this.bytes == null) {
            return null;
        }
        if (CodecFactory.isCompressionEnabled()) {
            byte[] headerBytes = CodecFactory.getHeaderBytes();
            try {
                this.rawBlob = ByteArrayUtils.weakIntern(CodecFactory.getCompressionCodec().compressBytes(headerBytes, this.bytes));
            }
            catch (IOException ex) {
                throw new RuntimeException(ex);
            }
        } else {
            this.rawBlob = ByteArrayUtils.weakIntern(this.bytes);
        }
        return this.rawBlob;
    }
}

