/*
 * Decompiled with CFR 0.152.
 */
package org.pentaho.hadoop.shim.common.format.parquet;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.hadoop.conf.Configuration;
import org.apache.parquet.hadoop.api.InitContext;
import org.apache.parquet.hadoop.api.ReadSupport;
import org.apache.parquet.io.api.RecordMaterializer;
import org.apache.parquet.schema.MessageType;
import org.apache.parquet.schema.Type;
import org.pentaho.di.core.RowMetaAndData;
import org.pentaho.hadoop.shim.api.format.IParquetInputField;
import org.pentaho.hadoop.shim.common.format.parquet.ParquetConverter;
import org.pentaho.hadoop.shim.common.format.parquet.ParquetInputFieldList;

public class PentahoParquetReadSupport
extends ReadSupport<RowMetaAndData> {
    ParquetConverter converter;
    List<? extends IParquetInputField> fields;

    public ReadSupport.ReadContext init(InitContext context) {
        String schemaStr = context.getConfiguration().get("PentahoParquetSchema");
        if (schemaStr == null) {
            throw new RuntimeException("Schema not defined in the PentahoParquetSchema key");
        }
        ParquetInputFieldList schema = ParquetInputFieldList.unmarshall(schemaStr);
        this.converter = new ParquetConverter(schema.getFields());
        MessageType fileSchema = context.getFileSchema();
        ArrayList<Type> newFields = new ArrayList<Type>();
        for (IParquetInputField f : schema) {
            Type origField = (Type)fileSchema.getFields().get(fileSchema.getFieldIndex(f.getFormatFieldName()));
            newFields.add(origField);
        }
        if (newFields.isEmpty()) {
            throw new RuntimeException("Fields should be declared");
        }
        MessageType newSchema = new MessageType(fileSchema.getName(), newFields);
        return new ReadSupport.ReadContext(newSchema, new HashMap());
    }

    public RecordMaterializer<RowMetaAndData> prepareForRead(Configuration configuration, Map<String, String> keyValueMetaData, MessageType fileSchema, ReadSupport.ReadContext readContext) {
        return new ParquetConverter.MyRecordMaterializer(this.converter);
    }
}

