/*
 * Decompiled with CFR 0.152.
 */
package org.pentaho.hadoop.shim.common.format;

import com.amazonaws.auth.AWSCredentials;
import com.amazonaws.auth.DefaultAWSCredentialsProviderChain;
import java.net.URI;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.Path;

public class S3NCredentialUtils {
    private static final String S3NSCHEME = "s3n";
    private static final String S3NROOTBUCKET = "s3n/";

    public static void applyS3CredentialsToHadoopConfigurationIfNecessary(String filename, Configuration conf) {
        String scheme;
        Path outputFile = new Path(S3NCredentialUtils.scrubFilePathIfNecessary(filename));
        URI uri = outputFile.toUri();
        String string = scheme = uri != null ? uri.getScheme() : null;
        if (scheme != null && scheme.equals(S3NSCHEME)) {
            AWSCredentials credentials = DefaultAWSCredentialsProviderChain.getInstance().getCredentials();
            conf.set("fs.s3n.awsAccessKeyId", credentials.getAWSAccessKeyId());
            conf.set("fs.s3n.awsSecretAccessKey", credentials.getAWSSecretKey());
            conf.set("fs.s3.buffer.dir", System.getProperty("java.io.tmpdir"));
        }
    }

    public static String scrubFilePathIfNecessary(String filename) {
        return filename != null ? filename.replace(S3NROOTBUCKET, "") : filename;
    }
}

