/*
 * Decompiled with CFR 0.152.
 */
package co.cask.tephra.persist;

import co.cask.tephra.ChangeId;
import co.cask.tephra.TransactionType;
import com.google.common.base.Objects;
import com.google.common.collect.Sets;
import java.io.DataInput;
import java.io.DataOutput;
import java.io.IOException;
import java.util.Collections;
import java.util.Iterator;
import java.util.Set;
import org.apache.hadoop.io.Writable;

public class TransactionEdit
implements Writable {
    private static final TransactionEditCodec CODEC_V4 = new TransactionEditCodecV3();
    private static final byte V4 = -4;
    private static final TransactionEditCodec CODEC_V3 = new TransactionEditCodecV3();
    private static final byte V3 = -3;
    private static final TransactionEditCodec CODEC_V2 = new TransactionEditCodecV2();
    private static final byte V2 = -2;
    private static final TransactionEditCodec CODEC_V1 = new TransactionEditCodecV1();
    private static final byte V1 = -1;
    private long writePointer;
    private long visibilityUpperBound;
    private long commitPointer;
    private long expirationDate;
    private State state;
    private Set<ChangeId> changes;
    private boolean canCommit;
    private TransactionType type;
    private Set<Long> truncateInvalidTx;
    private long truncateInvalidTxTime;
    private long parentWritePointer;
    private long[] checkpointPointers;

    public TransactionEdit() {
        this.changes = Sets.newHashSet();
        this.truncateInvalidTx = Sets.newHashSet();
    }

    TransactionEdit(long writePointer, long visibilityUpperBound, State state, long expirationDate, Set<ChangeId> changes, long commitPointer, boolean canCommit, TransactionType type, Set<Long> truncateInvalidTx2, long truncateInvalidTxTime, long parentWritePointer, long[] checkpointPointers) {
        this.writePointer = writePointer;
        this.visibilityUpperBound = visibilityUpperBound;
        this.state = state;
        this.expirationDate = expirationDate;
        this.changes = changes != null ? changes : Collections.emptySet();
        this.commitPointer = commitPointer;
        this.canCommit = canCommit;
        this.type = type;
        this.truncateInvalidTx = truncateInvalidTx2 != null ? truncateInvalidTx2 : Collections.emptySet();
        this.truncateInvalidTxTime = truncateInvalidTxTime;
        this.parentWritePointer = parentWritePointer;
        this.checkpointPointers = checkpointPointers;
    }

    public long getWritePointer() {
        return this.writePointer;
    }

    public long getVisibilityUpperBound() {
        return this.visibilityUpperBound;
    }

    public State getState() {
        return this.state;
    }

    public long getExpiration() {
        return this.expirationDate;
    }

    public Set<ChangeId> getChanges() {
        return this.changes;
    }

    public long getCommitPointer() {
        return this.commitPointer;
    }

    public boolean getCanCommit() {
        return this.canCommit;
    }

    public TransactionType getType() {
        return this.type;
    }

    public Set<Long> getTruncateInvalidTx() {
        return this.truncateInvalidTx;
    }

    public long getTruncateInvalidTxTime() {
        return this.truncateInvalidTxTime;
    }

    public long getParentWritePointer() {
        return this.parentWritePointer;
    }

    public long[] getCheckpointPointers() {
        return this.checkpointPointers;
    }

    public static TransactionEdit createStarted(long writePointer, long visibilityUpperBound, long expirationDate, TransactionType type) {
        return new TransactionEdit(writePointer, visibilityUpperBound, State.INPROGRESS, expirationDate, null, 0L, false, type, null, 0L, 0L, null);
    }

    public static TransactionEdit createCommitting(long writePointer, Set<ChangeId> changes) {
        return new TransactionEdit(writePointer, 0L, State.COMMITTING, 0L, changes, 0L, false, null, null, 0L, 0L, null);
    }

    public static TransactionEdit createCommitted(long writePointer, Set<ChangeId> changes, long nextWritePointer, boolean canCommit) {
        return new TransactionEdit(writePointer, 0L, State.COMMITTED, 0L, changes, nextWritePointer, canCommit, null, null, 0L, 0L, null);
    }

    public static TransactionEdit createAborted(long writePointer, TransactionType type, long[] checkpointPointers) {
        return new TransactionEdit(writePointer, 0L, State.ABORTED, 0L, null, 0L, false, type, null, 0L, 0L, checkpointPointers);
    }

    public static TransactionEdit createInvalid(long writePointer) {
        return new TransactionEdit(writePointer, 0L, State.INVALID, 0L, null, 0L, false, null, null, 0L, 0L, null);
    }

    public static TransactionEdit createMoveWatermark(long writePointer) {
        return new TransactionEdit(writePointer, 0L, State.MOVE_WATERMARK, 0L, null, 0L, false, null, null, 0L, 0L, null);
    }

    public static TransactionEdit createTruncateInvalidTx(Set<Long> truncateInvalidTx2) {
        return new TransactionEdit(0L, 0L, State.TRUNCATE_INVALID_TX, 0L, null, 0L, false, null, truncateInvalidTx2, 0L, 0L, null);
    }

    public static TransactionEdit createTruncateInvalidTxBefore(long truncateInvalidTxTime) {
        return new TransactionEdit(0L, 0L, State.TRUNCATE_INVALID_TX, 0L, null, 0L, false, null, null, truncateInvalidTxTime, 0L, null);
    }

    public static TransactionEdit createCheckpoint(long writePointer, long parentWritePointer) {
        return new TransactionEdit(writePointer, 0L, State.CHECKPOINT, 0L, null, 0L, false, null, null, 0L, parentWritePointer, null);
    }

    public void write(DataOutput out) throws IOException {
        CODEC_V4.encode(this, out);
    }

    public void readFields(DataInput in) throws IOException {
        byte version = in.readByte();
        switch (version) {
            case -4: {
                CODEC_V4.decode(this, in);
                break;
            }
            case -3: {
                CODEC_V3.decode(this, in);
                break;
            }
            case -2: {
                CODEC_V2.decode(this, in);
                break;
            }
            case -1: {
                CODEC_V1.decode(this, in);
                break;
            }
            default: {
                throw new IOException("Unexpected version for edit: " + version);
            }
        }
    }

    public final boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof TransactionEdit)) {
            return false;
        }
        TransactionEdit that = (TransactionEdit)o;
        return Objects.equal((Object)this.writePointer, (Object)that.writePointer) && Objects.equal((Object)this.visibilityUpperBound, (Object)that.visibilityUpperBound) && Objects.equal((Object)this.commitPointer, (Object)that.commitPointer) && Objects.equal((Object)this.expirationDate, (Object)that.expirationDate) && Objects.equal((Object)((Object)this.state), (Object)((Object)that.state)) && Objects.equal(this.changes, that.changes) && Objects.equal((Object)this.canCommit, (Object)that.canCommit) && Objects.equal((Object)this.type, (Object)that.type) && Objects.equal(this.truncateInvalidTx, that.truncateInvalidTx) && Objects.equal((Object)this.truncateInvalidTxTime, (Object)that.truncateInvalidTxTime) && Objects.equal((Object)this.parentWritePointer, (Object)that.parentWritePointer) && Objects.equal((Object)this.checkpointPointers, (Object)that.checkpointPointers);
    }

    public final int hashCode() {
        return Objects.hashCode((Object[])new Object[]{this.writePointer, this.visibilityUpperBound, this.commitPointer, this.expirationDate, this.state, this.changes, this.canCommit, this.type, this.parentWritePointer, this.checkpointPointers});
    }

    public String toString() {
        return Objects.toStringHelper((Object)this).add("writePointer", this.writePointer).add("visibilityUpperBound", this.visibilityUpperBound).add("commitPointer", this.commitPointer).add("expiration", this.expirationDate).add("state", (Object)this.state).add("changesSize", this.changes != null ? this.changes.size() : 0).add("canCommit", this.canCommit).add("type", (Object)this.type).add("truncateInvalidTx", this.truncateInvalidTx).add("truncateInvalidTxTime", this.truncateInvalidTxTime).add("parentWritePointer", this.parentWritePointer).add("checkpointPointers", (Object)this.checkpointPointers).toString();
    }

    static /* synthetic */ long[] access$1102(TransactionEdit x0, long[] x1) {
        x0.checkpointPointers = x1;
        return x1;
    }

    static class TransactionEditCodeV4
    extends TransactionEditCodecV3 {
        TransactionEditCodeV4() {
        }

        @Override
        public void decode(TransactionEdit dest, DataInput in) throws IOException {
            super.decode(dest, in);
            dest.parentWritePointer = in.readLong();
            int checkpointPointersLen = in.readInt();
            TransactionEdit.access$1102(dest, new long[checkpointPointersLen]);
            for (int i = 0; i < checkpointPointersLen; ++i) {
                ((TransactionEdit)dest).checkpointPointers[i] = in.readLong();
            }
        }

        @Override
        public void encode(TransactionEdit src, DataOutput out) throws IOException {
            super.encode(src, out);
            out.writeLong(src.parentWritePointer);
            if (src.checkpointPointers == null) {
                out.writeInt(0);
            } else {
                out.writeInt(src.checkpointPointers.length);
                for (int i = 0; i < src.checkpointPointers.length; ++i) {
                    out.writeLong(src.checkpointPointers[i]);
                }
            }
        }

        @Override
        protected void writeVersion(DataOutput out) throws IOException {
            out.writeByte(-4);
        }
    }

    static class TransactionEditCodecV3
    implements TransactionEditCodec {
        TransactionEditCodecV3() {
        }

        @Override
        public void decode(TransactionEdit dest, DataInput in) throws IOException {
            dest.writePointer = in.readLong();
            int stateIdx = in.readInt();
            try {
                dest.state = State.values()[stateIdx];
            }
            catch (ArrayIndexOutOfBoundsException e) {
                throw new IOException("State enum ordinal value is out of range: " + stateIdx);
            }
            dest.expirationDate = in.readLong();
            dest.commitPointer = in.readLong();
            dest.canCommit = in.readBoolean();
            int changeSize = in.readInt();
            dest.changes = this.emptySet(dest.changes);
            for (int i = 0; i < changeSize; ++i) {
                int currentLength = in.readInt();
                byte[] currentBytes = new byte[currentLength];
                in.readFully(currentBytes);
                dest.changes.add(new ChangeId(currentBytes));
            }
            dest.visibilityUpperBound = in.readLong();
            int typeIdx = in.readInt();
            if (typeIdx < 0) {
                dest.type = null;
            } else {
                try {
                    dest.type = TransactionType.values()[typeIdx];
                }
                catch (ArrayIndexOutOfBoundsException e) {
                    throw new IOException("Type enum ordinal value is out of range: " + typeIdx);
                }
            }
            int truncateInvalidTxSize = in.readInt();
            dest.truncateInvalidTx = this.emptySet(dest.truncateInvalidTx);
            for (int i = 0; i < truncateInvalidTxSize; ++i) {
                dest.truncateInvalidTx.add(in.readLong());
            }
            dest.truncateInvalidTxTime = in.readLong();
        }

        private <T> Set<T> emptySet(Set<T> set) {
            if (set == null) {
                return Sets.newHashSet();
            }
            set.clear();
            return set;
        }

        @Override
        public void encode(TransactionEdit src, DataOutput out) throws IOException {
            this.writeVersion(out);
            out.writeLong(src.writePointer);
            out.writeInt(src.state.ordinal());
            out.writeLong(src.expirationDate);
            out.writeLong(src.commitPointer);
            out.writeBoolean(src.canCommit);
            if (src.changes == null) {
                out.writeInt(0);
            } else {
                out.writeInt(src.changes.size());
                for (ChangeId c : src.changes) {
                    byte[] cKey = c.getKey();
                    out.writeInt(cKey.length);
                    out.write(cKey);
                }
            }
            out.writeLong(src.visibilityUpperBound);
            if (src.type == null) {
                out.writeInt(-1);
            } else {
                out.writeInt(src.type.ordinal());
            }
            if (src.truncateInvalidTx == null) {
                out.writeInt(0);
            } else {
                out.writeInt(src.truncateInvalidTx.size());
                Iterator i$ = src.truncateInvalidTx.iterator();
                while (i$.hasNext()) {
                    long id = (Long)i$.next();
                    out.writeLong(id);
                }
            }
            out.writeLong(src.truncateInvalidTxTime);
        }

        protected void writeVersion(DataOutput out) throws IOException {
            out.writeByte(-3);
        }
    }

    static class TransactionEditCodecV2
    implements TransactionEditCodec {
        TransactionEditCodecV2() {
        }

        @Override
        public void decode(TransactionEdit dest, DataInput in) throws IOException {
            if (dest.changes == null) {
                dest.changes = Sets.newHashSet();
            } else {
                dest.changes.clear();
            }
            dest.writePointer = in.readLong();
            int stateIdx = in.readInt();
            try {
                dest.state = State.values()[stateIdx];
            }
            catch (ArrayIndexOutOfBoundsException e) {
                throw new IOException("State enum ordinal value is out of range: " + stateIdx);
            }
            dest.expirationDate = in.readLong();
            dest.commitPointer = in.readLong();
            dest.canCommit = in.readBoolean();
            int changeSize = in.readInt();
            for (int i = 0; i < changeSize; ++i) {
                int currentLength = in.readInt();
                byte[] currentBytes = new byte[currentLength];
                in.readFully(currentBytes);
                dest.changes.add(new ChangeId(currentBytes));
            }
            dest.visibilityUpperBound = in.readLong();
        }

        @Override
        public void encode(TransactionEdit src, DataOutput out) throws IOException {
            out.writeByte(-2);
            out.writeLong(src.writePointer);
            out.writeInt(src.state.ordinal());
            out.writeLong(src.expirationDate);
            out.writeLong(src.commitPointer);
            out.writeBoolean(src.canCommit);
            if (src.changes == null) {
                out.writeInt(0);
            } else {
                out.writeInt(src.changes.size());
                for (ChangeId c : src.changes) {
                    byte[] cKey = c.getKey();
                    out.writeInt(cKey.length);
                    out.write(cKey);
                }
            }
            out.writeLong(src.visibilityUpperBound);
        }
    }

    static class TransactionEditCodecV1
    implements TransactionEditCodec {
        TransactionEditCodecV1() {
        }

        @Override
        public void decode(TransactionEdit src, DataInput in) throws IOException {
            if (src.changes == null) {
                src.changes = Sets.newHashSet();
            } else {
                src.changes.clear();
            }
            src.writePointer = in.readLong();
            src.visibilityUpperBound = 0L;
            int stateIdx = in.readInt();
            try {
                src.state = State.values()[stateIdx];
            }
            catch (ArrayIndexOutOfBoundsException e) {
                throw new IOException("State enum ordinal value is out of range: " + stateIdx);
            }
            src.expirationDate = in.readLong();
            src.commitPointer = in.readLong();
            src.canCommit = in.readBoolean();
            int changeSize = in.readInt();
            for (int i = 0; i < changeSize; ++i) {
                int currentLength = in.readInt();
                byte[] currentBytes = new byte[currentLength];
                in.readFully(currentBytes);
                src.changes.add(new ChangeId(currentBytes));
            }
        }

        @Override
        @Deprecated
        public void encode(TransactionEdit src, DataOutput out) throws IOException {
            out.writeByte(-1);
            out.writeLong(src.writePointer);
            out.writeInt(src.state.ordinal());
            out.writeLong(src.expirationDate);
            out.writeLong(src.commitPointer);
            out.writeBoolean(src.canCommit);
            if (src.changes == null) {
                out.writeInt(0);
            } else {
                out.writeInt(src.changes.size());
                for (ChangeId c : src.changes) {
                    byte[] cKey = c.getKey();
                    out.writeInt(cKey.length);
                    out.write(cKey);
                }
            }
        }
    }

    static interface TransactionEditCodec {
        public void decode(TransactionEdit var1, DataInput var2) throws IOException;

        public void encode(TransactionEdit var1, DataOutput var2) throws IOException;
    }

    public static enum State {
        INPROGRESS,
        COMMITTING,
        COMMITTED,
        INVALID,
        ABORTED,
        MOVE_WATERMARK,
        TRUNCATE_INVALID_TX,
        CHECKPOINT;

    }
}

