/*
 * Decompiled with CFR 0.152.
 */
package org.pentaho.di.engine.ui;

import java.util.function.Supplier;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Menu;
import org.eclipse.swt.widgets.MenuItem;
import org.eclipse.swt.widgets.Tree;
import org.pentaho.di.core.exception.KettleException;
import org.pentaho.di.core.extension.ExtensionPoint;
import org.pentaho.di.core.extension.ExtensionPointInterface;
import org.pentaho.di.core.logging.LogChannelInterface;
import org.pentaho.di.engine.configuration.api.RunConfiguration;
import org.pentaho.di.engine.configuration.api.RunConfigurationService;
import org.pentaho.di.engine.ui.RunConfigurationDelegate;
import org.pentaho.di.i18n.BaseMessages;
import org.pentaho.di.ui.core.ConstUI;
import org.pentaho.di.ui.spoon.Spoon;
import org.pentaho.di.ui.spoon.TreeSelection;

@ExtensionPoint(id="RunConfigurationPopupMenuExtension", description="Creates popup menus for execution environments", extensionPointId="SpoonPopupMenuExtension")
public class RunConfigurationPopupMenuExtension
implements ExtensionPointInterface {
    private static Class<?> PKG = RunConfigurationPopupMenuExtension.class;
    private Supplier<Spoon> spoonSupplier = Spoon::getInstance;
    private String runConfiguration;
    private RunConfigurationDelegate runConfigurationDelegate;
    private RunConfigurationService runConfigurationManager;
    private Menu rootMenu;
    private Menu itemMenu;

    public RunConfigurationPopupMenuExtension(RunConfigurationDelegate runConfigurationDelegate, RunConfigurationService runConfigurationManager) {
        this.runConfigurationDelegate = runConfigurationDelegate;
        this.runConfigurationManager = runConfigurationManager;
    }

    public void callExtensionPoint(LogChannelInterface logChannelInterface, Object extension) throws KettleException {
        Menu popupMenu = null;
        Tree selectionTree = (Tree)extension;
        TreeSelection[] objects = this.spoonSupplier.get().getTreeObjects(selectionTree);
        TreeSelection object = objects[0];
        Object selection = object.getSelection();
        if (selection == RunConfiguration.class) {
            popupMenu = this.createRootPopupMenu(selectionTree);
        } else if (selection instanceof String) {
            this.runConfiguration = (String)selection;
            if (this.runConfiguration.equalsIgnoreCase("Pentaho local")) {
                return;
            }
            popupMenu = this.createItemPopupMenu(selectionTree);
        }
        if (popupMenu != null) {
            ConstUI.displayMenu((Menu)popupMenu, (Control)selectionTree);
        } else {
            selectionTree.setMenu(null);
        }
    }

    private Menu createRootPopupMenu(Tree tree) {
        if (this.rootMenu == null) {
            this.rootMenu = new Menu((Control)tree);
            MenuItem menuItem = new MenuItem(this.rootMenu, 0);
            menuItem.setText(BaseMessages.getString(PKG, (String)"RunConfigurationPopupMenuExtension.MenuItem.New", (String[])new String[0]));
            menuItem.addSelectionListener((SelectionListener)new SelectionAdapter(){

                public void widgetSelected(SelectionEvent selectionEvent) {
                    RunConfigurationPopupMenuExtension.this.runConfigurationDelegate.create();
                }
            });
        }
        return this.rootMenu;
    }

    private Menu createItemPopupMenu(Tree tree) {
        if (this.itemMenu == null) {
            this.itemMenu = new Menu((Control)tree);
            MenuItem editMenuItem = new MenuItem(this.itemMenu, 0);
            editMenuItem.setText(BaseMessages.getString(PKG, (String)"RunConfigurationPopupMenuExtension.MenuItem.Edit", (String[])new String[0]));
            editMenuItem.addSelectionListener((SelectionListener)new SelectionAdapter(){

                public void widgetSelected(SelectionEvent selectionEvent) {
                    RunConfigurationPopupMenuExtension.this.runConfigurationDelegate.edit(RunConfigurationPopupMenuExtension.this.runConfigurationManager.load(RunConfigurationPopupMenuExtension.this.runConfiguration));
                }
            });
            MenuItem deleteMenuItem = new MenuItem(this.itemMenu, 0);
            deleteMenuItem.setText(BaseMessages.getString(PKG, (String)"RunConfigurationPopupMenuExtension.MenuItem.Delete", (String[])new String[0]));
            deleteMenuItem.addSelectionListener((SelectionListener)new SelectionAdapter(){

                public void widgetSelected(SelectionEvent selectionEvent) {
                    RunConfigurationPopupMenuExtension.this.runConfigurationDelegate.delete(RunConfigurationPopupMenuExtension.this.runConfigurationManager.load(RunConfigurationPopupMenuExtension.this.runConfiguration));
                }
            });
        }
        return this.itemMenu;
    }
}

