/*
 * Decompiled with CFR 0.152.
 */
package org.pentaho.di.engine.ui;

import org.eclipse.swt.graphics.Color;
import org.eclipse.swt.graphics.Device;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.widgets.Display;
import org.pentaho.di.base.AbstractMeta;
import org.pentaho.di.engine.configuration.api.RunConfiguration;
import org.pentaho.di.engine.ui.RunConfigurationDelegate;
import org.pentaho.di.engine.ui.RunConfigurationViewTreeExtension;
import org.pentaho.di.i18n.BaseMessages;
import org.pentaho.di.ui.core.gui.GUIResource;
import org.pentaho.di.ui.core.widget.tree.TreeNode;
import org.pentaho.di.ui.spoon.tree.TreeFolderProvider;

public class RunConfigurationFolderProvider
extends TreeFolderProvider {
    private static final Class<?> PKG = RunConfigurationViewTreeExtension.class;
    public static String STRING_RUN_CONFIGURATIONS = BaseMessages.getString(PKG, (String)"RunConfigurationTree.Title", (String[])new String[0]);
    private RunConfigurationDelegate runConfigurationDelegate;

    public RunConfigurationFolderProvider(RunConfigurationDelegate runConfigurationDelegate) {
        this.runConfigurationDelegate = runConfigurationDelegate;
    }

    public void refresh(AbstractMeta meta, TreeNode treeNode, String filter) {
        GUIResource guiResource = GUIResource.getInstance();
        for (RunConfiguration runConfiguration : this.runConfigurationDelegate.load()) {
            if (!this.filterMatch(runConfiguration.getName(), filter)) continue;
            String imageFile = runConfiguration.isReadOnly() ? "images/run_tree_disabled.svg" : "images/run_tree.svg";
            TreeNode childTreeNode = this.createChildTreeNode(treeNode, runConfiguration.getName(), this.getRunConfigurationImage(guiResource, imageFile));
            if (!runConfiguration.isReadOnly()) continue;
            childTreeNode.setForeground(this.getDisabledColor());
        }
    }

    private Image getRunConfigurationImage(GUIResource guiResource, String file) {
        return guiResource.getImage(file, ((Object)((Object)this)).getClass().getClassLoader(), 24, 24);
    }

    private Color getDisabledColor() {
        Display device = Display.getCurrent();
        return new Color((Device)device, 188, 188, 188);
    }

    public String getTitle() {
        return STRING_RUN_CONFIGURATIONS;
    }

    private TreeNode createChildTreeNode(TreeNode parent, String text, Image image) {
        return super.createTreeNode(parent, text, image);
    }

    public TreeNode createTreeNode(TreeNode parent, String text, Image image) {
        TreeNode treeNode = super.createTreeNode(parent, text, image);
        treeNode.setIndex(0);
        return treeNode;
    }
}

