/*
 * Decompiled with CFR 0.152.
 */
package org.pentaho.big.data.kettle.plugins.oozie;

import com.google.common.annotations.VisibleForTesting;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import org.apache.commons.vfs2.FileObject;
import org.eclipse.swt.widgets.Shell;
import org.pentaho.big.data.api.cluster.NamedCluster;
import org.pentaho.big.data.kettle.plugins.job.AbstractJobEntry;
import org.pentaho.big.data.kettle.plugins.job.AbstractJobEntryController;
import org.pentaho.big.data.kettle.plugins.job.JobEntryMode;
import org.pentaho.big.data.kettle.plugins.job.PropertyEntry;
import org.pentaho.big.data.kettle.plugins.oozie.OozieJobExecutorConfig;
import org.pentaho.big.data.kettle.plugins.oozie.OozieJobExecutorJobEntry;
import org.pentaho.big.data.plugins.common.ui.HadoopClusterDelegateImpl;
import org.pentaho.di.core.exception.KettleFileException;
import org.pentaho.di.core.util.StringUtil;
import org.pentaho.di.core.variables.VariableSpace;
import org.pentaho.di.core.vfs.KettleVFS;
import org.pentaho.di.i18n.BaseMessages;
import org.pentaho.di.job.JobMeta;
import org.pentaho.metastore.api.exceptions.MetaStoreException;
import org.pentaho.ui.xul.XulDomContainer;
import org.pentaho.ui.xul.binding.Binding;
import org.pentaho.ui.xul.binding.BindingConvertor;
import org.pentaho.ui.xul.binding.BindingFactory;
import org.pentaho.ui.xul.components.XulMenuList;
import org.pentaho.ui.xul.containers.XulDialog;
import org.pentaho.ui.xul.containers.XulTree;
import org.pentaho.ui.xul.stereotype.Bindable;
import org.pentaho.ui.xul.util.AbstractModelList;

public class OozieJobExecutorJobEntryController
extends AbstractJobEntryController<OozieJobExecutorConfig, OozieJobExecutorJobEntry> {
    public static final String OOZIE_JOB_EXECUTOR = "oozie-job-executor";
    private static final String VALUE = "value";
    public static final String ERROR_BROWSING_DIRECTORY = "ErrorBrowsingDirectory";
    public static final String FILE_FILTER_NAMES_PROPERTIES = "FileFilterNames.Properties";
    public static final String MODE_TOGGLE_LABEL = "mode-toggle-label";
    public static final String ADVANCED_TABLE = "advanced-table";
    public static final String CHILDREN = "children";
    public static final String ELEMENTS = "elements";
    private final HadoopClusterDelegateImpl hadoopClusterDelegate;
    protected AbstractModelList<PropertyEntry> advancedArguments = new AbstractModelList();
    private transient boolean advancedArgumentsChanged = false;
    protected XulTree variablesTree = null;
    private Binding namedClustersBinding = null;
    private String modeToggleLabel;

    public OozieJobExecutorJobEntryController(JobMeta jobMeta, XulDomContainer container, OozieJobExecutorJobEntry jobEntry, BindingFactory bindingFactory, HadoopClusterDelegateImpl hadoopClusterDelegate) {
        super(jobMeta, container, (AbstractJobEntry)jobEntry, bindingFactory);
        this.hadoopClusterDelegate = hadoopClusterDelegate;
        if (((OozieJobExecutorConfig)jobEntry.getJobConfig()).getWorkflowProperties().size() > 0) {
            this.advancedArguments.addAll(((OozieJobExecutorConfig)jobEntry.getJobConfig()).getWorkflowProperties());
        }
        this.populateNamedClusters();
    }

    protected void beforeInit() {
        this.setMode(((OozieJobExecutorConfig)((OozieJobExecutorJobEntry)this.jobEntry).getJobConfig()).getModeAsEnum());
        this.variablesTree = (XulTree)this.container.getDocumentRoot().getElementById(ADVANCED_TABLE);
    }

    protected void syncModel() {
        if (!this.shouldUseAdvancedProperties()) {
            this.advancedArguments.clear();
            if (((OozieJobExecutorConfig)this.config).getWorkflowProperties() != null) {
                ((OozieJobExecutorConfig)this.config).getWorkflowProperties().clear();
            }
        } else {
            if (this.advancedArguments.size() == 0 && !StringUtil.isEmpty((String)((OozieJobExecutorConfig)this.config).getOozieWorkflowConfig())) {
                this.preFillAdvancedArgs();
            }
            ArrayList<PropertyEntry> m = new ArrayList<PropertyEntry>((Collection<PropertyEntry>)this.advancedArguments);
            ((OozieJobExecutorConfig)this.config).setWorkflowProperties(m);
        }
        ((OozieJobExecutorConfig)this.config).setMode(this.jobEntryMode);
    }

    private void preFillAdvancedArgs() {
        try {
            if (this.jobEntry != null && this.config != null) {
                Properties props = ((OozieJobExecutorJobEntry)this.jobEntry).getProperties((OozieJobExecutorConfig)this.config);
                for (Map.Entry<Object, Object> prop : props.entrySet()) {
                    if (!(prop.getKey() instanceof String) || !(prop.getValue() instanceof String)) continue;
                    PropertyEntry pEntry = new PropertyEntry(prop.getKey().toString(), prop.getValue().toString());
                    this.advancedArguments.add((Object)pEntry);
                }
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    protected boolean shouldUseAdvancedProperties() {
        return this.jobEntryMode == JobEntryMode.ADVANCED_LIST;
    }

    protected void setJobEntryMode(JobEntryMode mode) {
        this.jobEntryMode = mode;
    }

    protected void createBindings(final OozieJobExecutorConfig config, XulDomContainer container, BindingFactory bindingFactory, Collection<Binding> bindings) {
        bindingFactory.setBindingType(Binding.Type.BI_DIRECTIONAL);
        bindings.add(bindingFactory.createBinding((Object)config, "jobEntryName", "jobEntryName", VALUE, new BindingConvertor[0]));
        String clusterName = config.getClusterName();
        this.namedClustersBinding = bindingFactory.createBinding(config.getNamedClusters(), CHILDREN, "named-clusters", ELEMENTS, new BindingConvertor[0]);
        try {
            this.namedClustersBinding.fireSourceChanged();
        }
        catch (Throwable throwable) {
            // empty catch block
        }
        bindings.add(this.namedClustersBinding);
        Binding selectedNamedClusterBinding = bindingFactory.createBinding("named-clusters", "selectedIndex", (Object)config, "namedCluster", new BindingConvertor[]{new BindingConvertor<Integer, NamedCluster>(){

            public NamedCluster sourceToTarget(Integer index) {
                List<NamedCluster> clusters = config.getNamedClusters();
                if (index == -1 || clusters.isEmpty()) {
                    return null;
                }
                return clusters.get(index);
            }

            public Integer targetToSource(NamedCluster value) {
                return config.getNamedClusters().indexOf(value);
            }
        }});
        try {
            selectedNamedClusterBinding.fireSourceChanged();
        }
        catch (Throwable throwable) {
            // empty catch block
        }
        bindings.add(selectedNamedClusterBinding);
        this.selectNamedCluster(clusterName);
        bindings.add(bindingFactory.createBinding((Object)config, "oozieWorkflowConfig", "oozieWorkflowConfig", VALUE, new BindingConvertor[0]));
        bindings.add(bindingFactory.createBinding((Object)config, "blockingPollingInterval", "blockingPollingInterval", VALUE, new BindingConvertor[0]));
        BindingConvertor<String, Boolean> string2BooleanConvertor = new BindingConvertor<String, Boolean>(){

            public String targetToSource(Boolean aBoolean) {
                String val = aBoolean.toString();
                return val;
            }

            public Boolean sourceToTarget(String s) {
                Boolean val = Boolean.valueOf(s);
                return val;
            }
        };
        bindings.add(bindingFactory.createBinding((Object)config, "blockingExecution", "blockingExecution", "checked", new BindingConvertor[]{string2BooleanConvertor}));
        bindingFactory.setBindingType(Binding.Type.ONE_WAY);
        bindings.add(bindingFactory.createBinding((Object)this, "modeToggleLabel", this.getModeToggleLabelElementId(), VALUE, new BindingConvertor[0]));
        bindings.add(bindingFactory.createBinding((Object)config, "blockingExecution", "blockingPollingInterval", "!disabled", new BindingConvertor[]{string2BooleanConvertor}));
        BindingConvertor<AbstractModelList<PropertyEntry>, Collection<PropertyEntry>> propsChangedBindingConvertor = new BindingConvertor<AbstractModelList<PropertyEntry>, Collection<PropertyEntry>>(){

            public Collection<PropertyEntry> sourceToTarget(AbstractModelList<PropertyEntry> propertyEntries) {
                OozieJobExecutorJobEntryController.this.advancedArgumentsChanged = true;
                return propertyEntries;
            }

            public AbstractModelList<PropertyEntry> targetToSource(Collection<PropertyEntry> propertyEntries) {
                return null;
            }
        };
        bindings.add(bindingFactory.createBinding(this.advancedArguments, CHILDREN, (Object)this.variablesTree, ELEMENTS, new BindingConvertor[]{propsChangedBindingConvertor}));
    }

    @VisibleForTesting
    List<NamedCluster> getNamedClusters() {
        try {
            return ((OozieJobExecutorJobEntry)this.jobEntry).getNamedClusterService().list(this.jobMeta.getMetaStore());
        }
        catch (MetaStoreException e) {
            ((OozieJobExecutorJobEntry)this.jobEntry).logError(e.getMessage(), e);
            return Collections.emptyList();
        }
    }

    public void selectNamedCluster(String configName) {
        XulMenuList namedConfigMenu = (XulMenuList)this.container.getDocumentRoot().getElementById("named-clusters");
        for (NamedCluster nc : this.getNamedClusters()) {
            if (configName == null || !configName.equals(nc.getName())) continue;
            namedConfigMenu.setSelectedItem((Object)nc);
        }
    }

    public void editNamedCluster() {
        XulDialog xulDialog = (XulDialog)this.getXulDomContainer().getDocumentRoot().getElementById(OOZIE_JOB_EXECUTOR);
        Shell shell = (Shell)xulDialog.getRootObject();
        String clusterName = this.hadoopClusterDelegate.editNamedCluster(null, ((OozieJobExecutorConfig)this.config).getNamedCluster(), shell);
        if (clusterName != null) {
            this.populateNamedClusters();
            this.selectNamedCluster(clusterName);
        }
    }

    protected void populateNamedClusters() {
        ((OozieJobExecutorConfig)this.config).getNamedClusters().clear();
        ((OozieJobExecutorConfig)this.config).getNamedClusters().addAll(this.getNamedClusters());
    }

    public void newNamedCluster() {
        XulDialog xulDialog = (XulDialog)this.getXulDomContainer().getDocumentRoot().getElementById(OOZIE_JOB_EXECUTOR);
        Shell shell = (Shell)xulDialog.getRootObject();
        String newNamedCluster = this.hadoopClusterDelegate.newNamedCluster((VariableSpace)this.jobMeta, null, shell);
        if (newNamedCluster != null) {
            this.populateNamedClusters();
            this.selectNamedCluster(newNamedCluster);
        }
    }

    @Bindable
    public void addNewProperty() {
        this.advancedArgumentsChanged = true;
        try {
            this.advancedArguments.add((Object)new PropertyEntry("key", VALUE));
        }
        catch (Exception e) {
            this.variablesTree.setElements(this.advancedArguments);
        }
    }

    @Bindable
    public void removeProperty() {
        this.advancedArgumentsChanged = true;
        Collection selected = this.variablesTree.getSelectedItems();
        for (PropertyEntry pe : selected) {
            try {
                this.advancedArguments.remove((Object)pe);
            }
            catch (Exception e) {
                this.variablesTree.setElements(this.advancedArguments);
            }
        }
    }

    @Bindable
    public void accept() {
        this.syncModel();
        List<String> warnings = ((OozieJobExecutorJobEntry)this.jobEntry).getValidationWarnings((OozieJobExecutorConfig)this.getConfig(), false);
        if (!warnings.isEmpty()) {
            StringBuilder sb = new StringBuilder();
            for (String warning : warnings) {
                sb.append(warning).append("\n");
            }
            this.showErrorDialog(BaseMessages.getString(OozieJobExecutorJobEntry.class, (String)"ValidationError.Dialog.Title", (String[])new String[0]), sb.toString());
            return;
        }
        super.accept();
    }

    public AbstractModelList<PropertyEntry> getAdvancedArguments() {
        return this.advancedArguments;
    }

    public void setAdvancedArguments(AbstractModelList<PropertyEntry> advancedArguments) {
        this.advancedArgumentsChanged = true;
        this.advancedArguments = advancedArguments;
    }

    @Bindable
    public boolean isAdvancedArgumentsChanged() {
        return this.advancedArgumentsChanged;
    }

    protected String getDialogElementId() {
        return OOZIE_JOB_EXECUTOR;
    }

    @Bindable
    public String getModeToggleLabelElementId() {
        return MODE_TOGGLE_LABEL;
    }

    @Bindable
    public String getModeToggleLabel() {
        return this.modeToggleLabel;
    }

    @Bindable
    public void setModeToggleLabel(String modeToggleLabel) {
        String prev = this.modeToggleLabel;
        this.modeToggleLabel = modeToggleLabel;
        this.firePropertyChange("modeToggleLabel", prev, modeToggleLabel);
    }

    protected void setModeToggleLabel(JobEntryMode mode) {
        switch (mode) {
            case ADVANCED_LIST: {
                this.setModeToggleLabel(BaseMessages.getString(OozieJobExecutorJobEntry.class, (String)"Oozie.AdvancedOptions.Button.Text", (String[])new String[0]));
                break;
            }
            case QUICK_SETUP: {
                this.setModeToggleLabel(BaseMessages.getString(OozieJobExecutorJobEntry.class, (String)"Oozie.BasicOptions.Button.Text", (String[])new String[0]));
                break;
            }
            default: {
                throw new RuntimeException("unsupported JobEntryMode");
            }
        }
    }

    @Bindable
    public void testSettings() {
        this.syncModel();
        try {
            List<String> warnings = ((OozieJobExecutorJobEntry)this.jobEntry).getValidationWarnings((OozieJobExecutorConfig)this.getConfig());
            if (!warnings.isEmpty()) {
                StringBuilder sb = new StringBuilder();
                for (String warning : warnings) {
                    sb.append(warning).append("\n");
                }
                this.showErrorDialog(BaseMessages.getString(OozieJobExecutorJobEntry.class, (String)"ValidationError.Dialog.Title", (String[])new String[0]), sb.toString());
                return;
            }
        }
        catch (RuntimeException re) {
            this.showErrorDialog(BaseMessages.getString(OozieJobExecutorJobEntry.class, (String)"ValidationError.Dialog.Title", (String[])new String[0]), re.getMessage());
            throw re;
        }
        this.showInfoDialog(BaseMessages.getString(OozieJobExecutorJobEntry.class, (String)"Info.Dialog.Title", (String[])new String[0]), BaseMessages.getString(OozieJobExecutorJobEntry.class, (String)"ValidationMsg.OK", (String[])new String[0]));
    }

    @Bindable
    public void browseWorkflowConfig() {
        FileObject path = null;
        try {
            path = KettleVFS.getFileObject((String)((OozieJobExecutorJobEntry)this.jobEntry).getVariableSpace().environmentSubstitute(((OozieJobExecutorConfig)this.getConfig()).getOozieWorkflowConfig()));
        }
        catch (Exception exception) {
            // empty catch block
        }
        try {
            FileObject exportDir = this.browseVfs(null, path, 1, null, true, "file");
            if (exportDir != null) {
                ((OozieJobExecutorConfig)this.getConfig()).setOozieWorkflowConfig(exportDir.getName().getURI());
            }
        }
        catch (KettleFileException e) {
            ((OozieJobExecutorJobEntry)this.getJobEntry()).logError(BaseMessages.getString(OozieJobExecutorJobEntry.class, (String)ERROR_BROWSING_DIRECTORY, (String[])new String[0]), e);
        }
    }

    protected String[] getFileFilters() {
        return new String[]{"*.properties"};
    }

    protected String[] getFileFilterNames() {
        return new String[]{BaseMessages.getString(OozieJobExecutorJobEntry.class, (String)FILE_FILTER_NAMES_PROPERTIES, (String[])new String[0])};
    }
}

