/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.gateway.shell.job;

import com.jayway.jsonpath.Filter;
import com.jayway.jsonpath.JsonPath;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import java.util.concurrent.Callable;
import org.apache.hadoop.gateway.shell.AbstractRequest;
import org.apache.hadoop.gateway.shell.BasicResponse;
import org.apache.hadoop.gateway.shell.Hadoop;
import org.apache.http.HttpEntity;
import org.apache.http.HttpRequest;
import org.apache.http.HttpResponse;
import org.apache.http.NameValuePair;
import org.apache.http.client.entity.UrlEncodedFormEntity;
import org.apache.http.client.methods.HttpPost;
import org.apache.http.client.utils.URIBuilder;

public class Pig {

    public static class Response
    extends BasicResponse {
        protected Response(HttpResponse response) {
            super(response);
        }

        public String getJobId() throws IOException {
            return (String)JsonPath.read((String)this.getString(), (String)"$.id", (Filter[])new Filter[0]);
        }
    }

    public static class Request
    extends AbstractRequest<Response> {
        private String group;
        private String file;
        private String statusDir;
        List<NameValuePair> params = new ArrayList<NameValuePair>();

        public Request(Hadoop session) {
            super(session);
        }

        public Request group(String group) {
            this.group = group;
            return this;
        }

        public Request file(String file) {
            this.file = file;
            return this;
        }

        public Request arg(String value) {
            this.addParam(this.params, "arg", value);
            return this;
        }

        public Request statusDir(String dir) {
            this.statusDir = dir;
            return this;
        }

        @Override
        protected Callable<Response> callable() {
            return new Callable<Response>(){

                @Override
                public Response call() throws Exception {
                    URIBuilder uri = Request.this.uri(new String[]{"/templeton/v1", "/pig"});
                    Request.this.addParam(Request.this.params, "group", Request.this.group);
                    Request.this.addParam(Request.this.params, "file", Request.this.file);
                    Request.this.addParam(Request.this.params, "statusdir", Request.this.statusDir);
                    UrlEncodedFormEntity form = new UrlEncodedFormEntity(Request.this.params);
                    HttpPost request = new HttpPost(uri.build());
                    request.setEntity((HttpEntity)form);
                    return new Response((HttpResponse)Request.this.execute((HttpRequest)request));
                }
            };
        }
    }
}

